/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.CredentialsConfiguration;
import com.ibm.cics.core.comm.IPassphraseManager;
import com.ibm.cics.core.connections.ICredentialsManager;

public class PassphraseManager
implements IPassphraseManager {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(PassphraseManager.class);
    private ICredentialsManager credentialsManager;
    private String trustPhrase = "changeit";
    private String keyPhrase = "changeit";

    public PassphraseManager(ICredentialsManager credentialsManager) {
        this.credentialsManager = credentialsManager;
    }

    public String getTrustStorePassphrase() {
        debug.enter("getTrustStorePassphrase");
        CredentialsConfiguration tscredential = this.credentialsManager.findCredentialsConfigurationByID("javax.net.ssl.trustStorePassword");
        if (tscredential != null) {
            this.trustPhrase = tscredential.getPassword();
            System.setProperty("javax.net.ssl.trustStorePassword", this.trustPhrase);
        } else {
            this.setTrustStorePassphrase("changeit");
        }
        debug.exit("getTrustStorePassphrase");
        return this.trustPhrase;
    }

    public String getKeyStorePassphrase() {
        debug.enter("getKeyStorePassphrase");
        CredentialsConfiguration kscredential = this.credentialsManager.findCredentialsConfigurationByID("javax.net.ssl.keyStorePassword");
        if (kscredential != null) {
            this.keyPhrase = kscredential.getPassword();
            System.setProperty("javax.net.ssl.keyStorePassword", this.keyPhrase);
        } else {
            this.setKeyStorePassphrase("changeit");
        }
        debug.exit("getKeyStorePassphrase");
        return this.keyPhrase;
    }

    public void setTrustStorePassphrase(String phrase) {
        debug.enter("setTrustStorePassphrase");
        this.trustPhrase = phrase;
        CredentialsConfiguration tscredential = this.credentialsManager.findCredentialsConfigurationByID("javax.net.ssl.trustStorePassword");
        if (tscredential == null) {
            tscredential = new CredentialsConfiguration("javax.net.ssl.trustStorePassword", "javax.net.ssl.trustStorePassword", "javax.net.ssl.trustStorePassword", phrase, true);
        } else {
            tscredential.setPassword(phrase);
        }
        this.credentialsManager.update(tscredential);
        System.setProperty("javax.net.ssl.trustStorePassword", phrase);
        debug.exit("setTrustStorePassphrase");
    }

    public void setKeyStorePassphrase(String phrase) {
        debug.enter("setKeyStorePassphrase");
        this.keyPhrase = phrase;
        CredentialsConfiguration kscredential = this.credentialsManager.findCredentialsConfigurationByID("javax.net.ssl.keyStorePassword");
        if (kscredential == null) {
            kscredential = new CredentialsConfiguration("javax.net.ssl.keyStorePassword", "javax.net.ssl.keyStorePassword", "javax.net.ssl.keyStorePassword", phrase, true);
        } else {
            kscredential.setPassword(phrase);
        }
        this.credentialsManager.update(kscredential);
        System.setProperty("javax.net.ssl.keyStorePassword", phrase);
        debug.exit("setKeyStorePassphrase");
    }
}

