/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections;

import com.ibm.cics.core.connections.internal.IConnectionParameters;
import java.util.Arrays;
import java.util.List;

public class ConfigurationUtils {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static boolean isSecureHint(IConnectionParameters config) {
        String secureHint = config.getAttribute("ATTEMPT_SECURE");
        return Boolean.parseBoolean(secureHint);
    }

    public static boolean isSecureConfirmed(IConnectionParameters config) {
        String securityConfirmed = config.getAttribute("ssl_confirmed");
        return Boolean.parseBoolean(securityConfirmed);
    }

    public static String getHost(IConnectionParameters config) {
        return config.getAttribute("host");
    }

    public static int getPort(IConnectionParameters config) {
        String port = config.getAttribute("port");
        try {
            return Integer.parseInt(port);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static List<String> getPotentialExternalIds(String legacyInternalId, String connectionTypeId) {
        return Arrays.asList(String.valueOf(legacyInternalId) + '@' + "local", String.valueOf(legacyInternalId) + ':' + connectionTypeId + '@' + "local");
    }

    public static boolean isExternalId(String id) {
        return id.indexOf(64) != -1;
    }

    public static String getProviderId(String id) {
        if (ConfigurationUtils.isExternalId(id)) {
            return id.substring(id.lastIndexOf(64) + 1);
        }
        throw new IllegalArgumentException("<" + id + "> was not an external ID");
    }

    public static boolean isLocalProviderExternalId(String id) {
        if (ConfigurationUtils.isExternalId(id)) {
            String providerId = ConfigurationUtils.getProviderId(id);
            return "local".equals(providerId);
        }
        return false;
    }

    public static String getInternalId(String id) {
        if (ConfigurationUtils.isExternalId(id)) {
            return id.substring(0, id.lastIndexOf(64));
        }
        return id;
    }
}

