/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.core.comm.Activator;
import com.ibm.cics.core.comm.ExplorerSecurityHelper;
import com.ibm.cics.core.connections.internal.InternalConnectionsPlugin;
import com.ibm.cics.core.connections.internal.Messages;
import com.ibm.cics.eclipse.common.ui.TextInput;
import java.io.File;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class CertificatesPreference
extends PreferencePage
implements IWorkbenchPreferencePage {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2012, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(CertificatesPreference.class);
    private static final String[] DBTYPES = new String[]{"JKS", "JCEKS", "PKCS12"};
    private static final String[] PROTOCOLS = new String[]{Messages.CertificatesPreference_default, "SSLv2", "TLSv1", "TLSv1.1", "TLSv1.2"};
    private static final String DBTYPE_DEFAULT = "JKS";
    private Text trustFileText;
    private Text trustPhraseText;
    private Text keyPhraseText;
    private Text keyFileText;
    private Combo keycombo;
    private Combo trustcombo;
    private Button useSameForBoth;
    private Button disableCheckBox;
    private Group trustGroup;
    private Group keyGroup;
    private Button trustBrowseButton;
    private Button keyBrowseButton;
    private Combo protocolCombo;
    private boolean canValidate = false;
    private Label keylabel2;
    private Label keylabel3;
    private Label keylabel4;

    public CertificatesPreference() {
    }

    public CertificatesPreference(String title) {
        super(title);
    }

    public CertificatesPreference(String title, ImageDescriptor image) {
        super(title, image);
    }

    public void init(IWorkbench workbench) {
        debug.enter("init");
        this.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore(InstanceScope.INSTANCE, Activator.getDefault().getBundle().getSymbolicName()));
        debug.exit("init");
    }

    protected Control createContents(Composite parent) {
        debug.enter("createContents");
        this.canValidate = false;
        Composite major = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        major.setLayout((Layout)layout);
        major.setLayoutData((Object)new GridData(768));
        Composite composite = new Composite(major, 0);
        layout = new GridLayout();
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        Text t3l1 = new Text(composite, 16392);
        t3l1.setText(Messages.CertificatesPreference_description);
        this.disableCheckBox = new Button(composite, 32);
        this.disableCheckBox.setText(Messages.CertificatesPreference_disable);
        this.disableCheckBox.setToolTipText(Messages.CertificatesPreference_disable_tooltip);
        this.disableCheckBox.setLayoutData((Object)new GridData(768));
        this.trustGroup = new Group(composite, 0);
        this.trustGroup.setText(Messages.CertificatesPreference_trust_store_detail);
        this.trustGroup.setLayoutData((Object)new GridData(768));
        layout = new GridLayout();
        layout.numColumns = 4;
        this.trustGroup.setLayout((Layout)layout);
        this.trustGroup.setLayoutData((Object)new GridData(768));
        GridData data = new GridData();
        Text tl1 = new Text((Composite)this.trustGroup, 16392);
        tl1.setText(Messages.CertificatesPreference_trust_store_contains);
        data.horizontalSpan = 4;
        tl1.setLayoutData((Object)data);
        Label l = new Label((Composite)this.trustGroup, 16384);
        l.setText(Messages.CertificatesPreference_File_name);
        this.trustFileText = new Text((Composite)this.trustGroup, 2048);
        TextInput.setAccessibleLabel((Text)this.trustFileText, (Label)l);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.trustFileText.setLayoutData((Object)data);
        this.trustFileText.setToolTipText(Messages.CertificatesPreference_trust_store_contains);
        this.trustFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (CertificatesPreference.this.useSameForBoth.getSelection()) {
                    CertificatesPreference.this.keyFileText.setText(CertificatesPreference.this.trustFileText.getText());
                }
                CertificatesPreference.this.validate();
            }
        });
        this.trustBrowseButton = new Button((Composite)this.trustGroup, 0);
        this.trustBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CertificatesPreference.this.trustBrowse();
            }
        });
        this.trustBrowseButton.setText(Messages.CertificatesPreference_browse);
        this.trustBrowseButton.setToolTipText(Messages.CertificatesPreference_browse_tooltip);
        data = new GridData();
        data.horizontalAlignment = 4;
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, this.trustBrowseButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.trustBrowseButton.setLayoutData((Object)data);
        this.trustBrowseButton.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                CertificatesPreference.this.trustBrowse();
            }
        });
        l = new Label((Composite)this.trustGroup, 16384);
        l.setText(Messages.CertificatesPreference_passphrase);
        this.trustPhraseText = new Text((Composite)this.trustGroup, 0x400800);
        TextInput.setAccessibleLabel((Text)this.trustFileText, (Label)l);
        data = new GridData(768);
        this.trustPhraseText.setLayoutData((Object)data);
        this.trustPhraseText.setToolTipText(Messages.CertificatesPreference_passphrase);
        this.trustPhraseText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (CertificatesPreference.this.useSameForBoth.getSelection()) {
                    CertificatesPreference.this.keyPhraseText.setText(CertificatesPreference.this.trustPhraseText.getText());
                }
                CertificatesPreference.this.validate();
            }
        });
        new Label((Composite)this.trustGroup, 16384).setText(Messages.CertificatesPreference_dbtype);
        this.trustcombo = new Combo((Composite)this.trustGroup, 4);
        this.trustcombo.setItems(DBTYPES);
        this.trustcombo.setText(DBTYPE_DEFAULT);
        this.trustcombo.setToolTipText(Messages.CertificatesPreference_dbtype_tooltip);
        this.trustcombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CertificatesPreference.this.useSameForBoth.getSelection()) {
                    CertificatesPreference.this.keycombo.setText(CertificatesPreference.this.trustcombo.getText());
                }
                CertificatesPreference.this.validate();
            }
        });
        this.keyGroup = new Group(composite, 0);
        this.keyGroup.setText(Messages.CertificatesPreference_key_store_detail);
        data = new GridData(4);
        this.keyGroup.setLayoutData((Object)new GridData(768));
        layout = new GridLayout();
        layout.numColumns = 4;
        this.keyGroup.setLayout((Layout)layout);
        this.keyGroup.setLayoutData((Object)new GridData(768));
        data = new GridData();
        Text kl1 = new Text((Composite)this.keyGroup, 16392);
        kl1.setText(Messages.CertificatesPreference_key_store_contains);
        data.horizontalSpan = 4;
        kl1.setLayoutData((Object)data);
        this.useSameForBoth = new Button((Composite)this.keyGroup, 32);
        this.useSameForBoth.setText(Messages.CertificatesPreference_use_same);
        this.useSameForBoth.setToolTipText(Messages.CertificatesPreference_use_same_tooltip);
        data = new GridData();
        data.horizontalSpan = 4;
        this.useSameForBoth.setLayoutData((Object)data);
        data = new GridData();
        this.keylabel2 = new Label((Composite)this.keyGroup, 16384);
        this.keylabel2.setText(Messages.CertificatesPreference_File_name);
        this.keyFileText = new Text((Composite)this.keyGroup, 2048);
        TextInput.setAccessibleLabel((Text)this.keyFileText, (Label)this.keylabel2);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.keyFileText.setLayoutData((Object)data);
        this.keyFileText.setToolTipText(Messages.CertificatesPreference_key_store_contains);
        this.keyFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CertificatesPreference.this.validate();
            }
        });
        this.keyBrowseButton = new Button((Composite)this.keyGroup, 0);
        this.keyBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CertificatesPreference.this.keyBrowse();
            }
        });
        this.keyBrowseButton.setText(Messages.CertificatesPreference_browse);
        this.keyBrowseButton.setToolTipText(Messages.CertificatesPreference_browse_tooltip);
        data = new GridData();
        data.horizontalAlignment = 4;
        widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, this.trustBrowseButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.keyBrowseButton.setLayoutData((Object)data);
        this.keyBrowseButton.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                CertificatesPreference.this.keyBrowse();
            }
        });
        this.keylabel3 = new Label((Composite)this.keyGroup, 16384);
        this.keylabel3.setText(Messages.CertificatesPreference_passphrase);
        this.keyPhraseText = new Text((Composite)this.keyGroup, 0x400800);
        TextInput.setAccessibleLabel((Text)this.keyPhraseText, (Label)this.keylabel3);
        data = new GridData(768);
        this.keyPhraseText.setLayoutData((Object)data);
        this.keyPhraseText.setToolTipText(Messages.CertificatesPreference_passphrase);
        this.keyPhraseText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CertificatesPreference.this.validate();
            }
        });
        this.keylabel4 = new Label((Composite)this.keyGroup, 16384);
        this.keylabel4.setText(Messages.CertificatesPreference_dbtype);
        this.keycombo = new Combo((Composite)this.keyGroup, 4);
        this.keycombo.setItems(DBTYPES);
        this.keycombo.setText(DBTYPE_DEFAULT);
        this.keycombo.setToolTipText(Messages.CertificatesPreference_dbtype_tooltip);
        this.keycombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CertificatesPreference.this.validate();
            }
        });
        this.useSameForBoth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CertificatesPreference.this.keyFileText.setEnabled(!((Button)e.getSource()).getSelection());
                CertificatesPreference.this.keyFileText.setText(CertificatesPreference.this.trustFileText.getText());
                CertificatesPreference.this.keyBrowseButton.setEnabled(!((Button)e.getSource()).getSelection());
                CertificatesPreference.this.keyPhraseText.setEnabled(!((Button)e.getSource()).getSelection());
                CertificatesPreference.this.keyPhraseText.setText(CertificatesPreference.this.trustPhraseText.getText());
                CertificatesPreference.this.keycombo.setEnabled(!((Button)e.getSource()).getSelection());
                CertificatesPreference.this.keycombo.setText(CertificatesPreference.this.trustcombo.getText());
                CertificatesPreference.this.validate();
            }
        });
        this.disableCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CertificatesPreference.this.enablementChecks(!((Button)e.getSource()).getSelection());
                CertificatesPreference.this.validate();
            }
        });
        Group protocolGroup = new Group(parent, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 5;
        layout.numColumns = 2;
        protocolGroup.setLayout((Layout)layout);
        protocolGroup.setLayoutData((Object)new GridData(1808));
        protocolGroup.setText(Messages.CertificatesPreference_advanced);
        Text pgroupdescription = new Text((Composite)protocolGroup, 16394);
        pgroupdescription.setText(Messages.CertificatesPreference_advanced_message);
        GridData pgdLayoutdata = new GridData();
        pgdLayoutdata.horizontalSpan = 2;
        pgroupdescription.setLayoutData((Object)pgdLayoutdata);
        Label pgroupLabel = new Label((Composite)protocolGroup, 16384);
        pgroupLabel.setText(Messages.CertificatesPreference_protocol);
        this.protocolCombo = new Combo((Composite)protocolGroup, 2048);
        this.protocolCombo.setText(Messages.CertificatesPreference_default);
        this.protocolCombo.setItems(PROTOCOLS);
        this.protocolCombo.setToolTipText(Messages.CertificatesPreference_protocol_tooltip);
        IPreferenceStore store = this.getPreferenceStore();
        this.trustFileText.setText(store.getString("javax.net.ssl.trustStore"));
        this.trustPhraseText.setText(InternalConnectionsPlugin.getDefault().getPassphraseManager().getTrustStorePassphrase());
        this.trustcombo.setText(store.getString("com.ibm.cics.core.comm.truststore.dbType"));
        this.keyFileText.setText(store.getString("javax.net.ssl.keyStore"));
        this.keyPhraseText.setText(InternalConnectionsPlugin.getDefault().getPassphraseManager().getKeyStorePassphrase());
        this.keycombo.setText(store.getString("com.ibm.cics.core.comm.keystore.dbType"));
        this.useSameForBoth.setSelection(store.getBoolean("com.ibm.cics.core.comm.truststore.same"));
        this.disableCheckBox.setSelection(store.getBoolean("com.ibm.cics.core.comm.truststore.ignore"));
        String protoc = store.getString("com.ibm.cics.core.comm.security.protocol");
        if (protoc.equals("")) {
            protoc = Messages.CertificatesPreference_default;
        }
        this.protocolCombo.setText(protoc);
        this.enablementChecks(!this.disableCheckBox.getSelection());
        this.validationEnabled();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getHelpContextID());
        debug.exit("createContents");
        return composite;
    }

    private String getHelpContextID() {
        return "com.ibm.cics.explorer.connection_certificate_management_preferences";
    }

    private void validationEnabled() {
        this.canValidate = true;
        this.validate();
    }

    private boolean validate() {
        debug.enter("validate");
        String message = "";
        if (this.canValidate) {
            if (!this.disableCheckBox.getSelection()) {
                message = ExplorerSecurityHelper.validateStoreDetail((String)this.trustFileText.getText(), (String)this.trustPhraseText.getText(), (String)this.trustcombo.getText(), (String)this.keyFileText.getText(), (String)this.keyPhraseText.getText(), (String)this.keycombo.getText());
            }
            if ("Invalid_store_format_message".equals(message)) {
                this.setValid(false);
                this.setErrorMessage(Messages.Invalid_store_format_message);
            } else if (StringUtil.hasContent((String)message)) {
                if (!StringUtil.hasContent((String)message) || message.startsWith("DerInputStream") || message.startsWith("java.io.EOFException")) {
                    message = Messages.Invalid_keystore_format;
                }
                this.setValid(false);
                this.setErrorMessage(message);
            } else {
                this.setValid(true);
                this.setErrorMessage(null);
                this.setMessage(Messages.CertificatesPreference_message);
            }
        }
        debug.exit("validate", (Object)message);
        return !StringUtil.hasContent((String)message);
    }

    public boolean performOk() {
        debug.enter("performOk");
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("javax.net.ssl.trustStore", this.trustFileText.getText());
        store.setValue("com.ibm.cics.core.comm.truststore.dbType", this.trustcombo.getText());
        store.setValue("javax.net.ssl.keyStore", this.keyFileText.getText());
        store.setValue("com.ibm.cics.core.comm.keystore.dbType", this.keycombo.getText());
        store.setValue("com.ibm.cics.core.comm.truststore.same", this.useSameForBoth.getSelection());
        store.setValue("com.ibm.cics.core.comm.truststore.ignore", this.disableCheckBox.getSelection());
        String protoc = this.protocolCombo.getText().trim();
        if (protoc.equals(Messages.CertificatesPreference_default)) {
            protoc = "";
        }
        store.setValue("com.ibm.cics.core.comm.security.protocol", protoc);
        InternalConnectionsPlugin.getDefault().getPassphraseManager().setTrustStorePassphrase(this.trustPhraseText.getText());
        InternalConnectionsPlugin.getDefault().getPassphraseManager().setKeyStorePassphrase(this.keyPhraseText.getText());
        System.setProperty("javax.net.ssl.keyStore", Platform.getPreferencesService().getString(Activator.getDefault().getBundle().getSymbolicName(), "javax.net.ssl.keyStore", null, null));
        System.setProperty("javax.net.ssl.trustStore", Platform.getPreferencesService().getString(Activator.getDefault().getBundle().getSymbolicName(), "javax.net.ssl.trustStore", null, null));
        debug.exit("performOk", (Object)true);
        return true;
    }

    public void performDefaults() {
        debug.enter("performDefaults");
        this.canValidate = false;
        IPreferenceStore store = this.getPreferenceStore();
        this.trustFileText.setText(store.getDefaultString("javax.net.ssl.trustStore"));
        this.trustPhraseText.setText(InternalConnectionsPlugin.getDefault().getPassphraseManager().getTrustStorePassphrase());
        this.trustcombo.setText(store.getDefaultString("com.ibm.cics.core.comm.truststore.dbType"));
        this.useSameForBoth.setSelection(store.getDefaultBoolean("com.ibm.cics.core.comm.truststore.same"));
        this.keyFileText.setText(store.getDefaultString("javax.net.ssl.keyStore"));
        this.keyPhraseText.setText(InternalConnectionsPlugin.getDefault().getPassphraseManager().getKeyStorePassphrase());
        this.keycombo.setText(store.getDefaultString("com.ibm.cics.core.comm.keystore.dbType"));
        this.disableCheckBox.setSelection(store.getDefaultBoolean("com.ibm.cics.core.comm.truststore.ignore"));
        String protoc = store.getDefaultString("com.ibm.cics.core.comm.security.protocol");
        if (protoc.equals("")) {
            protoc = Messages.CertificatesPreference_default;
        }
        this.protocolCombo.setText(protoc);
        this.enablementChecks(!this.disableCheckBox.getSelection());
        this.validationEnabled();
        System.setProperty("javax.net.ssl.keyStore", Platform.getPreferencesService().getString(Activator.getDefault().getBundle().getSymbolicName(), "javax.net.ssl.keyStore", null, null));
        System.setProperty("javax.net.ssl.trustStore", Platform.getPreferencesService().getString(Activator.getDefault().getBundle().getSymbolicName(), "javax.net.ssl.trustStore", null, null));
        debug.exit("performDefaults");
    }

    private void enablementChecks(boolean childselection) {
        debug.enter("enablementChecks", (Object)childselection);
        this.trustGroup.setEnabled(childselection);
        this.trustFileText.setEnabled(childselection);
        this.trustPhraseText.setEnabled(childselection);
        this.trustBrowseButton.setEnabled(childselection);
        this.trustcombo.setEnabled(childselection);
        this.keyGroup.setEnabled(childselection);
        this.keyFileText.setEnabled(childselection && !this.useSameForBoth.getSelection());
        this.keyPhraseText.setEnabled(childselection && !this.useSameForBoth.getSelection());
        this.keyBrowseButton.setEnabled(childselection && !this.useSameForBoth.getSelection());
        this.keycombo.setEnabled(childselection && !this.useSameForBoth.getSelection());
        this.useSameForBoth.setEnabled(childselection);
        debug.exit("enablementChecks");
    }

    private void trustBrowse() {
        FileDialog d = new FileDialog(this.getShell());
        d.setText(Messages.CertificatesPreference_trust_file);
        String p = "";
        if (new File(this.trustFileText.getText()).getParentFile() != null) {
            p = new File(this.trustFileText.getText()).getParentFile().toString();
        }
        d.setFilterPath(p);
        String file = d.open();
        if (file != null) {
            this.trustFileText.setText(file);
            this.validate();
        }
    }

    private void keyBrowse() {
        FileDialog d = new FileDialog(this.getShell());
        d.setText(Messages.CertificatesPreference_key_file);
        String p = "";
        if (new File(this.keyFileText.getText()).getParentFile() != null) {
            p = new File(this.keyFileText.getText()).getParentFile().toString();
        }
        d.setFilterPath(p);
        String file = d.open();
        if (file != null) {
            this.keyFileText.setText(file);
        }
    }

    public void dispose() {
        super.dispose();
    }
}

