/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.core.connections.ConnectionParameters;
import com.ibm.cics.core.connections.internal.ConnectionsXMLSerializer;
import com.ibm.cics.core.connections.internal.IConnectionDeserializer;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;

public class FileConnectionXMLDeserializer
implements IConnectionDeserializer {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public IPath location;

    public FileConnectionXMLDeserializer(IPath location) {
        this.location = location;
    }

    @Override
    public List<ConnectionParameters> load() throws IOException {
        ArrayList<ConnectionParameters> connections = new ArrayList<ConnectionParameters>();
        InputStream is = null;
        try {
            is = new FileInputStream(this.location.toOSString());
            is = new BufferedInputStream(is);
            List<ConnectionParameters> list = ConnectionsXMLSerializer.read(is);
            return list;
        }
        catch (FileNotFoundException fileNotFoundException) {
            ArrayList<ConnectionParameters> arrayList = connections;
            return arrayList;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }
}

