/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal.views;

import com.ibm.cics.core.comm.ConnectionRegistry;
import com.ibm.cics.core.comm.IConnectionCategory;
import com.ibm.cics.core.comm.IConnectionDescriptor;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.IConnectionProvider;
import com.ibm.cics.core.connections.IConnectionService;
import com.ibm.cics.core.connections.internal.ConnectionProviderRegistry;
import com.ibm.cics.core.connections.internal.FilteredConnectionRegistry;
import com.ibm.cics.core.connections.internal.views.ConnectionProviderDescriptorNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ConnectionsContentProvider
implements ITreeContentProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2012, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Map<String, Collection<IConnectionDescriptor>> categoriesToDescriptors = new HashMap<String, Collection<IConnectionDescriptor>>();
    private List<IConnectionCategory> categories = new ArrayList<IConnectionCategory>();
    private Map<IConnectionDescriptor, List<ConnectionProfile>> descriptorsToConfigurations = new HashMap<IConnectionDescriptor, List<ConnectionProfile>>();
    private Map<IConnectionProvider, Map<IConnectionDescriptor, List<ConnectionProfile>>> providersToDescriptorsToCategories = new HashMap<IConnectionProvider, Map<IConnectionDescriptor, List<ConnectionProfile>>>();
    private boolean showProviders;
    private FilteredConnectionRegistry connectionRegistry = new FilteredConnectionRegistry(ConnectionRegistry.getConnectionRegistry());

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput != null) {
            this.setConnectionConfigurations(((IConnectionService)newInput).getConnectionManager().getConnectionProfilesByDescriptor());
        }
    }

    private void calculateCategoriesToDescriptors() {
        this.categoriesToDescriptors.clear();
        this.categories.clear();
        List<IConnectionDescriptor> allConnectionDescriptors = Arrays.asList(this.connectionRegistry.getConnections());
        IConnectionCategory[] iConnectionCategoryArray = ConnectionRegistry.getConnectionRegistry().getConnectionCategories();
        int n = iConnectionCategoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectionCategory connectionCategory = iConnectionCategoryArray[n2];
            List<IConnectionDescriptor> connectionDescriptors = Arrays.asList(connectionCategory.getConnections());
            ArrayList<IConnectionDescriptor> connectionDescriptorsToInclude = new ArrayList<IConnectionDescriptor>();
            connectionDescriptorsToInclude.addAll(connectionDescriptors);
            for (IConnectionDescriptor connectionDescriptor : connectionDescriptors) {
                if (allConnectionDescriptors.contains(connectionDescriptor)) continue;
                connectionDescriptorsToInclude.remove(connectionDescriptor);
            }
            if (connectionDescriptorsToInclude.size() > 0) {
                this.categoriesToDescriptors.put(connectionCategory.getId(), connectionDescriptorsToInclude);
                this.categories.add(connectionCategory);
            }
            ++n2;
        }
    }

    private void setConnectionConfigurations(Map<IConnectionDescriptor, List<ConnectionProfile>> map) {
        this.calculateCategoriesToDescriptors();
        this.descriptorsToConfigurations.clear();
        this.providersToDescriptorsToCategories.clear();
        FilteredConnectionRegistry filteredRegistry = new FilteredConnectionRegistry(ConnectionRegistry.getConnectionRegistry());
        for (Map.Entry<IConnectionDescriptor, List<ConnectionProfile>> entry : map.entrySet()) {
            if (filteredRegistry.find(entry.getKey().getId()) == null) continue;
            String category = entry.getKey().getCategory().getId();
            Collection<IConnectionDescriptor> connectionDescriptors = this.categoriesToDescriptors.get(category);
            if (connectionDescriptors == null) {
                connectionDescriptors = new ArrayList<IConnectionDescriptor>();
                this.categoriesToDescriptors.put(category, connectionDescriptors);
            }
            if (!connectionDescriptors.contains(entry.getKey())) {
                connectionDescriptors.add(entry.getKey());
            }
            for (ConnectionProfile configuration : entry.getValue()) {
                IConnectionDescriptor connectionDescriptor;
                List<ConnectionProfile> configurationsForDescriptor;
                Map<IConnectionDescriptor, List<ConnectionProfile>> descriptorsToConfigurations = this.providersToDescriptorsToCategories.get(configuration.getConnectionProvider());
                if (descriptorsToConfigurations == null) {
                    descriptorsToConfigurations = new HashMap<IConnectionDescriptor, List<ConnectionProfile>>();
                    this.providersToDescriptorsToCategories.put(configuration.getConnectionProvider(), descriptorsToConfigurations);
                }
                if ((configurationsForDescriptor = descriptorsToConfigurations.get(connectionDescriptor = configuration.getConnectionDescriptor())) == null) {
                    configurationsForDescriptor = new ArrayList<ConnectionProfile>();
                    descriptorsToConfigurations.put(connectionDescriptor, configurationsForDescriptor);
                }
                configurationsForDescriptor.add(configuration);
            }
            this.descriptorsToConfigurations.put(entry.getKey(), entry.getValue());
        }
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        ConnectionProviderDescriptorNode descriptorAndProviderNode;
        if (parentElement instanceof IConnectionService) {
            if (this.showProviders) {
                return ConnectionProviderRegistry.getDefault().getConnectionProviders().toArray();
            }
            return this.categories.toArray();
        }
        if (parentElement instanceof IConnectionCategory) {
            String categoryID = ((IConnectionCategory)parentElement).getId();
            Collection<IConnectionDescriptor> descriptors = this.categoriesToDescriptors.get(categoryID);
            if (descriptors == null) {
                return new Object[0];
            }
            if (descriptors.size() == 1) {
                List<ConnectionProfile> collection = this.descriptorsToConfigurations.get(descriptors.iterator().next());
                return collection == null ? new Object[]{} : collection.toArray();
            }
            return descriptors.toArray();
        }
        if (parentElement instanceof IConnectionDescriptor) {
            List<ConnectionProfile> configurations = this.descriptorsToConfigurations.get(parentElement);
            return configurations == null ? new Object[]{} : configurations.toArray();
        }
        if (parentElement instanceof IConnectionProvider) {
            Map<IConnectionDescriptor, List<ConnectionProfile>> descriptorsToConfigurationsForProvider = this.providersToDescriptorsToCategories.get(parentElement);
            ArrayList<ConnectionProviderDescriptorNode> result = new ArrayList<ConnectionProviderDescriptorNode>();
            if (descriptorsToConfigurationsForProvider == null) {
                return result.toArray();
            }
            for (IConnectionDescriptor connectionDescriptor : descriptorsToConfigurationsForProvider.keySet()) {
                ConnectionProviderDescriptorNode node = new ConnectionProviderDescriptorNode(connectionDescriptor, (IConnectionProvider)parentElement);
                Map<IConnectionDescriptor, List<ConnectionProfile>> descriptorToConfigurationsForProvider = this.providersToDescriptorsToCategories.get(parentElement);
                node.setConfigurations((Collection<ConnectionProfile>)descriptorToConfigurationsForProvider.get(connectionDescriptor));
                result.add(node);
            }
            return result.toArray();
        }
        if (parentElement instanceof ConnectionProviderDescriptorNode && (descriptorAndProviderNode = (ConnectionProviderDescriptorNode)parentElement).getConfigurations() != null) {
            return descriptorAndProviderNode.getConfigurations().toArray();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IConnectionService) {
            return !this.categoriesToDescriptors.isEmpty();
        }
        return this.getChildren(element).length > 0;
    }

    public void setShowProviders(boolean showProviders) {
        this.showProviders = showProviders;
    }
}

