/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal.views;

import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.cics.core.comm.CredentialsConfiguration;
import com.ibm.cics.core.comm.IConnectable;
import com.ibm.cics.core.comm.IConnectionCategory;
import com.ibm.cics.core.comm.IConnectionDescriptor;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.ConnectionsImages;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.IConnectionProvider;
import com.ibm.cics.core.connections.IConnectionService;
import com.ibm.cics.core.connections.IConnectionState;
import com.ibm.cics.core.connections.IWritableConnectionProvider;
import com.ibm.cics.core.connections.internal.ConnectedState;
import com.ibm.cics.core.connections.internal.ConnectionProviderRegistry;
import com.ibm.cics.core.connections.internal.ExplorerConnectionProvider;
import com.ibm.cics.core.connections.internal.NoConnection;
import com.ibm.cics.core.connections.internal.views.ConnectionProviderDescriptorNode;
import com.ibm.cics.core.connections.internal.views.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ConnectionsLabelProvider
extends CellLabelProvider
implements ILabelProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2012, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IConnectionService connectionService = ConnectionsPlugin.getDefault().getConnectionService();
    private ConnectionProviderRegistry connectionProviderRegistry = ConnectionProviderRegistry.getDefault();

    public String getDetails(Object element) {
        if (element instanceof IConnectionCategory) {
            return ((IConnectionCategory)element).getName();
        }
        if (element instanceof IConnectionDescriptor) {
            return ((IConnectionDescriptor)element).getName();
        }
        if (element instanceof ConnectionProfile) {
            return ((ConnectionProfile)element).getName();
        }
        if (element instanceof IConnectionProvider) {
            if (element == this.connectionProviderRegistry.getLocalConnectionProvider()) {
                return Messages.ConnectionProvider_My_Connections_Workspace;
            }
            return ((IConnectionProvider)element).getDescription();
        }
        if (element instanceof ConnectionProviderDescriptorNode) {
            return ((ConnectionProviderDescriptorNode)element).connectionDescriptor.getName();
        }
        return "";
    }

    public void refreshLabels() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Object[] objectArray = ConnectionsLabelProvider.this.getListeners();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object listener = objectArray[n2];
                    ILabelProviderListener labelProviderListener = (ILabelProviderListener)listener;
                    labelProviderListener.labelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)ConnectionsLabelProvider.this));
                    ++n2;
                }
            }
        });
    }

    public void update(ViewerCell cell) {
        int columnIndex = cell.getColumnIndex();
        if (columnIndex == 0) {
            cell.setText(this.getDetails(cell.getElement()));
            cell.setImage(this.getImage(cell.getElement()));
        } else if (columnIndex == 1) {
            Object element = cell.getElement();
            if (element instanceof ConnectionProfile) {
                CredentialsConfiguration credentials = ((ConnectionProfile)element).getCredentials();
                if (credentials == null) {
                    cell.setText("");
                } else {
                    cell.setText(ConnectionsLabelProvider.format(credentials));
                }
            } else {
                cell.setText("");
            }
        }
    }

    public static String format(CredentialsConfiguration aCredentialsConfiguration) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(aCredentialsConfiguration.getName());
        buffer.append(" (");
        buffer.append(aCredentialsConfiguration.getUserID());
        buffer.append(") ");
        return buffer.toString();
    }

    public Image getImage(Object element) {
        if (element instanceof ConnectionProfile) {
            ConnectionProfile configuration = (ConnectionProfile)element;
            IConnectionState connectionState = this.connectionService.getConnectionState(configuration);
            Image rawImage = connectionState.getImage();
            if (configuration.getConnectionProvider() != this.connectionProviderRegistry.getLocalConnectionProvider()) {
                return ConnectionsImages.getWithLinkedOverlay(rawImage);
            }
            return rawImage;
        }
        if (element instanceof ConnectionProviderDescriptorNode) {
            for (ConnectionProfile conf : ((ConnectionProviderDescriptorNode)element).getConfigurations()) {
                IConnectionState state = this.connectionService.getConnectionState(conf);
                if (!(state instanceof ConnectedState)) continue;
                return state.getImage();
            }
            return ConnectionsImages.getImage("IN_ACTIVE_CONNECTION");
        }
        if (element instanceof IConnectionDescriptor) {
            return this.getImage((IConnectionDescriptor)element);
        }
        if (element instanceof IConnectionCategory) {
            IConnectionCategory connectionCategory = (IConnectionCategory)element;
            Image connectionImage = ConnectionsImages.getImage(connectionCategory);
            if (connectionImage != null) {
                return connectionImage;
            }
            String categoryId = connectionCategory.getId();
            IConnectable connectable = this.connectionService.getConnectable(categoryId);
            if (connectable != null && connectable.getConnection() != null) {
                IConnectionState state = this.connectionService.getConnectionState(categoryId);
                return state.getImage();
            }
            return ConnectionsImages.getImage("IN_ACTIVE_CONNECTION");
        }
        if (element instanceof IConnectionProvider) {
            return this.getImage((IConnectionProvider)element);
        }
        return null;
    }

    protected Image getImage(IConnectionDescriptor aConnectionDescriptor) {
        String connectionCategory = aConnectionDescriptor.getCategory().getId();
        IConnectionState connectionState = this.connectionService.getConnectionState(connectionCategory);
        if (!(connectionState instanceof NoConnection) && connectionState.getConnectionProfile().getConnectionDescriptor() == aConnectionDescriptor) {
            return connectionState.getImage();
        }
        return ConnectionsImages.getImage("IN_ACTIVE_CONNECTION");
    }

    private Image getImage(IConnectionProvider aConnectionProvider) {
        IStatus providerStatus;
        Image providerImage = null;
        providerImage = aConnectionProvider instanceof ExplorerConnectionProvider ? ConnectionsImages.getImage("PRESET_CONNECTIONS") : ConnectionsImages.getImage("CONNECTION_PROVIDER");
        if (aConnectionProvider instanceof IWritableConnectionProvider) {
            providerImage = ConnectionsImages.getWithUserOverlay(providerImage);
        }
        if ((providerStatus = this.connectionProviderRegistry.getConnectionProviderStatus(aConnectionProvider)).getSeverity() >= 4) {
            providerImage = ConnectionsImages.getWithErrorOverlay(providerImage);
        } else if (providerStatus.getSeverity() >= 2) {
            providerImage = ConnectionsImages.getWithWarningOverlay(providerImage);
        }
        return providerImage;
    }

    public String getText(Object element) {
        return this.getDetails(element);
    }

    public String toFilterString(ConnectionConfiguration element) {
        StringBuffer buffer = new StringBuffer();
        ConnectionConfiguration aConnectionConfiguration = element;
        buffer.append(this.getDetails(element));
        if (StringUtil.hasContent((String)aConnectionConfiguration.getCredentialsID())) {
            String credentialsID = aConnectionConfiguration.getCredentialsID();
            CredentialsConfiguration credentialsConfiguration = ConnectionsPlugin.getDefault().getCredentialsManager().findCredentialsConfigurationByID(credentialsID);
            if (credentialsConfiguration != null) {
                buffer.append(credentialsConfiguration.getUserID());
            }
        }
        return buffer.toString();
    }
}

