/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model;

import com.ibm.cics.model.ICICSType;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class TableDescriptions {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String BUNDLE_NAME = "com.ibm.cics.core.model.tableDescriptions";
    static ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("com.ibm.cics.core.model.tableDescriptions");

    public static String getTableDescription(ICICSType<?> type) {
        return TableDescriptions.getTableDescription(type.getResourceTableName());
    }

    public static String getTableDescriptionInLowercase(ICICSType<?> type) {
        return TableDescriptions.getTableDescriptionInLowercase(type.getResourceTableName());
    }

    public static String getPluralTableDescription(ICICSType<?> type) {
        return TableDescriptions.getPluralTableDescription(type.getResourceTableName());
    }

    public static String getTableDescription(String tableName) {
        try {
            return RESOURCE_BUNDLE.getString("Table." + tableName + ".name");
        }
        catch (MissingResourceException missingResourceException) {
            return tableName;
        }
    }

    public static String getTableDescriptionInLowercase(String tableName) {
        try {
            return RESOURCE_BUNDLE.getString("Table." + tableName + ".name.lowercase");
        }
        catch (MissingResourceException missingResourceException) {
            return tableName;
        }
    }

    public static String getPluralTableDescription(String tableName) {
        try {
            return RESOURCE_BUNDLE.getString("Table." + tableName + ".names");
        }
        catch (MissingResourceException missingResourceException) {
            return tableName;
        }
    }
}

