/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.builders;

import com.ibm.cics.core.model.builders.DocumentTemplateDefinitionBuilderGen;
import com.ibm.cics.model.IDocumentTemplate;
import com.ibm.cics.model.IDocumentTemplateDefinition;

public class DocumentTemplateDefinitionBuilder
extends DocumentTemplateDefinitionBuilderGen {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public DocumentTemplateDefinitionBuilder(String _name, Long _version, IDocumentTemplateDefinition anotherDef) throws Exception {
        super(_name, _version, anotherDef);
    }

    public DocumentTemplateDefinitionBuilder(String _name, Long _version, IDocumentTemplate.TemplateTypeValue templateType, String value) {
        this(_name, _version, _name, templateType, value);
    }

    public DocumentTemplateDefinitionBuilder(String _name, Long _version, String _templateName, IDocumentTemplate.TemplateTypeValue templateType, String value) {
        super(_name, _version);
        this.setTemplateName(_templateName);
        switch (templateType) {
            case EXITPGM: {
                this.setExitProgram(value);
                break;
            }
            case FILE: {
                this.setFile(value);
                break;
            }
            case HFS: {
                this.setHfsfile(value);
                break;
            }
            case PROGRAM: {
                this.setProgram(value);
                break;
            }
            case TDQUEUE: {
                this.setTdqueue(value);
                break;
            }
            case TSQUEUE: {
                this.setTsqueue(value);
                break;
            }
            default: {
                throw new IllegalArgumentException(templateType + ": " + value);
            }
        }
    }

    public DocumentTemplateDefinitionBuilder(String _name, Long _version, IDocumentTemplate.TemplateTypeValue templateType, String _ddname, String memberName) {
        this(_name, _version, _name, templateType, _ddname, memberName);
    }

    public DocumentTemplateDefinitionBuilder(String _name, Long _version, String _templateName, IDocumentTemplate.TemplateTypeValue templateType, String _ddname, String memberName) {
        super(_name, _version);
        this.setTemplateName(_templateName);
        if (templateType != IDocumentTemplate.TemplateTypeValue.MEMBER) {
            throw new IllegalArgumentException(templateType + " not TemplateTypeValue.MEMBER");
        }
        this.setDdname(_ddname);
        this.setMembername(memberName);
    }
}

