/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.JVMServerReference;
import com.ibm.cics.core.model.JVMServerType;
import com.ibm.cics.core.model.internal.MutableCICSResource;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.IJVMServer;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableJVMServer;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Date;

public class MutableJVMServer
extends MutableCICSResource
implements IMutableJVMServer {
    private IJVMServer delegate;
    private MutableSMRecord record;

    public MutableJVMServer(ICPSM cpsm, IContext context, IJVMServer cicsObject) {
        super(cpsm, context, (ICICSResource)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("JVMSERV");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    public IJVMServer.EnableStatusValue getEnableStatus() {
        String result = this.record.get("ENABLESTATUS");
        if (result == null) {
            return this.delegate.getEnableStatus();
        }
        return (IJVMServer.EnableStatusValue)((CICSAttribute)JVMServerType.ENABLE_STATUS).get(result, this.record.getNormalizers());
    }

    public IJVMServer.InstallAgentValue getInstallAgent() {
        return this.delegate.getInstallAgent();
    }

    public String getChangeUserID() {
        return this.delegate.getChangeUserID();
    }

    public IJVMServer.ChangeAgentValue getChangeAgent() {
        return this.delegate.getChangeAgent();
    }

    public String getChangeAgentRelease() {
        return this.delegate.getChangeAgentRelease();
    }

    public Date getChangeTime() {
        return this.delegate.getChangeTime();
    }

    public String getDefineSource() {
        return this.delegate.getDefineSource();
    }

    public Date getDefineTime() {
        return this.delegate.getDefineTime();
    }

    public String getInstallUserID() {
        return this.delegate.getInstallUserID();
    }

    public Date getInstallTime() {
        return this.delegate.getInstallTime();
    }

    public Long getBasdefinever() {
        return this.delegate.getBasdefinever();
    }

    public String getJvmProfile() {
        return this.delegate.getJvmProfile();
    }

    public String getLerunopts() {
        return this.delegate.getLerunopts();
    }

    public Long getMaxThreads() {
        String result = this.record.get("THREADLIMIT");
        if (result == null) {
            return this.delegate.getMaxThreads();
        }
        return (Long)((CICSAttribute)JVMServerType.MAX_THREADS).get(result, this.record.getNormalizers());
    }

    public Long getUseCount() {
        return this.delegate.getUseCount();
    }

    public Long getThreads() {
        return this.delegate.getThreads();
    }

    public Long getPeakThreads() {
        return this.delegate.getPeakThreads();
    }

    public Long getThreadWaits() {
        return this.delegate.getThreadWaits();
    }

    public Long getThreadWaitTime() {
        return this.delegate.getThreadWaitTime();
    }

    public Long getWaitingThreads() {
        return this.delegate.getWaitingThreads();
    }

    public Long getPeakWaitingThreads() {
        return this.delegate.getPeakWaitingThreads();
    }

    public Long getHeap() {
        return this.delegate.getHeap();
    }

    public String getGcPolicy() {
        return this.delegate.getGcPolicy();
    }

    public Long getInitHeap() {
        return this.delegate.getInitHeap();
    }

    public Long getMaxHeap() {
        return this.delegate.getMaxHeap();
    }

    public Long getGcMinHeap() {
        return this.delegate.getGcMinHeap();
    }

    public Long getPid() {
        return this.delegate.getPid();
    }

    public Long getSysThreadUsage() {
        return this.delegate.getSysThreadUsage();
    }

    public Long getSysThreadWaits() {
        return this.delegate.getSysThreadWaits();
    }

    public Long getSysThreadWaitTime() {
        return this.delegate.getSysThreadWaitTime();
    }

    public Long getWaitingThreadsSysThread() {
        return this.delegate.getWaitingThreadsSysThread();
    }

    public Long getSysThreadPeakWait() {
        return this.delegate.getSysThreadPeakWait();
    }

    public Date getJvmCreatedGMT() {
        return this.delegate.getJvmCreatedGMT();
    }

    public Date getJvmCreatedLocalTime() {
        return this.delegate.getJvmCreatedLocalTime();
    }

    public Long getPeakHeap() {
        return this.delegate.getPeakHeap();
    }

    public Long getGcEventsMajor() {
        return this.delegate.getGcEventsMajor();
    }

    public Long getGcTimeMajor() {
        return this.delegate.getGcTimeMajor();
    }

    public Long getGcHeapFreedMajor() {
        return this.delegate.getGcHeapFreedMajor();
    }

    public Long getGcEventsMinor() {
        return this.delegate.getGcEventsMinor();
    }

    public Long getGcTimeMinor() {
        return this.delegate.getGcTimeMinor();
    }

    public Long getGcHeapFreedMinor() {
        return this.delegate.getGcHeapFreedMinor();
    }

    public String getProfiledir() {
        return this.delegate.getProfiledir();
    }

    public void setEnableStatus(IJVMServer.EnableStatusValue _enableStatus) {
        if (_enableStatus.equals((Object)this.delegate.getEnableStatus())) {
            this.record.set("ENABLESTATUS", null);
        } else {
            JVMServerType.ENABLE_STATUS.validate((Object)_enableStatus);
            String connectionSpecificExternalValue = ((CICSAttribute)JVMServerType.ENABLE_STATUS).set(_enableStatus, this.record.getNormalizers());
            this.record.set("ENABLESTATUS", connectionSpecificExternalValue);
        }
    }

    public void setMaxThreads(Long _maxThreads) {
        if (_maxThreads.equals(this.delegate.getMaxThreads())) {
            this.record.set("THREADLIMIT", null);
        } else {
            JVMServerType.MAX_THREADS.validate((Object)_maxThreads);
            String connectionSpecificExternalValue = ((CICSAttribute)JVMServerType.MAX_THREADS).set(_maxThreads, this.record.getNormalizers());
            this.record.set("THREADLIMIT", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == JVMServerType.NAME) {
            return (V)this.getName();
        }
        if (attribute == JVMServerType.ENABLE_STATUS) {
            return (V)this.getEnableStatus();
        }
        if (attribute == JVMServerType.INSTALL_AGENT) {
            return (V)this.getInstallAgent();
        }
        if (attribute == JVMServerType.CHANGE_USER_ID) {
            return (V)this.getChangeUserID();
        }
        if (attribute == JVMServerType.CHANGE_AGENT) {
            return (V)this.getChangeAgent();
        }
        if (attribute == JVMServerType.CHANGE_AGENT_RELEASE) {
            return (V)this.getChangeAgentRelease();
        }
        if (attribute == JVMServerType.CHANGE_TIME) {
            return (V)this.getChangeTime();
        }
        if (attribute == JVMServerType.DEFINE_SOURCE) {
            return (V)this.getDefineSource();
        }
        if (attribute == JVMServerType.DEFINE_TIME) {
            return (V)this.getDefineTime();
        }
        if (attribute == JVMServerType.INSTALL_USER_ID) {
            return (V)this.getInstallUserID();
        }
        if (attribute == JVMServerType.INSTALL_TIME) {
            return (V)this.getInstallTime();
        }
        if (attribute == JVMServerType.BASDEFINEVER) {
            return (V)this.getBasdefinever();
        }
        if (attribute == JVMServerType.JVM_PROFILE) {
            return (V)this.getJvmProfile();
        }
        if (attribute == JVMServerType.LERUNOPTS) {
            return (V)this.getLerunopts();
        }
        if (attribute == JVMServerType.MAX_THREADS) {
            return (V)this.getMaxThreads();
        }
        if (attribute == JVMServerType.USE_COUNT) {
            return (V)this.getUseCount();
        }
        if (attribute == JVMServerType.THREADS) {
            return (V)this.getThreads();
        }
        if (attribute == JVMServerType.PEAK_THREADS) {
            return (V)this.getPeakThreads();
        }
        if (attribute == JVMServerType.THREAD_WAITS) {
            return (V)this.getThreadWaits();
        }
        if (attribute == JVMServerType.THREAD_WAIT_TIME) {
            return (V)this.getThreadWaitTime();
        }
        if (attribute == JVMServerType.WAITING_THREADS) {
            return (V)this.getWaitingThreads();
        }
        if (attribute == JVMServerType.PEAK_WAITING_THREADS) {
            return (V)this.getPeakWaitingThreads();
        }
        if (attribute == JVMServerType.HEAP) {
            return (V)this.getHeap();
        }
        if (attribute == JVMServerType.GC_POLICY) {
            return (V)this.getGcPolicy();
        }
        if (attribute == JVMServerType.INIT_HEAP) {
            return (V)this.getInitHeap();
        }
        if (attribute == JVMServerType.MAX_HEAP) {
            return (V)this.getMaxHeap();
        }
        if (attribute == JVMServerType.GC_MIN_HEAP) {
            return (V)this.getGcMinHeap();
        }
        if (attribute == JVMServerType.PID) {
            return (V)this.getPid();
        }
        if (attribute == JVMServerType.SYS_THREAD_USAGE) {
            return (V)this.getSysThreadUsage();
        }
        if (attribute == JVMServerType.SYS_THREAD_WAITS) {
            return (V)this.getSysThreadWaits();
        }
        if (attribute == JVMServerType.SYS_THREAD_WAIT_TIME) {
            return (V)this.getSysThreadWaitTime();
        }
        if (attribute == JVMServerType.WAITING_THREADS_SYS_THREAD) {
            return (V)this.getWaitingThreadsSysThread();
        }
        if (attribute == JVMServerType.SYS_THREAD_PEAK_WAIT) {
            return (V)this.getSysThreadPeakWait();
        }
        if (attribute == JVMServerType.JVM_CREATED_GMT) {
            return (V)this.getJvmCreatedGMT();
        }
        if (attribute == JVMServerType.JVM_CREATED_LOCAL_TIME) {
            return (V)this.getJvmCreatedLocalTime();
        }
        if (attribute == JVMServerType.PEAK_HEAP) {
            return (V)this.getPeakHeap();
        }
        if (attribute == JVMServerType.GC_EVENTS_MAJOR) {
            return (V)this.getGcEventsMajor();
        }
        if (attribute == JVMServerType.GC_TIME_MAJOR) {
            return (V)this.getGcTimeMajor();
        }
        if (attribute == JVMServerType.GC_HEAP_FREED_MAJOR) {
            return (V)this.getGcHeapFreedMajor();
        }
        if (attribute == JVMServerType.GC_EVENTS_MINOR) {
            return (V)this.getGcEventsMinor();
        }
        if (attribute == JVMServerType.GC_TIME_MINOR) {
            return (V)this.getGcTimeMinor();
        }
        if (attribute == JVMServerType.GC_HEAP_FREED_MINOR) {
            return (V)this.getGcHeapFreedMinor();
        }
        if (attribute == JVMServerType.PROFILEDIR) {
            return (V)this.getProfiledir();
        }
        return super.getAttributeValue(attribute);
    }

    public JVMServerType getObjectType() {
        return JVMServerType.getInstance();
    }

    @Override
    public JVMServerReference getCICSObjectReference() {
        return new JVMServerReference(this.getCICSContainer(), this.getName());
    }
}

