/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.RegionReference;
import com.ibm.cics.core.model.RegionType;
import com.ibm.cics.core.model.internal.CICSResource;
import com.ibm.cics.model.IRegion;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Date;
import java.util.Map;

public abstract class RegionGen
extends CICSResource
implements IRegion {
    private String _jobname;
    private String _applid;
    private String _mvssysid;
    private Long _akp;
    private Long _maxtasks;
    private IRegion.CICSStatusValue _cicsstatus;
    private IRegion.SystemDumpStatusValue _sysdump;
    private IRegion.ExternalSecurityValue _extsec;
    private IRegion.StartupTypeValue _startup;
    private IRegion.StorageProtectionValue _stgprot;
    private String _dtrprogram;
    private String _gmmtranid;
    private Long _mrobatch;
    private Long _oprel;
    private String _opsys;
    private String _cicssys;
    private Long _prtyaging;
    private String _release;
    private Long _runaway;
    private Long _scandelay;
    private Long _exittime;
    private IRegion.XRFStatusValue _xrfstatus;
    private String _ainsprog;
    private Long _ainscreq;
    private Long _ainsmreq;
    private IRegion.AutoinstallStatusValue _ainsstat;
    private IRegion.DumpDSSwitchTypeValue _ddsostat;
    private IRegion.DumpDSSwitchStatusValue _ddssstat;
    private IRegion.IRCStatusValue _ircstat;
    private IRegion.ExceptionMonitoringStatusValue _exceptclass;
    private IRegion.PerformanceMonitoringStatusValue _perfclass;
    private IRegion.MonitoringStatusValue _monstat;
    private String _endofday;
    private String _interval;
    private String _nexttime;
    private IRegion.StatisticsStatusValue _recording;
    private IRegion.AuxiliaryTraceStatusValue _auxstatus;
    private IRegion.GTFTraceStatusValue _gtfstatus;
    private IRegion.InternalTraceStatusValue _intstatus;
    private IRegion.AuxiliaryTraceSwitchTypeValue _switchstatus;
    private Long _tablesize;
    private IRegion.SingleTraceStatusValue _singlestatus;
    private IRegion.SystemTraceStatusValue _systemstatus;
    private IRegion.ExitTraceStatusValue _tcexitstatus;
    private IRegion.UserTraceStatusValue _userstatus;
    private String _plastreset;
    private Long _peaktasks;
    private Long _loadreqs;
    private String _loadtime;
    private Long _prgmucnt;
    private Long _prgmwait;
    private Long _loadwcnt;
    private Long _loadhwmw;
    private Long _loadhwmc;
    private String _loadwait;
    private Long _rdebrbld;
    private Long _prgmrcmp;
    private String _loadtniu;
    private Long _loadpniu;
    private Long _loadrniu;
    private Long _sdmptotl;
    private Long _sdmpsupp;
    private Long _tdmptotl;
    private Long _tdmpsupp;
    private Date _strttime;
    private String _sysid;
    private String _cputime;
    private Long _pagein;
    private Long _pageout;
    private Long _realstg;
    private Long _sioreq;
    private IRegion.VTAMStatusValue _vtmstatus;
    private String _vtmrplmax;
    private String _vtmrplpost;
    private Long _vtmsoscnt;
    private Long _vtmacbdope;
    private String _currentdds;
    private String _initialdds;
    private String _curauxds;
    private Long _lucurr;
    private Long _luhwm;
    private Long _prssinqcnt;
    private Long _prssnibcnt;
    private Long _prssopncnt;
    private Long _prssunbndcnt;
    private Long _prsserrorcnt;
    private IRegion.ConversestValue _conversest;
    private String _frequency;
    private String _subsystemid;
    private IRegion.SyncpointstValue _syncpointst;
    private IRegion.MonrpttimeValue _monrpttime;
    private String _dfltuser;
    private String _progautoexit;
    private IRegion.AutoinstallProgramCatalogTypeValue _progautoctlg;
    private IRegion.AutoinstallProgramStatusValue _progautoinst;
    private IRegion.TransactionIsolationValue _tranisolate;
    private String _startupdate;
    private String _psdinterval;
    private Long _currtasks;
    private Long _maxtrcnt;
    private Long _curactvusrtr;
    private Long _curquedusrtr;
    private Long _pekactvusrtr;
    private Long _pekquedusrtr;
    private Long _totactvusrtr;
    private Long _totdelyusrtr;
    private String _totquetime;
    private String _curquetime;
    private Long _progautoattm;
    private Long _progautoxrej;
    private Long _progautofail;
    private IRegion.InitializationStatusValue _initstatus;
    private IRegion.ShutdownStatusValue _shutstatus;
    private Long _intvtrans;
    private String _gmmtext;
    private Long _gmmlength;
    private String _grname;
    private IRegion.GrstatusValue _grstatus;
    private IRegion.ReentrantProgramProtectionStatusValue _reentprotect;
    private IRegion.CommandProtectionStatusValue _cmdprotect;
    private IRegion.SOSBelowBarValue _sosstatus;
    private Long _totltasks;
    private IRegion.RLSStatusValue _rlsstatus;
    private String _sdtran;
    private String _dsidle;
    private String _dsinterval;
    private String _ctslevel;
    private String _oslevel;
    private IRegion.RrmsstatValue _rrmsstat;
    private String _mvssysname;
    private IRegion.ForceqrValue _forceqr;
    private Long _maxopentcbs;
    private Long _actopentcbs;
    private String _dsrtprogram;
    private IRegion.AutoinstallConsoleStatusValue _consoles;
    private IRegion.TCPIPStatusValue _tcpip;
    private Long _garbageint;
    private Long _timeoutint;
    private IRegion.ColdstatusValue _coldstatus;
    private Long _maxhptcbs;
    private Long _acthptcbs;
    private Long _maxjvmtcbs;
    private Long _actjvmtcbs;
    private Long _subtasks;
    private IRegion.DebugToolValue _debugtool;
    private Long _maxxptcbs;
    private Long _actxptcbs;
    private Long _maxssltcbs;
    private Long _actssltcbs;
    private String _xcfgroup;
    private Long _memlimit;
    private IRegion.SOSAboveBarValue _sosabovebar;
    private IRegion.SOSAboveLineValue _sosaboveline;
    private IRegion.SOSBelowLineValue _sosbelowline;
    private Long _ldglbsou;
    private Long _ldglwsou;
    private Long _ldglsort;
    private IRegion.PstypeValue _pstype;
    private IRegion.IdntyclassValue _idntyclass;
    private Long _actthrdtcbs;
    private Long _maxthrdtcbs;
    private String _jobid;
    private Date _xmglsmxt;
    private Date _xmgltat;
    private Date _xmglamxt;
    private IRegion.CurrentlyAtMXTValue _xmgatmxt;

    public RegionGen(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("JOBNAME");
        this._jobname = (String)((CICSAttribute)RegionType.JOB_NAME).get(stringValue, normalizers);
        stringValue = record.get("APPLID");
        this._applid = (String)((CICSAttribute)RegionType.APPL_ID).get(stringValue, normalizers);
        stringValue = record.get("MVSSYSID");
        this._mvssysid = (String)((CICSAttribute)RegionType.MVS_SYSTEM_ID).get(stringValue, normalizers);
        stringValue = record.get("AKP");
        this._akp = (Long)((CICSAttribute)RegionType.AKP).get(stringValue, normalizers);
        stringValue = record.get("MAXTASKS");
        this._maxtasks = (Long)((CICSAttribute)RegionType.MAXIMUM_TASKS).get(stringValue, normalizers);
        stringValue = record.get("CICSSTATUS");
        this._cicsstatus = (IRegion.CICSStatusValue)((CICSAttribute)RegionType.CICS_STATUS).get(stringValue, normalizers);
        stringValue = record.get("SYSDUMP");
        this._sysdump = (IRegion.SystemDumpStatusValue)((CICSAttribute)RegionType.SYSTEM_DUMP_STATUS).get(stringValue, normalizers);
        stringValue = record.get("EXTSEC");
        this._extsec = (IRegion.ExternalSecurityValue)((CICSAttribute)RegionType.EXTERNAL_SECURITY).get(stringValue, normalizers);
        stringValue = record.get("STARTUP");
        this._startup = (IRegion.StartupTypeValue)((CICSAttribute)RegionType.STARTUP_TYPE).get(stringValue, normalizers);
        stringValue = record.get("STGPROT");
        this._stgprot = (IRegion.StorageProtectionValue)((CICSAttribute)RegionType.STORAGE_PROTECTION).get(stringValue, normalizers);
        stringValue = record.get("DTRPROGRAM");
        this._dtrprogram = (String)((CICSAttribute)RegionType.DYNAMIC_ROUTING_PROGRAM).get(stringValue, normalizers);
        stringValue = record.get("GMMTRANID");
        this._gmmtranid = (String)((CICSAttribute)RegionType.GMM_TRANSACTION).get(stringValue, normalizers);
        stringValue = record.get("MROBATCH");
        this._mrobatch = (Long)((CICSAttribute)RegionType.MRO_BATCH_REQUESTS).get(stringValue, normalizers);
        stringValue = record.get("OPREL");
        this._oprel = (Long)((CICSAttribute)RegionType.OS_RELEASE).get(stringValue, normalizers);
        stringValue = record.get("OPSYS");
        this._opsys = (String)((CICSAttribute)RegionType.OS).get(stringValue, normalizers);
        stringValue = record.get("CICSSYS");
        this._cicssys = (String)((CICSAttribute)RegionType.OS_CODE).get(stringValue, normalizers);
        stringValue = record.get("PRTYAGING");
        this._prtyaging = (Long)((CICSAttribute)RegionType.PRIORITY_AGING).get(stringValue, normalizers);
        stringValue = record.get("RELEASE");
        this._release = (String)((CICSAttribute)RegionType.RELEASE).get(stringValue, normalizers);
        stringValue = record.get("RUNAWAY");
        this._runaway = (Long)((CICSAttribute)RegionType.RUNAWAY).get(stringValue, normalizers);
        stringValue = record.get("SCANDELAY");
        this._scandelay = (Long)((CICSAttribute)RegionType.SCAN_DELAY).get(stringValue, normalizers);
        stringValue = record.get("EXITTIME");
        this._exittime = (Long)((CICSAttribute)RegionType.EXIT_WAIT_TIME).get(stringValue, normalizers);
        stringValue = record.get("XRFSTATUS");
        this._xrfstatus = (IRegion.XRFStatusValue)((CICSAttribute)RegionType.XRF_STATUS).get(stringValue, normalizers);
        stringValue = record.get("AINSPROG");
        this._ainsprog = (String)((CICSAttribute)RegionType.AUTOINSTALL_PROGRAM).get(stringValue, normalizers);
        stringValue = record.get("AINSCREQ");
        this._ainscreq = (Long)((CICSAttribute)RegionType.AUTOINSTALL_REQUEST_COUNT).get(stringValue, normalizers);
        stringValue = record.get("AINSMREQ");
        this._ainsmreq = (Long)((CICSAttribute)RegionType.MAXIMUM_AUTOINSTALL_REQUEST_COUNT).get(stringValue, normalizers);
        stringValue = record.get("AINSSTAT");
        this._ainsstat = (IRegion.AutoinstallStatusValue)((CICSAttribute)RegionType.AUTOINSTALL_STATUS).get(stringValue, normalizers);
        stringValue = record.get("DDSOSTAT");
        this._ddsostat = (IRegion.DumpDSSwitchTypeValue)((CICSAttribute)RegionType.DUMP_DS_SWITCH_TYPE).get(stringValue, normalizers);
        stringValue = record.get("DDSSSTAT");
        this._ddssstat = (IRegion.DumpDSSwitchStatusValue)((CICSAttribute)RegionType.DUMP_DS_SWITCH_STATUS).get(stringValue, normalizers);
        stringValue = record.get("IRCSTAT");
        this._ircstat = (IRegion.IRCStatusValue)((CICSAttribute)RegionType.IRC_STATUS).get(stringValue, normalizers);
        stringValue = record.get("EXCEPTCLASS");
        this._exceptclass = (IRegion.ExceptionMonitoringStatusValue)((CICSAttribute)RegionType.EXCEPTION_MONITORING_STATUS).get(stringValue, normalizers);
        stringValue = record.get("PERFCLASS");
        this._perfclass = (IRegion.PerformanceMonitoringStatusValue)((CICSAttribute)RegionType.PERFORMANCE_MONITORING_STATUS).get(stringValue, normalizers);
        stringValue = record.get("MONSTAT");
        this._monstat = (IRegion.MonitoringStatusValue)((CICSAttribute)RegionType.MONITORING_STATUS).get(stringValue, normalizers);
        stringValue = record.get("ENDOFDAY");
        this._endofday = (String)((CICSAttribute)RegionType.EOD_STATISTICS_TIME).get(stringValue, normalizers);
        stringValue = record.get("INTERVAL");
        this._interval = (String)((CICSAttribute)RegionType.STATISTICS_INTERVAL).get(stringValue, normalizers);
        stringValue = record.get("NEXTTIME");
        this._nexttime = (String)((CICSAttribute)RegionType.NEXT_STATISTICS_TIME).get(stringValue, normalizers);
        stringValue = record.get("RECORDING");
        this._recording = (IRegion.StatisticsStatusValue)((CICSAttribute)RegionType.STATISTICS_STATUS).get(stringValue, normalizers);
        stringValue = record.get("AUXSTATUS");
        this._auxstatus = (IRegion.AuxiliaryTraceStatusValue)((CICSAttribute)RegionType.AUXILIARY_TRACE_STATUS).get(stringValue, normalizers);
        stringValue = record.get("GTFSTATUS");
        this._gtfstatus = (IRegion.GTFTraceStatusValue)((CICSAttribute)RegionType.GTF_TRACE_STATUS).get(stringValue, normalizers);
        stringValue = record.get("INTSTATUS");
        this._intstatus = (IRegion.InternalTraceStatusValue)((CICSAttribute)RegionType.INTERNAL_TRACE_STATUS).get(stringValue, normalizers);
        stringValue = record.get("SWITCHSTATUS");
        this._switchstatus = (IRegion.AuxiliaryTraceSwitchTypeValue)((CICSAttribute)RegionType.AUXILIARY_TRACE_SWITCH_TYPE).get(stringValue, normalizers);
        stringValue = record.get("TABLESIZE");
        this._tablesize = (Long)((CICSAttribute)RegionType.INTERNAL_TRACE_TABLE_SIZE).get(stringValue, normalizers);
        stringValue = record.get("SINGLESTATUS");
        this._singlestatus = (IRegion.SingleTraceStatusValue)((CICSAttribute)RegionType.SINGLE_TRACE_STATUS).get(stringValue, normalizers);
        stringValue = record.get("SYSTEMSTATUS");
        this._systemstatus = (IRegion.SystemTraceStatusValue)((CICSAttribute)RegionType.SYSTEM_TRACE_STATUS).get(stringValue, normalizers);
        stringValue = record.get("TCEXITSTATUS");
        this._tcexitstatus = (IRegion.ExitTraceStatusValue)((CICSAttribute)RegionType.EXIT_TRACE_STATUS).get(stringValue, normalizers);
        stringValue = record.get("USERSTATUS");
        this._userstatus = (IRegion.UserTraceStatusValue)((CICSAttribute)RegionType.USER_TRACE_STATUS).get(stringValue, normalizers);
        stringValue = record.get("PLASTRESET");
        this._plastreset = (String)((CICSAttribute)RegionType.LAST_RESET_TIME).get(stringValue, normalizers);
        stringValue = record.get("PEAKTASKS");
        this._peaktasks = (Long)((CICSAttribute)RegionType.PEAK_TASK_COUNT).get(stringValue, normalizers);
        stringValue = record.get("LOADREQS");
        this._loadreqs = (Long)((CICSAttribute)RegionType.LOADER_REQUEST_COUNT).get(stringValue, normalizers);
        stringValue = record.get("LOADTIME");
        this._loadtime = (String)((CICSAttribute)RegionType.TOTAL_LOADING_TIME).get(stringValue, normalizers);
        stringValue = record.get("PRGMUCNT");
        this._prgmucnt = (Long)((CICSAttribute)RegionType.PROGRAM_REMOVE_COUNT).get(stringValue, normalizers);
        stringValue = record.get("PRGMWAIT");
        this._prgmwait = (Long)((CICSAttribute)RegionType.PRGMWAIT).get(stringValue, normalizers);
        stringValue = record.get("LOADWCNT");
        this._loadwcnt = (Long)((CICSAttribute)RegionType.LOADER_WAIT_COUNT).get(stringValue, normalizers);
        stringValue = record.get("LOADHWMW");
        this._loadhwmw = (Long)((CICSAttribute)RegionType.PEAK_LOADER_WAIT_COUNT).get(stringValue, normalizers);
        stringValue = record.get("LOADHWMC");
        this._loadhwmc = (Long)((CICSAttribute)RegionType.LOADHWMC).get(stringValue, normalizers);
        stringValue = record.get("LOADWAIT");
        this._loadwait = (String)((CICSAttribute)RegionType.TOTAL_LOADER_WAIT_TIME).get(stringValue, normalizers);
        stringValue = record.get("RDEBRBLD");
        this._rdebrbld = (Long)((CICSAttribute)RegionType.RDEBRBLD).get(stringValue, normalizers);
        stringValue = record.get("PRGMRCMP");
        this._prgmrcmp = (Long)((CICSAttribute)RegionType.PRGMRCMP).get(stringValue, normalizers);
        stringValue = record.get("LOADTNIU");
        this._loadtniu = (String)((CICSAttribute)RegionType.LOADTNIU).get(stringValue, normalizers);
        stringValue = record.get("LOADPNIU");
        this._loadpniu = (Long)((CICSAttribute)RegionType.LOADPNIU).get(stringValue, normalizers);
        stringValue = record.get("LOADRNIU");
        this._loadrniu = (Long)((CICSAttribute)RegionType.LOADRNIU).get(stringValue, normalizers);
        stringValue = record.get("SDMPTOTL");
        this._sdmptotl = (Long)((CICSAttribute)RegionType.SYSDUMPS_TAKEN_COUNT).get(stringValue, normalizers);
        stringValue = record.get("SDMPSUPP");
        this._sdmpsupp = (Long)((CICSAttribute)RegionType.SYSDUMPS_SUPPRESSED_COUNT).get(stringValue, normalizers);
        stringValue = record.get("TDMPTOTL");
        this._tdmptotl = (Long)((CICSAttribute)RegionType.TRANDUMPS_TAKEN_COUNT).get(stringValue, normalizers);
        stringValue = record.get("TDMPSUPP");
        this._tdmpsupp = (Long)((CICSAttribute)RegionType.TRANDUMPS_SUPPRESSED_COUNT).get(stringValue, normalizers);
        stringValue = record.get("STRTTIME");
        this._strttime = (Date)((CICSAttribute)RegionType.CICS_START_TIME).get(stringValue, normalizers);
        stringValue = record.get("SYSID");
        this._sysid = (String)((CICSAttribute)RegionType.CICS_SYSTEM_ID).get(stringValue, normalizers);
        stringValue = record.get("CPUTIME");
        this._cputime = (String)((CICSAttribute)RegionType.TOTAL_CPU).get(stringValue, normalizers);
        stringValue = record.get("PAGEIN");
        this._pagein = (Long)((CICSAttribute)RegionType.PAGE_IN_COUNT).get(stringValue, normalizers);
        stringValue = record.get("PAGEOUT");
        this._pageout = (Long)((CICSAttribute)RegionType.PAGE_OUT_COUNT).get(stringValue, normalizers);
        stringValue = record.get("REALSTG");
        this._realstg = (Long)((CICSAttribute)RegionType.REAL_STORAGE).get(stringValue, normalizers);
        stringValue = record.get("SIOREQ");
        this._sioreq = (Long)((CICSAttribute)RegionType.IO_COUNT).get(stringValue, normalizers);
        stringValue = record.get("VTMSTATUS");
        this._vtmstatus = (IRegion.VTAMStatusValue)((CICSAttribute)RegionType.VTAM_STATUS).get(stringValue, normalizers);
        stringValue = record.get("VTMRPLMAX");
        this._vtmrplmax = (String)((CICSAttribute)RegionType.VTMRPLMAX).get(stringValue, normalizers);
        stringValue = record.get("VTMRPLPOST");
        this._vtmrplpost = (String)((CICSAttribute)RegionType.VTMRPLPOST).get(stringValue, normalizers);
        stringValue = record.get("VTMSOSCNT");
        this._vtmsoscnt = (Long)((CICSAttribute)RegionType.VTMSOSCNT).get(stringValue, normalizers);
        stringValue = record.get("VTMACBDOPE");
        this._vtmacbdope = (Long)((CICSAttribute)RegionType.VTMACBDOPE).get(stringValue, normalizers);
        stringValue = record.get("CURRENTDDS");
        this._currentdds = (String)((CICSAttribute)RegionType.CURRENT_DUMP_DS).get(stringValue, normalizers);
        stringValue = record.get("INITIALDDS");
        this._initialdds = (String)((CICSAttribute)RegionType.INITIAL_DUMP_DS).get(stringValue, normalizers);
        stringValue = record.get("CURAUXDS");
        this._curauxds = (String)((CICSAttribute)RegionType.CURRENT_AUXILIARY_TRACE_DS).get(stringValue, normalizers);
        stringValue = record.get("LUCURR");
        this._lucurr = (Long)((CICSAttribute)RegionType.LUCURR).get(stringValue, normalizers);
        stringValue = record.get("LUHWM");
        this._luhwm = (Long)((CICSAttribute)RegionType.LUHWM).get(stringValue, normalizers);
        stringValue = record.get("PRSSINQCNT");
        this._prssinqcnt = (Long)((CICSAttribute)RegionType.PRSSINQCNT).get(stringValue, normalizers);
        stringValue = record.get("PRSSNIBCNT");
        this._prssnibcnt = (Long)((CICSAttribute)RegionType.PRSSNIBCNT).get(stringValue, normalizers);
        stringValue = record.get("PRSSOPNCNT");
        this._prssopncnt = (Long)((CICSAttribute)RegionType.PRSSOPNCNT).get(stringValue, normalizers);
        stringValue = record.get("PRSSUNBNDCNT");
        this._prssunbndcnt = (Long)((CICSAttribute)RegionType.PRSSUNBNDCNT).get(stringValue, normalizers);
        stringValue = record.get("PRSSERRORCNT");
        this._prsserrorcnt = (Long)((CICSAttribute)RegionType.PRSSERRORCNT).get(stringValue, normalizers);
        stringValue = record.get("CONVERSEST");
        this._conversest = (IRegion.ConversestValue)((CICSAttribute)RegionType.CONVERSEST).get(stringValue, normalizers);
        stringValue = record.get("FREQUENCY");
        this._frequency = (String)((CICSAttribute)RegionType.FREQUENCY).get(stringValue, normalizers);
        stringValue = record.get("SUBSYSTEMID");
        this._subsystemid = (String)((CICSAttribute)RegionType.SUBSYSTEMID).get(stringValue, normalizers);
        stringValue = record.get("SYNCPOINTST");
        this._syncpointst = (IRegion.SyncpointstValue)((CICSAttribute)RegionType.SYNCPOINTST).get(stringValue, normalizers);
        stringValue = record.get("MONRPTTIME");
        this._monrpttime = (IRegion.MonrpttimeValue)((CICSAttribute)RegionType.MONRPTTIME).get(stringValue, normalizers);
        stringValue = record.get("DFLTUSER");
        this._dfltuser = (String)((CICSAttribute)RegionType.DEFAULT_USER_ID).get(stringValue, normalizers);
        stringValue = record.get("PROGAUTOEXIT");
        this._progautoexit = (String)((CICSAttribute)RegionType.AUTOINSTALL_PROGRAM_EXIT).get(stringValue, normalizers);
        stringValue = record.get("PROGAUTOCTLG");
        this._progautoctlg = (IRegion.AutoinstallProgramCatalogTypeValue)((CICSAttribute)RegionType.AUTOINSTALL_PROGRAM_CATALOG_TYPE).get(stringValue, normalizers);
        stringValue = record.get("PROGAUTOINST");
        this._progautoinst = (IRegion.AutoinstallProgramStatusValue)((CICSAttribute)RegionType.AUTOINSTALL_PROGRAM_STATUS).get(stringValue, normalizers);
        stringValue = record.get("TRANISOLATE");
        this._tranisolate = (IRegion.TransactionIsolationValue)((CICSAttribute)RegionType.TRANSACTION_ISOLATION).get(stringValue, normalizers);
        stringValue = record.get("STARTUPDATE");
        this._startupdate = (String)((CICSAttribute)RegionType.STARTUP_DATE).get(stringValue, normalizers);
        stringValue = record.get("PSDINTERVAL");
        this._psdinterval = (String)((CICSAttribute)RegionType.PSDINTERVAL).get(stringValue, normalizers);
        stringValue = record.get("CURRTASKS");
        this._currtasks = (Long)((CICSAttribute)RegionType.TASK_COUNT).get(stringValue, normalizers);
        stringValue = record.get("MAXTRCNT");
        this._maxtrcnt = (Long)((CICSAttribute)RegionType.MAXIMUM_TASKS_COUNT).get(stringValue, normalizers);
        stringValue = record.get("CURACTVUSRTR");
        this._curactvusrtr = (Long)((CICSAttribute)RegionType.USER_TRANSACTION_COUNT).get(stringValue, normalizers);
        stringValue = record.get("CURQUEDUSRTR");
        this._curquedusrtr = (Long)((CICSAttribute)RegionType.QUEUED_TASK_COUNT).get(stringValue, normalizers);
        stringValue = record.get("PEKACTVUSRTR");
        this._pekactvusrtr = (Long)((CICSAttribute)RegionType.PEAK_USER_TRANSACTION_COUNT).get(stringValue, normalizers);
        stringValue = record.get("PEKQUEDUSRTR");
        this._pekquedusrtr = (Long)((CICSAttribute)RegionType.PEAK_QUEUED_TASK_COUNT).get(stringValue, normalizers);
        stringValue = record.get("TOTACTVUSRTR");
        this._totactvusrtr = (Long)((CICSAttribute)RegionType.TOTACTVUSRTR).get(stringValue, normalizers);
        stringValue = record.get("TOTDELYUSRTR");
        this._totdelyusrtr = (Long)((CICSAttribute)RegionType.TOTDELYUSRTR).get(stringValue, normalizers);
        stringValue = record.get("TOTQUETIME");
        this._totquetime = (String)((CICSAttribute)RegionType.TOTQUETIME).get(stringValue, normalizers);
        stringValue = record.get("CURQUETIME");
        this._curquetime = (String)((CICSAttribute)RegionType.CURQUETIME).get(stringValue, normalizers);
        stringValue = record.get("PROGAUTOATTM");
        this._progautoattm = (Long)((CICSAttribute)RegionType.AUTOINSTALL_PROGRAM_ATTEMPTS_COUNT).get(stringValue, normalizers);
        stringValue = record.get("PROGAUTOXREJ");
        this._progautoxrej = (Long)((CICSAttribute)RegionType.AUTOINSTALL_PROGRAM_REJECTS_COUNT).get(stringValue, normalizers);
        stringValue = record.get("PROGAUTOFAIL");
        this._progautofail = (Long)((CICSAttribute)RegionType.AUTOINSTALL_PROGRAM_FAILED_ATTEMPTS_COUNT).get(stringValue, normalizers);
        stringValue = record.get("INITSTATUS");
        this._initstatus = (IRegion.InitializationStatusValue)((CICSAttribute)RegionType.INITIALIZATION_STATUS).get(stringValue, normalizers);
        stringValue = record.get("SHUTSTATUS");
        this._shutstatus = (IRegion.ShutdownStatusValue)((CICSAttribute)RegionType.SHUTDOWN_STATUS).get(stringValue, normalizers);
        stringValue = record.get("INTVTRANS");
        this._intvtrans = (Long)((CICSAttribute)RegionType.INTVTRANS).get(stringValue, normalizers);
        stringValue = record.get("GMMTEXT");
        this._gmmtext = (String)((CICSAttribute)RegionType.GMM_TEXT).get(stringValue, normalizers);
        stringValue = record.get("GMMLENGTH");
        this._gmmlength = (Long)((CICSAttribute)RegionType.GMM_LENGTH).get(stringValue, normalizers);
        stringValue = record.get("GRNAME");
        this._grname = (String)((CICSAttribute)RegionType.GRNAME).get(stringValue, normalizers);
        stringValue = record.get("GRSTATUS");
        this._grstatus = (IRegion.GrstatusValue)((CICSAttribute)RegionType.GRSTATUS).get(stringValue, normalizers);
        stringValue = record.get("REENTPROTECT");
        this._reentprotect = (IRegion.ReentrantProgramProtectionStatusValue)((CICSAttribute)RegionType.REENTRANT_PROGRAM_PROTECTION_STATUS).get(stringValue, normalizers);
        stringValue = record.get("CMDPROTECT");
        this._cmdprotect = (IRegion.CommandProtectionStatusValue)((CICSAttribute)RegionType.COMMAND_PROTECTION_STATUS).get(stringValue, normalizers);
        stringValue = record.get("SOSSTATUS");
        this._sosstatus = (IRegion.SOSBelowBarValue)((CICSAttribute)RegionType.SOS_BELOW_BAR).get(stringValue, normalizers);
        stringValue = record.get("TOTLTASKS");
        this._totltasks = (Long)((CICSAttribute)RegionType.TOTAL_TASK_COUNT).get(stringValue, normalizers);
        stringValue = record.get("RLSSTATUS");
        this._rlsstatus = (IRegion.RLSStatusValue)((CICSAttribute)RegionType.RLS_STATUS).get(stringValue, normalizers);
        stringValue = record.get("SDTRAN");
        this._sdtran = (String)((CICSAttribute)RegionType.SHUTDOWN_TRANSACTION).get(stringValue, normalizers);
        stringValue = record.get("DSIDLE");
        this._dsidle = (String)((CICSAttribute)RegionType.DSIDLE).get(stringValue, normalizers);
        stringValue = record.get("DSINTERVAL");
        this._dsinterval = (String)((CICSAttribute)RegionType.DSINTERVAL).get(stringValue, normalizers);
        stringValue = record.get("CTSLEVEL");
        this._ctslevel = (String)((CICSAttribute)RegionType.CICSTS_LEVEL).get(stringValue, normalizers);
        stringValue = record.get("OSLEVEL");
        this._oslevel = (String)((CICSAttribute)RegionType.OS_LEVEL).get(stringValue, normalizers);
        stringValue = record.get("RRMSSTAT");
        this._rrmsstat = (IRegion.RrmsstatValue)((CICSAttribute)RegionType.RRMSSTAT).get(stringValue, normalizers);
        stringValue = record.get("MVSSYSNAME");
        this._mvssysname = (String)((CICSAttribute)RegionType.MVSSYSNAME).get(stringValue, normalizers);
        stringValue = record.get("FORCEQR");
        this._forceqr = (IRegion.ForceqrValue)((CICSAttribute)RegionType.FORCEQR).get(stringValue, normalizers);
        stringValue = record.get("MAXOPENTCBS");
        this._maxopentcbs = (Long)((CICSAttribute)RegionType.MAXIMUM_OPEN_TCB_COUNT).get(stringValue, normalizers);
        stringValue = record.get("ACTOPENTCBS");
        this._actopentcbs = (Long)((CICSAttribute)RegionType.CURRENT_OPEN_POOL_TCB_COUNT).get(stringValue, normalizers);
        stringValue = record.get("DSRTPROGRAM");
        this._dsrtprogram = (String)((CICSAttribute)RegionType.DISTRIBUTED_ROUTING_PROGRAM).get(stringValue, normalizers);
        stringValue = record.get("CONSOLES");
        this._consoles = (IRegion.AutoinstallConsoleStatusValue)((CICSAttribute)RegionType.AUTOINSTALL_CONSOLE_STATUS).get(stringValue, normalizers);
        stringValue = record.get("TCPIP");
        this._tcpip = (IRegion.TCPIPStatusValue)((CICSAttribute)RegionType.TCPIP_STATUS).get(stringValue, normalizers);
        stringValue = record.get("GARBAGEINT");
        this._garbageint = (Long)((CICSAttribute)RegionType.GARBAGEINT).get(stringValue, normalizers);
        stringValue = record.get("TIMEOUTINT");
        this._timeoutint = (Long)((CICSAttribute)RegionType.TIMEOUTINT).get(stringValue, normalizers);
        stringValue = record.get("COLDSTATUS");
        this._coldstatus = (IRegion.ColdstatusValue)((CICSAttribute)RegionType.COLDSTATUS).get(stringValue, normalizers);
        stringValue = record.get("MAXHPTCBS");
        this._maxhptcbs = (Long)((CICSAttribute)RegionType.MAXIMUM_HP_POOL_TCB_COUNT).get(stringValue, normalizers);
        stringValue = record.get("ACTHPTCBS");
        this._acthptcbs = (Long)((CICSAttribute)RegionType.CURRENT_HP_POOL_TCB_COUNT).get(stringValue, normalizers);
        stringValue = record.get("MAXJVMTCBS");
        this._maxjvmtcbs = (Long)((CICSAttribute)RegionType.MAXIMUM_JVM_POOL_TCB_COUNT).get(stringValue, normalizers);
        stringValue = record.get("ACTJVMTCBS");
        this._actjvmtcbs = (Long)((CICSAttribute)RegionType.CURRENT_JVM_POOL_TCB_COUNT).get(stringValue, normalizers);
        stringValue = record.get("SUBTASKS");
        this._subtasks = (Long)((CICSAttribute)RegionType.SUBTASKS).get(stringValue, normalizers);
        stringValue = record.get("DEBUGTOOL");
        this._debugtool = (IRegion.DebugToolValue)((CICSAttribute)RegionType.DEBUG_TOOL).get(stringValue, normalizers);
        stringValue = record.get("MAXXPTCBS");
        this._maxxptcbs = (Long)((CICSAttribute)RegionType.MAXIMUM_XP_LINK_POOL_TCB_COUNT).get(stringValue, normalizers);
        stringValue = record.get("ACTXPTCBS");
        this._actxptcbs = (Long)((CICSAttribute)RegionType.CURRENT_XP_LINK_POOL_TCB_COUNT).get(stringValue, normalizers);
        stringValue = record.get("MAXSSLTCBS");
        this._maxssltcbs = (Long)((CICSAttribute)RegionType.MAXIMUM_SSL_POOL_TCB_COUNT).get(stringValue, normalizers);
        stringValue = record.get("ACTSSLTCBS");
        this._actssltcbs = (Long)((CICSAttribute)RegionType.CURRENT_SSL_POOL_TCB_COUNT).get(stringValue, normalizers);
        stringValue = record.get("XCFGROUP");
        this._xcfgroup = (String)((CICSAttribute)RegionType.XCFGROUP).get(stringValue, normalizers);
        stringValue = record.get("MEMLIMIT");
        this._memlimit = (Long)((CICSAttribute)RegionType.STORAGE_LIMIT).get(stringValue, normalizers);
        stringValue = record.get("SOSABOVEBAR");
        this._sosabovebar = (IRegion.SOSAboveBarValue)((CICSAttribute)RegionType.SOS_ABOVE_BAR).get(stringValue, normalizers);
        stringValue = record.get("SOSABOVELINE");
        this._sosaboveline = (IRegion.SOSAboveLineValue)((CICSAttribute)RegionType.SOS_ABOVE_LINE).get(stringValue, normalizers);
        stringValue = record.get("SOSBELOWLINE");
        this._sosbelowline = (IRegion.SOSBelowLineValue)((CICSAttribute)RegionType.SOS_BELOW_LINE).get(stringValue, normalizers);
        stringValue = record.get("LDGLBSOU");
        this._ldglbsou = (Long)((CICSAttribute)RegionType.LDGLBSOU).get(stringValue, normalizers);
        stringValue = record.get("LDGLWSOU");
        this._ldglwsou = (Long)((CICSAttribute)RegionType.LDGLWSOU).get(stringValue, normalizers);
        stringValue = record.get("LDGLSORT");
        this._ldglsort = (Long)((CICSAttribute)RegionType.LDGLSORT).get(stringValue, normalizers);
        stringValue = record.get("PSTYPE");
        this._pstype = (IRegion.PstypeValue)((CICSAttribute)RegionType.PSTYPE).get(stringValue, normalizers);
        stringValue = record.get("IDNTYCLASS");
        this._idntyclass = (IRegion.IdntyclassValue)((CICSAttribute)RegionType.IDNTYCLASS).get(stringValue, normalizers);
        stringValue = record.get("ACTTHRDTCBS");
        this._actthrdtcbs = (Long)((CICSAttribute)RegionType.CURRENT_JVM_SERVER_THREAD_TCB_COUNT).get(stringValue, normalizers);
        stringValue = record.get("MAXTHRDTCBS");
        this._maxthrdtcbs = (Long)((CICSAttribute)RegionType.MAXIMUM_JVM_SERVER_THREAD_COUNT).get(stringValue, normalizers);
        stringValue = record.get("JOBID");
        this._jobid = (String)((CICSAttribute)RegionType.JOBID).get(stringValue, normalizers);
        stringValue = record.get("XMGLSMXT");
        this._xmglsmxt = (Date)((CICSAttribute)RegionType.MAXTASKS_LAST_CHANGED_TIME).get(stringValue, normalizers);
        stringValue = record.get("XMGLTAT");
        this._xmgltat = (Date)((CICSAttribute)RegionType.LAST_TRANSACTION_ATTACHED_TIME).get(stringValue, normalizers);
        stringValue = record.get("XMGLAMXT");
        this._xmglamxt = (Date)((CICSAttribute)RegionType.MAXTASKS_LIMIT_LAST_REACHED_TIME).get(stringValue, normalizers);
        stringValue = record.get("XMGATMXT");
        this._xmgatmxt = (IRegion.CurrentlyAtMXTValue)((CICSAttribute)RegionType.CURRENTLY_AT_MXT).get(stringValue, normalizers);
    }

    public String getJobName() {
        return this._jobname;
    }

    public String getApplID() {
        return this._applid;
    }

    public String getMVSSystemID() {
        return this._mvssysid;
    }

    public Long getAkp() {
        return this._akp;
    }

    public Long getMaximumTasks() {
        return this._maxtasks;
    }

    public IRegion.CICSStatusValue getCICSStatus() {
        return this._cicsstatus;
    }

    public IRegion.SystemDumpStatusValue getSystemDumpStatus() {
        return this._sysdump;
    }

    public IRegion.ExternalSecurityValue getExternalSecurity() {
        return this._extsec;
    }

    public IRegion.StartupTypeValue getStartupType() {
        return this._startup;
    }

    public IRegion.StorageProtectionValue getStorageProtection() {
        return this._stgprot;
    }

    public String getDynamicRoutingProgram() {
        return this._dtrprogram;
    }

    public String getGMMTransaction() {
        return this._gmmtranid;
    }

    public Long getMROBatchRequests() {
        return this._mrobatch;
    }

    public Long getOSRelease() {
        return this._oprel;
    }

    public String getOS() {
        return this._opsys;
    }

    public String getOSCode() {
        return this._cicssys;
    }

    public Long getPriorityAging() {
        return this._prtyaging;
    }

    public String getRelease() {
        return this._release;
    }

    public Long getRunaway() {
        return this._runaway;
    }

    public Long getScanDelay() {
        return this._scandelay;
    }

    public Long getExitWaitTime() {
        return this._exittime;
    }

    public IRegion.XRFStatusValue getXRFStatus() {
        return this._xrfstatus;
    }

    public String getAutoinstallProgram() {
        return this._ainsprog;
    }

    public Long getAutoinstallRequestCount() {
        return this._ainscreq;
    }

    public Long getMaximumAutoinstallRequestCount() {
        return this._ainsmreq;
    }

    public IRegion.AutoinstallStatusValue getAutoinstallStatus() {
        return this._ainsstat;
    }

    public IRegion.DumpDSSwitchTypeValue getDumpDSSwitchType() {
        return this._ddsostat;
    }

    public IRegion.DumpDSSwitchStatusValue getDumpDSSwitchStatus() {
        return this._ddssstat;
    }

    public IRegion.IRCStatusValue getIRCStatus() {
        return this._ircstat;
    }

    public IRegion.ExceptionMonitoringStatusValue getExceptionMonitoringStatus() {
        return this._exceptclass;
    }

    public IRegion.PerformanceMonitoringStatusValue getPerformanceMonitoringStatus() {
        return this._perfclass;
    }

    public IRegion.MonitoringStatusValue getMonitoringStatus() {
        return this._monstat;
    }

    public String getEODStatisticsTime() {
        return this._endofday;
    }

    public String getStatisticsInterval() {
        return this._interval;
    }

    public String getNextStatisticsTime() {
        return this._nexttime;
    }

    public IRegion.StatisticsStatusValue getStatisticsStatus() {
        return this._recording;
    }

    public IRegion.AuxiliaryTraceStatusValue getAuxiliaryTraceStatus() {
        return this._auxstatus;
    }

    public IRegion.GTFTraceStatusValue getGTFTraceStatus() {
        return this._gtfstatus;
    }

    public IRegion.InternalTraceStatusValue getInternalTraceStatus() {
        return this._intstatus;
    }

    public IRegion.AuxiliaryTraceSwitchTypeValue getAuxiliaryTraceSwitchType() {
        return this._switchstatus;
    }

    public Long getInternalTraceTableSize() {
        return this._tablesize;
    }

    public IRegion.SingleTraceStatusValue getSingleTraceStatus() {
        return this._singlestatus;
    }

    public IRegion.SystemTraceStatusValue getSystemTraceStatus() {
        return this._systemstatus;
    }

    public IRegion.ExitTraceStatusValue getExitTraceStatus() {
        return this._tcexitstatus;
    }

    public IRegion.UserTraceStatusValue getUserTraceStatus() {
        return this._userstatus;
    }

    public String getLastResetTime() {
        return this._plastreset;
    }

    public Long getPeakTaskCount() {
        return this._peaktasks;
    }

    public Long getLoaderRequestCount() {
        return this._loadreqs;
    }

    public String getTotalLoadingTime() {
        return this._loadtime;
    }

    public Long getProgramRemoveCount() {
        return this._prgmucnt;
    }

    public Long getPrgmwait() {
        return this._prgmwait;
    }

    public Long getLoaderWaitCount() {
        return this._loadwcnt;
    }

    public Long getPeakLoaderWaitCount() {
        return this._loadhwmw;
    }

    public Long getLoadhwmc() {
        return this._loadhwmc;
    }

    public String getTotalLoaderWaitTime() {
        return this._loadwait;
    }

    public Long getRdebrbld() {
        return this._rdebrbld;
    }

    public Long getPrgmrcmp() {
        return this._prgmrcmp;
    }

    public String getLoadtniu() {
        return this._loadtniu;
    }

    public Long getLoadpniu() {
        return this._loadpniu;
    }

    public Long getLoadrniu() {
        return this._loadrniu;
    }

    public Long getSysdumpsTakenCount() {
        return this._sdmptotl;
    }

    public Long getSysdumpsSuppressedCount() {
        return this._sdmpsupp;
    }

    public Long getTrandumpsTakenCount() {
        return this._tdmptotl;
    }

    public Long getTrandumpsSuppressedCount() {
        return this._tdmpsupp;
    }

    public Date getCICSStartTime() {
        return this._strttime;
    }

    public String getCICSSystemID() {
        return this._sysid;
    }

    public String getTotalCPU() {
        return this._cputime;
    }

    public Long getPageInCount() {
        return this._pagein;
    }

    public Long getPageOutCount() {
        return this._pageout;
    }

    public Long getRealStorage() {
        return this._realstg;
    }

    public Long getIOCount() {
        return this._sioreq;
    }

    public IRegion.VTAMStatusValue getVTAMStatus() {
        return this._vtmstatus;
    }

    public String getVtmrplmax() {
        return this._vtmrplmax;
    }

    public String getVtmrplpost() {
        return this._vtmrplpost;
    }

    public Long getVtmsoscnt() {
        return this._vtmsoscnt;
    }

    public Long getVtmacbdope() {
        return this._vtmacbdope;
    }

    public String getCurrentDumpDS() {
        return this._currentdds;
    }

    public String getInitialDumpDS() {
        return this._initialdds;
    }

    public String getCurrentAuxiliaryTraceDS() {
        return this._curauxds;
    }

    public Long getLucurr() {
        return this._lucurr;
    }

    public Long getLuhwm() {
        return this._luhwm;
    }

    public Long getPrssinqcnt() {
        return this._prssinqcnt;
    }

    public Long getPrssnibcnt() {
        return this._prssnibcnt;
    }

    public Long getPrssopncnt() {
        return this._prssopncnt;
    }

    public Long getPrssunbndcnt() {
        return this._prssunbndcnt;
    }

    public Long getPrsserrorcnt() {
        return this._prsserrorcnt;
    }

    public IRegion.ConversestValue getConversest() {
        return this._conversest;
    }

    public String getFrequency() {
        return this._frequency;
    }

    public String getSubsystemid() {
        return this._subsystemid;
    }

    public IRegion.SyncpointstValue getSyncpointst() {
        return this._syncpointst;
    }

    public IRegion.MonrpttimeValue getMonrpttime() {
        return this._monrpttime;
    }

    public String getDefaultUserID() {
        return this._dfltuser;
    }

    public String getAutoinstallProgramExit() {
        return this._progautoexit;
    }

    public IRegion.AutoinstallProgramCatalogTypeValue getAutoinstallProgramCatalogType() {
        return this._progautoctlg;
    }

    public IRegion.AutoinstallProgramStatusValue getAutoinstallProgramStatus() {
        return this._progautoinst;
    }

    public IRegion.TransactionIsolationValue getTransactionIsolation() {
        return this._tranisolate;
    }

    public String getStartupDate() {
        return this._startupdate;
    }

    public String getPsdinterval() {
        return this._psdinterval;
    }

    public Long getTaskCount() {
        return this._currtasks;
    }

    public Long getMaximumTasksCount() {
        return this._maxtrcnt;
    }

    public Long getUserTransactionCount() {
        return this._curactvusrtr;
    }

    public Long getQueuedTaskCount() {
        return this._curquedusrtr;
    }

    public Long getPeakUserTransactionCount() {
        return this._pekactvusrtr;
    }

    public Long getPeakQueuedTaskCount() {
        return this._pekquedusrtr;
    }

    public Long getTotactvusrtr() {
        return this._totactvusrtr;
    }

    public Long getTotdelyusrtr() {
        return this._totdelyusrtr;
    }

    public String getTotquetime() {
        return this._totquetime;
    }

    public String getCurquetime() {
        return this._curquetime;
    }

    public Long getAutoinstallProgramAttemptsCount() {
        return this._progautoattm;
    }

    public Long getAutoinstallProgramRejectsCount() {
        return this._progautoxrej;
    }

    public Long getAutoinstallProgramFailedAttemptsCount() {
        return this._progautofail;
    }

    public IRegion.InitializationStatusValue getInitializationStatus() {
        return this._initstatus;
    }

    public IRegion.ShutdownStatusValue getShutdownStatus() {
        return this._shutstatus;
    }

    public Long getIntvtrans() {
        return this._intvtrans;
    }

    public String getGMMText() {
        return this._gmmtext;
    }

    public Long getGMMLength() {
        return this._gmmlength;
    }

    public String getGrname() {
        return this._grname;
    }

    public IRegion.GrstatusValue getGrstatus() {
        return this._grstatus;
    }

    public IRegion.ReentrantProgramProtectionStatusValue getReentrantProgramProtectionStatus() {
        return this._reentprotect;
    }

    public IRegion.CommandProtectionStatusValue getCommandProtectionStatus() {
        return this._cmdprotect;
    }

    public IRegion.SOSBelowBarValue getSOSBelowBar() {
        return this._sosstatus;
    }

    public Long getTotalTaskCount() {
        return this._totltasks;
    }

    public IRegion.RLSStatusValue getRLSStatus() {
        return this._rlsstatus;
    }

    public String getShutdownTransaction() {
        return this._sdtran;
    }

    public String getDsidle() {
        return this._dsidle;
    }

    public String getDsinterval() {
        return this._dsinterval;
    }

    public String getCICSTSLevel() {
        return this._ctslevel;
    }

    public String getOSLevel() {
        return this._oslevel;
    }

    public IRegion.RrmsstatValue getRrmsstat() {
        return this._rrmsstat;
    }

    public String getMvssysname() {
        return this._mvssysname;
    }

    public IRegion.ForceqrValue getForceqr() {
        return this._forceqr;
    }

    public Long getMaximumOpenTCBCount() {
        return this._maxopentcbs;
    }

    public Long getCurrentOpenPoolTCBCount() {
        return this._actopentcbs;
    }

    public String getDistributedRoutingProgram() {
        return this._dsrtprogram;
    }

    public IRegion.AutoinstallConsoleStatusValue getAutoinstallConsoleStatus() {
        return this._consoles;
    }

    public IRegion.TCPIPStatusValue getTCPIPStatus() {
        return this._tcpip;
    }

    public Long getGarbageint() {
        return this._garbageint;
    }

    public Long getTimeoutint() {
        return this._timeoutint;
    }

    public IRegion.ColdstatusValue getColdstatus() {
        return this._coldstatus;
    }

    public Long getMaximumHPPoolTCBCount() {
        return this._maxhptcbs;
    }

    public Long getCurrentHPPoolTCBCount() {
        return this._acthptcbs;
    }

    public Long getMaximumJVMPoolTCBCount() {
        return this._maxjvmtcbs;
    }

    public Long getCurrentJVMPoolTCBCount() {
        return this._actjvmtcbs;
    }

    public Long getSubtasks() {
        return this._subtasks;
    }

    public IRegion.DebugToolValue getDebugTool() {
        return this._debugtool;
    }

    public Long getMaximumXPLinkPoolTCBCount() {
        return this._maxxptcbs;
    }

    public Long getCurrentXPLinkPoolTCBCount() {
        return this._actxptcbs;
    }

    public Long getMaximumSSLPoolTCBCount() {
        return this._maxssltcbs;
    }

    public Long getCurrentSSLPoolTCBCount() {
        return this._actssltcbs;
    }

    public String getXcfgroup() {
        return this._xcfgroup;
    }

    public Long getStorageLimit() {
        return this._memlimit;
    }

    public IRegion.SOSAboveBarValue getSOSAboveBar() {
        return this._sosabovebar;
    }

    public IRegion.SOSAboveLineValue getSOSAboveLine() {
        return this._sosaboveline;
    }

    public IRegion.SOSBelowLineValue getSOSBelowLine() {
        return this._sosbelowline;
    }

    public Long getLdglbsou() {
        return this._ldglbsou;
    }

    public Long getLdglwsou() {
        return this._ldglwsou;
    }

    public Long getLdglsort() {
        return this._ldglsort;
    }

    public IRegion.PstypeValue getPstype() {
        return this._pstype;
    }

    public IRegion.IdntyclassValue getIdntyclass() {
        return this._idntyclass;
    }

    public Long getCurrentJVMServerThreadTCBCount() {
        return this._actthrdtcbs;
    }

    public Long getMaximumJVMServerThreadCount() {
        return this._maxthrdtcbs;
    }

    public String getJobid() {
        return this._jobid;
    }

    public Date getMAXTASKSLastChangedTime() {
        return this._xmglsmxt;
    }

    public Date getLastTransactionAttachedTime() {
        return this._xmgltat;
    }

    public Date getMAXTASKSLimitLastReachedTime() {
        return this._xmglamxt;
    }

    public IRegion.CurrentlyAtMXTValue getCurrentlyAtMXT() {
        return this._xmgatmxt;
    }

    public RegionType getObjectType() {
        return RegionType.getInstance();
    }

    @Override
    public RegionReference getCICSObjectReference() {
        return new RegionReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == RegionType.JOB_NAME) {
            return (V)this.getJobName();
        }
        if (attribute == RegionType.APPL_ID) {
            return (V)this.getApplID();
        }
        if (attribute == RegionType.MVS_SYSTEM_ID) {
            return (V)this.getMVSSystemID();
        }
        if (attribute == RegionType.AKP) {
            return (V)this.getAkp();
        }
        if (attribute == RegionType.MAXIMUM_TASKS) {
            return (V)this.getMaximumTasks();
        }
        if (attribute == RegionType.CICS_STATUS) {
            return (V)this.getCICSStatus();
        }
        if (attribute == RegionType.SYSTEM_DUMP_STATUS) {
            return (V)this.getSystemDumpStatus();
        }
        if (attribute == RegionType.EXTERNAL_SECURITY) {
            return (V)this.getExternalSecurity();
        }
        if (attribute == RegionType.STARTUP_TYPE) {
            return (V)this.getStartupType();
        }
        if (attribute == RegionType.STORAGE_PROTECTION) {
            return (V)this.getStorageProtection();
        }
        if (attribute == RegionType.DYNAMIC_ROUTING_PROGRAM) {
            return (V)this.getDynamicRoutingProgram();
        }
        if (attribute == RegionType.GMM_TRANSACTION) {
            return (V)this.getGMMTransaction();
        }
        if (attribute == RegionType.MRO_BATCH_REQUESTS) {
            return (V)this.getMROBatchRequests();
        }
        if (attribute == RegionType.OS_RELEASE) {
            return (V)this.getOSRelease();
        }
        if (attribute == RegionType.OS) {
            return (V)this.getOS();
        }
        if (attribute == RegionType.OS_CODE) {
            return (V)this.getOSCode();
        }
        if (attribute == RegionType.PRIORITY_AGING) {
            return (V)this.getPriorityAging();
        }
        if (attribute == RegionType.RELEASE) {
            return (V)this.getRelease();
        }
        if (attribute == RegionType.RUNAWAY) {
            return (V)this.getRunaway();
        }
        if (attribute == RegionType.SCAN_DELAY) {
            return (V)this.getScanDelay();
        }
        if (attribute == RegionType.EXIT_WAIT_TIME) {
            return (V)this.getExitWaitTime();
        }
        if (attribute == RegionType.XRF_STATUS) {
            return (V)this.getXRFStatus();
        }
        if (attribute == RegionType.AUTOINSTALL_PROGRAM) {
            return (V)this.getAutoinstallProgram();
        }
        if (attribute == RegionType.AUTOINSTALL_REQUEST_COUNT) {
            return (V)this.getAutoinstallRequestCount();
        }
        if (attribute == RegionType.MAXIMUM_AUTOINSTALL_REQUEST_COUNT) {
            return (V)this.getMaximumAutoinstallRequestCount();
        }
        if (attribute == RegionType.AUTOINSTALL_STATUS) {
            return (V)this.getAutoinstallStatus();
        }
        if (attribute == RegionType.DUMP_DS_SWITCH_TYPE) {
            return (V)this.getDumpDSSwitchType();
        }
        if (attribute == RegionType.DUMP_DS_SWITCH_STATUS) {
            return (V)this.getDumpDSSwitchStatus();
        }
        if (attribute == RegionType.IRC_STATUS) {
            return (V)this.getIRCStatus();
        }
        if (attribute == RegionType.EXCEPTION_MONITORING_STATUS) {
            return (V)this.getExceptionMonitoringStatus();
        }
        if (attribute == RegionType.PERFORMANCE_MONITORING_STATUS) {
            return (V)this.getPerformanceMonitoringStatus();
        }
        if (attribute == RegionType.MONITORING_STATUS) {
            return (V)this.getMonitoringStatus();
        }
        if (attribute == RegionType.EOD_STATISTICS_TIME) {
            return (V)this.getEODStatisticsTime();
        }
        if (attribute == RegionType.STATISTICS_INTERVAL) {
            return (V)this.getStatisticsInterval();
        }
        if (attribute == RegionType.NEXT_STATISTICS_TIME) {
            return (V)this.getNextStatisticsTime();
        }
        if (attribute == RegionType.STATISTICS_STATUS) {
            return (V)this.getStatisticsStatus();
        }
        if (attribute == RegionType.AUXILIARY_TRACE_STATUS) {
            return (V)this.getAuxiliaryTraceStatus();
        }
        if (attribute == RegionType.GTF_TRACE_STATUS) {
            return (V)this.getGTFTraceStatus();
        }
        if (attribute == RegionType.INTERNAL_TRACE_STATUS) {
            return (V)this.getInternalTraceStatus();
        }
        if (attribute == RegionType.AUXILIARY_TRACE_SWITCH_TYPE) {
            return (V)this.getAuxiliaryTraceSwitchType();
        }
        if (attribute == RegionType.INTERNAL_TRACE_TABLE_SIZE) {
            return (V)this.getInternalTraceTableSize();
        }
        if (attribute == RegionType.SINGLE_TRACE_STATUS) {
            return (V)this.getSingleTraceStatus();
        }
        if (attribute == RegionType.SYSTEM_TRACE_STATUS) {
            return (V)this.getSystemTraceStatus();
        }
        if (attribute == RegionType.EXIT_TRACE_STATUS) {
            return (V)this.getExitTraceStatus();
        }
        if (attribute == RegionType.USER_TRACE_STATUS) {
            return (V)this.getUserTraceStatus();
        }
        if (attribute == RegionType.LAST_RESET_TIME) {
            return (V)this.getLastResetTime();
        }
        if (attribute == RegionType.PEAK_TASK_COUNT) {
            return (V)this.getPeakTaskCount();
        }
        if (attribute == RegionType.LOADER_REQUEST_COUNT) {
            return (V)this.getLoaderRequestCount();
        }
        if (attribute == RegionType.TOTAL_LOADING_TIME) {
            return (V)this.getTotalLoadingTime();
        }
        if (attribute == RegionType.PROGRAM_REMOVE_COUNT) {
            return (V)this.getProgramRemoveCount();
        }
        if (attribute == RegionType.PRGMWAIT) {
            return (V)this.getPrgmwait();
        }
        if (attribute == RegionType.LOADER_WAIT_COUNT) {
            return (V)this.getLoaderWaitCount();
        }
        if (attribute == RegionType.PEAK_LOADER_WAIT_COUNT) {
            return (V)this.getPeakLoaderWaitCount();
        }
        if (attribute == RegionType.LOADHWMC) {
            return (V)this.getLoadhwmc();
        }
        if (attribute == RegionType.TOTAL_LOADER_WAIT_TIME) {
            return (V)this.getTotalLoaderWaitTime();
        }
        if (attribute == RegionType.RDEBRBLD) {
            return (V)this.getRdebrbld();
        }
        if (attribute == RegionType.PRGMRCMP) {
            return (V)this.getPrgmrcmp();
        }
        if (attribute == RegionType.LOADTNIU) {
            return (V)this.getLoadtniu();
        }
        if (attribute == RegionType.LOADPNIU) {
            return (V)this.getLoadpniu();
        }
        if (attribute == RegionType.LOADRNIU) {
            return (V)this.getLoadrniu();
        }
        if (attribute == RegionType.SYSDUMPS_TAKEN_COUNT) {
            return (V)this.getSysdumpsTakenCount();
        }
        if (attribute == RegionType.SYSDUMPS_SUPPRESSED_COUNT) {
            return (V)this.getSysdumpsSuppressedCount();
        }
        if (attribute == RegionType.TRANDUMPS_TAKEN_COUNT) {
            return (V)this.getTrandumpsTakenCount();
        }
        if (attribute == RegionType.TRANDUMPS_SUPPRESSED_COUNT) {
            return (V)this.getTrandumpsSuppressedCount();
        }
        if (attribute == RegionType.CICS_START_TIME) {
            return (V)this.getCICSStartTime();
        }
        if (attribute == RegionType.CICS_SYSTEM_ID) {
            return (V)this.getCICSSystemID();
        }
        if (attribute == RegionType.TOTAL_CPU) {
            return (V)this.getTotalCPU();
        }
        if (attribute == RegionType.PAGE_IN_COUNT) {
            return (V)this.getPageInCount();
        }
        if (attribute == RegionType.PAGE_OUT_COUNT) {
            return (V)this.getPageOutCount();
        }
        if (attribute == RegionType.REAL_STORAGE) {
            return (V)this.getRealStorage();
        }
        if (attribute == RegionType.IO_COUNT) {
            return (V)this.getIOCount();
        }
        if (attribute == RegionType.VTAM_STATUS) {
            return (V)this.getVTAMStatus();
        }
        if (attribute == RegionType.VTMRPLMAX) {
            return (V)this.getVtmrplmax();
        }
        if (attribute == RegionType.VTMRPLPOST) {
            return (V)this.getVtmrplpost();
        }
        if (attribute == RegionType.VTMSOSCNT) {
            return (V)this.getVtmsoscnt();
        }
        if (attribute == RegionType.VTMACBDOPE) {
            return (V)this.getVtmacbdope();
        }
        if (attribute == RegionType.CURRENT_DUMP_DS) {
            return (V)this.getCurrentDumpDS();
        }
        if (attribute == RegionType.INITIAL_DUMP_DS) {
            return (V)this.getInitialDumpDS();
        }
        if (attribute == RegionType.CURRENT_AUXILIARY_TRACE_DS) {
            return (V)this.getCurrentAuxiliaryTraceDS();
        }
        if (attribute == RegionType.LUCURR) {
            return (V)this.getLucurr();
        }
        if (attribute == RegionType.LUHWM) {
            return (V)this.getLuhwm();
        }
        if (attribute == RegionType.PRSSINQCNT) {
            return (V)this.getPrssinqcnt();
        }
        if (attribute == RegionType.PRSSNIBCNT) {
            return (V)this.getPrssnibcnt();
        }
        if (attribute == RegionType.PRSSOPNCNT) {
            return (V)this.getPrssopncnt();
        }
        if (attribute == RegionType.PRSSUNBNDCNT) {
            return (V)this.getPrssunbndcnt();
        }
        if (attribute == RegionType.PRSSERRORCNT) {
            return (V)this.getPrsserrorcnt();
        }
        if (attribute == RegionType.CONVERSEST) {
            return (V)this.getConversest();
        }
        if (attribute == RegionType.FREQUENCY) {
            return (V)this.getFrequency();
        }
        if (attribute == RegionType.SUBSYSTEMID) {
            return (V)this.getSubsystemid();
        }
        if (attribute == RegionType.SYNCPOINTST) {
            return (V)this.getSyncpointst();
        }
        if (attribute == RegionType.MONRPTTIME) {
            return (V)this.getMonrpttime();
        }
        if (attribute == RegionType.DEFAULT_USER_ID) {
            return (V)this.getDefaultUserID();
        }
        if (attribute == RegionType.AUTOINSTALL_PROGRAM_EXIT) {
            return (V)this.getAutoinstallProgramExit();
        }
        if (attribute == RegionType.AUTOINSTALL_PROGRAM_CATALOG_TYPE) {
            return (V)this.getAutoinstallProgramCatalogType();
        }
        if (attribute == RegionType.AUTOINSTALL_PROGRAM_STATUS) {
            return (V)this.getAutoinstallProgramStatus();
        }
        if (attribute == RegionType.TRANSACTION_ISOLATION) {
            return (V)this.getTransactionIsolation();
        }
        if (attribute == RegionType.STARTUP_DATE) {
            return (V)this.getStartupDate();
        }
        if (attribute == RegionType.PSDINTERVAL) {
            return (V)this.getPsdinterval();
        }
        if (attribute == RegionType.TASK_COUNT) {
            return (V)this.getTaskCount();
        }
        if (attribute == RegionType.MAXIMUM_TASKS_COUNT) {
            return (V)this.getMaximumTasksCount();
        }
        if (attribute == RegionType.USER_TRANSACTION_COUNT) {
            return (V)this.getUserTransactionCount();
        }
        if (attribute == RegionType.QUEUED_TASK_COUNT) {
            return (V)this.getQueuedTaskCount();
        }
        if (attribute == RegionType.PEAK_USER_TRANSACTION_COUNT) {
            return (V)this.getPeakUserTransactionCount();
        }
        if (attribute == RegionType.PEAK_QUEUED_TASK_COUNT) {
            return (V)this.getPeakQueuedTaskCount();
        }
        if (attribute == RegionType.TOTACTVUSRTR) {
            return (V)this.getTotactvusrtr();
        }
        if (attribute == RegionType.TOTDELYUSRTR) {
            return (V)this.getTotdelyusrtr();
        }
        if (attribute == RegionType.TOTQUETIME) {
            return (V)this.getTotquetime();
        }
        if (attribute == RegionType.CURQUETIME) {
            return (V)this.getCurquetime();
        }
        if (attribute == RegionType.AUTOINSTALL_PROGRAM_ATTEMPTS_COUNT) {
            return (V)this.getAutoinstallProgramAttemptsCount();
        }
        if (attribute == RegionType.AUTOINSTALL_PROGRAM_REJECTS_COUNT) {
            return (V)this.getAutoinstallProgramRejectsCount();
        }
        if (attribute == RegionType.AUTOINSTALL_PROGRAM_FAILED_ATTEMPTS_COUNT) {
            return (V)this.getAutoinstallProgramFailedAttemptsCount();
        }
        if (attribute == RegionType.INITIALIZATION_STATUS) {
            return (V)this.getInitializationStatus();
        }
        if (attribute == RegionType.SHUTDOWN_STATUS) {
            return (V)this.getShutdownStatus();
        }
        if (attribute == RegionType.INTVTRANS) {
            return (V)this.getIntvtrans();
        }
        if (attribute == RegionType.GMM_TEXT) {
            return (V)this.getGMMText();
        }
        if (attribute == RegionType.GMM_LENGTH) {
            return (V)this.getGMMLength();
        }
        if (attribute == RegionType.GRNAME) {
            return (V)this.getGrname();
        }
        if (attribute == RegionType.GRSTATUS) {
            return (V)this.getGrstatus();
        }
        if (attribute == RegionType.REENTRANT_PROGRAM_PROTECTION_STATUS) {
            return (V)this.getReentrantProgramProtectionStatus();
        }
        if (attribute == RegionType.COMMAND_PROTECTION_STATUS) {
            return (V)this.getCommandProtectionStatus();
        }
        if (attribute == RegionType.SOS_BELOW_BAR) {
            return (V)this.getSOSBelowBar();
        }
        if (attribute == RegionType.TOTAL_TASK_COUNT) {
            return (V)this.getTotalTaskCount();
        }
        if (attribute == RegionType.RLS_STATUS) {
            return (V)this.getRLSStatus();
        }
        if (attribute == RegionType.SHUTDOWN_TRANSACTION) {
            return (V)this.getShutdownTransaction();
        }
        if (attribute == RegionType.DSIDLE) {
            return (V)this.getDsidle();
        }
        if (attribute == RegionType.DSINTERVAL) {
            return (V)this.getDsinterval();
        }
        if (attribute == RegionType.CICSTS_LEVEL) {
            return (V)this.getCICSTSLevel();
        }
        if (attribute == RegionType.OS_LEVEL) {
            return (V)this.getOSLevel();
        }
        if (attribute == RegionType.RRMSSTAT) {
            return (V)this.getRrmsstat();
        }
        if (attribute == RegionType.MVSSYSNAME) {
            return (V)this.getMvssysname();
        }
        if (attribute == RegionType.FORCEQR) {
            return (V)this.getForceqr();
        }
        if (attribute == RegionType.MAXIMUM_OPEN_TCB_COUNT) {
            return (V)this.getMaximumOpenTCBCount();
        }
        if (attribute == RegionType.CURRENT_OPEN_POOL_TCB_COUNT) {
            return (V)this.getCurrentOpenPoolTCBCount();
        }
        if (attribute == RegionType.DISTRIBUTED_ROUTING_PROGRAM) {
            return (V)this.getDistributedRoutingProgram();
        }
        if (attribute == RegionType.AUTOINSTALL_CONSOLE_STATUS) {
            return (V)this.getAutoinstallConsoleStatus();
        }
        if (attribute == RegionType.TCPIP_STATUS) {
            return (V)this.getTCPIPStatus();
        }
        if (attribute == RegionType.GARBAGEINT) {
            return (V)this.getGarbageint();
        }
        if (attribute == RegionType.TIMEOUTINT) {
            return (V)this.getTimeoutint();
        }
        if (attribute == RegionType.COLDSTATUS) {
            return (V)this.getColdstatus();
        }
        if (attribute == RegionType.MAXIMUM_HP_POOL_TCB_COUNT) {
            return (V)this.getMaximumHPPoolTCBCount();
        }
        if (attribute == RegionType.CURRENT_HP_POOL_TCB_COUNT) {
            return (V)this.getCurrentHPPoolTCBCount();
        }
        if (attribute == RegionType.MAXIMUM_JVM_POOL_TCB_COUNT) {
            return (V)this.getMaximumJVMPoolTCBCount();
        }
        if (attribute == RegionType.CURRENT_JVM_POOL_TCB_COUNT) {
            return (V)this.getCurrentJVMPoolTCBCount();
        }
        if (attribute == RegionType.SUBTASKS) {
            return (V)this.getSubtasks();
        }
        if (attribute == RegionType.DEBUG_TOOL) {
            return (V)this.getDebugTool();
        }
        if (attribute == RegionType.MAXIMUM_XP_LINK_POOL_TCB_COUNT) {
            return (V)this.getMaximumXPLinkPoolTCBCount();
        }
        if (attribute == RegionType.CURRENT_XP_LINK_POOL_TCB_COUNT) {
            return (V)this.getCurrentXPLinkPoolTCBCount();
        }
        if (attribute == RegionType.MAXIMUM_SSL_POOL_TCB_COUNT) {
            return (V)this.getMaximumSSLPoolTCBCount();
        }
        if (attribute == RegionType.CURRENT_SSL_POOL_TCB_COUNT) {
            return (V)this.getCurrentSSLPoolTCBCount();
        }
        if (attribute == RegionType.XCFGROUP) {
            return (V)this.getXcfgroup();
        }
        if (attribute == RegionType.STORAGE_LIMIT) {
            return (V)this.getStorageLimit();
        }
        if (attribute == RegionType.SOS_ABOVE_BAR) {
            return (V)this.getSOSAboveBar();
        }
        if (attribute == RegionType.SOS_ABOVE_LINE) {
            return (V)this.getSOSAboveLine();
        }
        if (attribute == RegionType.SOS_BELOW_LINE) {
            return (V)this.getSOSBelowLine();
        }
        if (attribute == RegionType.LDGLBSOU) {
            return (V)this.getLdglbsou();
        }
        if (attribute == RegionType.LDGLWSOU) {
            return (V)this.getLdglwsou();
        }
        if (attribute == RegionType.LDGLSORT) {
            return (V)this.getLdglsort();
        }
        if (attribute == RegionType.PSTYPE) {
            return (V)this.getPstype();
        }
        if (attribute == RegionType.IDNTYCLASS) {
            return (V)this.getIdntyclass();
        }
        if (attribute == RegionType.CURRENT_JVM_SERVER_THREAD_TCB_COUNT) {
            return (V)this.getCurrentJVMServerThreadTCBCount();
        }
        if (attribute == RegionType.MAXIMUM_JVM_SERVER_THREAD_COUNT) {
            return (V)this.getMaximumJVMServerThreadCount();
        }
        if (attribute == RegionType.JOBID) {
            return (V)this.getJobid();
        }
        if (attribute == RegionType.MAXTASKS_LAST_CHANGED_TIME) {
            return (V)this.getMAXTASKSLastChangedTime();
        }
        if (attribute == RegionType.LAST_TRANSACTION_ATTACHED_TIME) {
            return (V)this.getLastTransactionAttachedTime();
        }
        if (attribute == RegionType.MAXTASKS_LIMIT_LAST_REACHED_TIME) {
            return (V)this.getMAXTASKSLimitLastReachedTime();
        }
        if (attribute == RegionType.CURRENTLY_AT_MXT) {
            return (V)this.getCurrentlyAtMXT();
        }
        V value = super.getAttributeValue(attribute);
        if (value != null) {
            return value;
        }
        throw new IllegalArgumentException("Supplied attribute \"" + attribute + "\" was not a valid attribute for type " + RegionType.getInstance());
    }
}

