/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.OSGiServiceReference;
import com.ibm.cics.core.model.OSGiServiceType;
import com.ibm.cics.core.model.internal.MutableCICSResource;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.IOSGiService;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableOSGiService;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;

public class MutableOSGiService
extends MutableCICSResource
implements IMutableOSGiService {
    private IOSGiService delegate;
    private MutableSMRecord record;

    public MutableOSGiService(ICPSM cpsm, IContext context, IOSGiService cicsObject) {
        super(cpsm, context, (ICICSResource)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("OSGISERV");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    public Long getServiceId() {
        return this.delegate.getServiceId();
    }

    public IOSGiService.ServiceStatusValue getServiceStatus() {
        return this.delegate.getServiceStatus();
    }

    public String getJvmServer() {
        return this.delegate.getJvmServer();
    }

    public String getBundle() {
        return this.delegate.getBundle();
    }

    public String getBundlePart() {
        return this.delegate.getBundlePart();
    }

    public String getOsgiVersion() {
        return this.delegate.getOsgiVersion();
    }

    public String getOsgiBundle() {
        return this.delegate.getOsgiBundle();
    }

    public String getServiceName() {
        return this.delegate.getServiceName();
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == OSGiServiceType.SERVICE_ID) {
            return (V)this.getServiceId();
        }
        if (attribute == OSGiServiceType.SERVICE_STATUS) {
            return (V)this.getServiceStatus();
        }
        if (attribute == OSGiServiceType.JVM_SERVER) {
            return (V)this.getJvmServer();
        }
        if (attribute == OSGiServiceType.BUNDLE) {
            return (V)this.getBundle();
        }
        if (attribute == OSGiServiceType.BUNDLE_PART) {
            return (V)this.getBundlePart();
        }
        if (attribute == OSGiServiceType.OSGI_VERSION) {
            return (V)this.getOsgiVersion();
        }
        if (attribute == OSGiServiceType.OSGI_BUNDLE) {
            return (V)this.getOsgiBundle();
        }
        if (attribute == OSGiServiceType.SERVICE_NAME) {
            return (V)this.getServiceName();
        }
        return super.getAttributeValue(attribute);
    }

    public OSGiServiceType getObjectType() {
        return OSGiServiceType.getInstance();
    }

    @Override
    public OSGiServiceReference getCICSObjectReference() {
        return new OSGiServiceReference(this.getCICSContainer(), this.getServiceId(), this.getJvmServer());
    }
}

