/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.ProcessTypeReference;
import com.ibm.cics.core.model.ProcessTypeType;
import com.ibm.cics.core.model.internal.MutableCICSResource;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSEnums;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.IProcessType;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableProcessType;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Date;

public class MutableProcessType
extends MutableCICSResource
implements IMutableProcessType {
    private IProcessType delegate;
    private MutableSMRecord record;

    public MutableProcessType(ICPSM cpsm, IContext context, IProcessType cicsObject) {
        super(cpsm, context, (ICICSResource)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("PROCTYP");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    public String getFile() {
        return this.delegate.getFile();
    }

    public String getAuditLog() {
        return this.delegate.getAuditLog();
    }

    public IProcessType.AuditLevelValue getAuditLevel() {
        String result = this.record.get("AUDITLEV");
        if (result == null) {
            return this.delegate.getAuditLevel();
        }
        return (IProcessType.AuditLevelValue)((CICSAttribute)ProcessTypeType.AUDIT_LEVEL).get(result, this.record.getNormalizers());
    }

    public ICICSEnums.EnablementValue getStatus() {
        String result = this.record.get("ENASTAT");
        if (result == null) {
            return this.delegate.getStatus();
        }
        return (ICICSEnums.EnablementValue)((CICSAttribute)ProcessTypeType.STATUS).get(result, this.record.getNormalizers());
    }

    public IProcessType.ChangeAgentValue getChangeAgent() {
        return this.delegate.getChangeAgent();
    }

    public String getChangeUserID() {
        return this.delegate.getChangeUserID();
    }

    public String getChangeAgentRelease() {
        return this.delegate.getChangeAgentRelease();
    }

    public Date getChangeTime() {
        return this.delegate.getChangeTime();
    }

    public String getDefineSource() {
        return this.delegate.getDefineSource();
    }

    public Date getDefineTime() {
        return this.delegate.getDefineTime();
    }

    public String getInstallUserID() {
        return this.delegate.getInstallUserID();
    }

    public Date getInstallTime() {
        return this.delegate.getInstallTime();
    }

    public IProcessType.InstallAgentValue getInstallAgent() {
        return this.delegate.getInstallAgent();
    }

    public Long getBasdefinever() {
        return this.delegate.getBasdefinever();
    }

    public void setAuditLevel(IProcessType.AuditLevelValue _auditLevel) {
        if (_auditLevel.equals((Object)this.delegate.getAuditLevel())) {
            this.record.set("AUDITLEV", null);
        } else {
            ProcessTypeType.AUDIT_LEVEL.validate((Object)_auditLevel);
            String connectionSpecificExternalValue = ((CICSAttribute)ProcessTypeType.AUDIT_LEVEL).set(_auditLevel, this.record.getNormalizers());
            this.record.set("AUDITLEV", connectionSpecificExternalValue);
        }
    }

    public void setStatus(ICICSEnums.EnablementValue _status) {
        if (_status.equals((Object)this.delegate.getStatus())) {
            this.record.set("ENASTAT", null);
        } else {
            ProcessTypeType.STATUS.validate((Object)_status);
            String connectionSpecificExternalValue = ((CICSAttribute)ProcessTypeType.STATUS).set(_status, this.record.getNormalizers());
            this.record.set("ENASTAT", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == ProcessTypeType.NAME) {
            return (V)this.getName();
        }
        if (attribute == ProcessTypeType.FILE) {
            return (V)this.getFile();
        }
        if (attribute == ProcessTypeType.AUDIT_LOG) {
            return (V)this.getAuditLog();
        }
        if (attribute == ProcessTypeType.AUDIT_LEVEL) {
            return (V)this.getAuditLevel();
        }
        if (attribute == ProcessTypeType.STATUS) {
            return (V)this.getStatus();
        }
        if (attribute == ProcessTypeType.CHANGE_AGENT) {
            return (V)this.getChangeAgent();
        }
        if (attribute == ProcessTypeType.CHANGE_USER_ID) {
            return (V)this.getChangeUserID();
        }
        if (attribute == ProcessTypeType.CHANGE_AGENT_RELEASE) {
            return (V)this.getChangeAgentRelease();
        }
        if (attribute == ProcessTypeType.CHANGE_TIME) {
            return (V)this.getChangeTime();
        }
        if (attribute == ProcessTypeType.DEFINE_SOURCE) {
            return (V)this.getDefineSource();
        }
        if (attribute == ProcessTypeType.DEFINE_TIME) {
            return (V)this.getDefineTime();
        }
        if (attribute == ProcessTypeType.INSTALL_USER_ID) {
            return (V)this.getInstallUserID();
        }
        if (attribute == ProcessTypeType.INSTALL_TIME) {
            return (V)this.getInstallTime();
        }
        if (attribute == ProcessTypeType.INSTALL_AGENT) {
            return (V)this.getInstallAgent();
        }
        if (attribute == ProcessTypeType.BASDEFINEVER) {
            return (V)this.getBasdefinever();
        }
        return super.getAttributeValue(attribute);
    }

    public ProcessTypeType getObjectType() {
        return ProcessTypeType.getInstance();
    }

    @Override
    public ProcessTypeReference getCICSObjectReference() {
        return new ProcessTypeReference(this.getCICSContainer(), this.getName());
    }
}

