/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.WorkloadReference;
import com.ibm.cics.core.model.WorkloadType;
import com.ibm.cics.core.model.internal.CPSMManager;
import com.ibm.cics.model.IWorkload;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Map;

public class Workload
extends CPSMManager
implements IWorkload {
    private String _workload;
    private IWorkload.DefaultAffinityTypeValue _affinity;
    private IWorkload.DefaultAffinityLifetimeValue _afflife;
    private Long _torcnt;
    private Long _aorcnt;
    private String _aorscope;
    private String _desc;
    private IWorkload.WorkloadStatusValue _status;
    private IWorkload.AlgorithmTypeValue _algtype;
    private Long _abendcrit;
    private Long _abendthresh;
    private String _eventname;
    private String _wrklowner;
    private IWorkload.AutomaticAffinityCreationValue _affauto;
    private IWorkload.SharedValue _shared;
    private IWorkload.OptimizationStatusValue _owstate;
    private Long _wdefcnt;
    private Long _wtrncnt;
    private Long _wtgpcnt;
    private Long _waffcnt;

    public Workload(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("WORKLOAD");
        this._workload = (String)((CICSAttribute)WorkloadType.NAME).get(stringValue, normalizers);
        stringValue = record.get("AFFINITY");
        this._affinity = (IWorkload.DefaultAffinityTypeValue)((CICSAttribute)WorkloadType.DEFAULT_AFFINITY_TYPE).get(stringValue, normalizers);
        stringValue = record.get("AFFLIFE");
        this._afflife = (IWorkload.DefaultAffinityLifetimeValue)((CICSAttribute)WorkloadType.DEFAULT_AFFINITY_LIFETIME).get(stringValue, normalizers);
        stringValue = record.get("TORCNT");
        this._torcnt = (Long)((CICSAttribute)WorkloadType.ACTIVE_ROUTING_REGIONS).get(stringValue, normalizers);
        stringValue = record.get("AORCNT");
        this._aorcnt = (Long)((CICSAttribute)WorkloadType.ACTIVE_TARGET_REGIONS).get(stringValue, normalizers);
        stringValue = record.get("AORSCOPE");
        this._aorscope = (String)((CICSAttribute)WorkloadType.DEFAULT_TARGET_SCOPE).get(stringValue, normalizers);
        stringValue = record.get("DESC");
        this._desc = (String)((CICSAttribute)WorkloadType.DESCRIPTION).get(stringValue, normalizers);
        stringValue = record.get("STATUS");
        this._status = (IWorkload.WorkloadStatusValue)((CICSAttribute)WorkloadType.WORKLOAD_STATUS).get(stringValue, normalizers);
        stringValue = record.get("ALGTYPE");
        this._algtype = (IWorkload.AlgorithmTypeValue)((CICSAttribute)WorkloadType.ALGORITHM_TYPE).get(stringValue, normalizers);
        stringValue = record.get("ABENDCRIT");
        this._abendcrit = (Long)((CICSAttribute)WorkloadType.ABENDCRIT).get(stringValue, normalizers);
        stringValue = record.get("ABENDTHRESH");
        this._abendthresh = (Long)((CICSAttribute)WorkloadType.ABENDTHRESH).get(stringValue, normalizers);
        stringValue = record.get("EVENTNAME");
        this._eventname = (String)((CICSAttribute)WorkloadType.EVENT_NAME).get(stringValue, normalizers);
        stringValue = record.get("WRKLOWNER");
        this._wrklowner = (String)((CICSAttribute)WorkloadType.OWNING_SYSTEM_ID).get(stringValue, normalizers);
        stringValue = record.get("AFFAUTO");
        this._affauto = (IWorkload.AutomaticAffinityCreationValue)((CICSAttribute)WorkloadType.AUTOMATIC_AFFINITY_CREATION).get(stringValue, normalizers);
        stringValue = record.get("SHARED");
        this._shared = (IWorkload.SharedValue)((CICSAttribute)WorkloadType.SHARED).get(stringValue, normalizers);
        stringValue = record.get("OWSTATE");
        this._owstate = (IWorkload.OptimizationStatusValue)((CICSAttribute)WorkloadType.OPTIMIZATION_STATUS).get(stringValue, normalizers);
        stringValue = record.get("WDEFCNT");
        this._wdefcnt = (Long)((CICSAttribute)WorkloadType.WDEFCNT).get(stringValue, normalizers);
        stringValue = record.get("WTRNCNT");
        this._wtrncnt = (Long)((CICSAttribute)WorkloadType.WTRNCNT).get(stringValue, normalizers);
        stringValue = record.get("WTGPCNT");
        this._wtgpcnt = (Long)((CICSAttribute)WorkloadType.WTGPCNT).get(stringValue, normalizers);
        stringValue = record.get("WAFFCNT");
        this._waffcnt = (Long)((CICSAttribute)WorkloadType.WAFFCNT).get(stringValue, normalizers);
    }

    public String getName() {
        return this._workload;
    }

    public IWorkload.DefaultAffinityTypeValue getDefaultAffinityType() {
        return this._affinity;
    }

    public IWorkload.DefaultAffinityLifetimeValue getDefaultAffinityLifetime() {
        return this._afflife;
    }

    public Long getActiveRoutingRegions() {
        return this._torcnt;
    }

    public Long getActiveTargetRegions() {
        return this._aorcnt;
    }

    public String getDefaultTargetScope() {
        return this._aorscope;
    }

    public String getDescription() {
        return this._desc;
    }

    public IWorkload.WorkloadStatusValue getWorkloadStatus() {
        return this._status;
    }

    public IWorkload.AlgorithmTypeValue getAlgorithmType() {
        return this._algtype;
    }

    public Long getAbendcrit() {
        return this._abendcrit;
    }

    public Long getAbendthresh() {
        return this._abendthresh;
    }

    public String getEventName() {
        return this._eventname;
    }

    public String getOwningSystemID() {
        return this._wrklowner;
    }

    public IWorkload.AutomaticAffinityCreationValue getAutomaticAffinityCreation() {
        return this._affauto;
    }

    public IWorkload.SharedValue getShared() {
        return this._shared;
    }

    public IWorkload.OptimizationStatusValue getOptimizationStatus() {
        return this._owstate;
    }

    public Long getWdefcnt() {
        return this._wdefcnt;
    }

    public Long getWtrncnt() {
        return this._wtrncnt;
    }

    public Long getWtgpcnt() {
        return this._wtgpcnt;
    }

    public Long getWaffcnt() {
        return this._waffcnt;
    }

    public WorkloadType getObjectType() {
        return WorkloadType.getInstance();
    }

    @Override
    public WorkloadReference getCICSObjectReference() {
        return new WorkloadReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == WorkloadType.NAME) {
            return (V)this.getName();
        }
        if (attribute == WorkloadType.DEFAULT_AFFINITY_TYPE) {
            return (V)this.getDefaultAffinityType();
        }
        if (attribute == WorkloadType.DEFAULT_AFFINITY_LIFETIME) {
            return (V)this.getDefaultAffinityLifetime();
        }
        if (attribute == WorkloadType.ACTIVE_ROUTING_REGIONS) {
            return (V)this.getActiveRoutingRegions();
        }
        if (attribute == WorkloadType.ACTIVE_TARGET_REGIONS) {
            return (V)this.getActiveTargetRegions();
        }
        if (attribute == WorkloadType.DEFAULT_TARGET_SCOPE) {
            return (V)this.getDefaultTargetScope();
        }
        if (attribute == WorkloadType.DESCRIPTION) {
            return (V)this.getDescription();
        }
        if (attribute == WorkloadType.WORKLOAD_STATUS) {
            return (V)this.getWorkloadStatus();
        }
        if (attribute == WorkloadType.ALGORITHM_TYPE) {
            return (V)this.getAlgorithmType();
        }
        if (attribute == WorkloadType.ABENDCRIT) {
            return (V)this.getAbendcrit();
        }
        if (attribute == WorkloadType.ABENDTHRESH) {
            return (V)this.getAbendthresh();
        }
        if (attribute == WorkloadType.EVENT_NAME) {
            return (V)this.getEventName();
        }
        if (attribute == WorkloadType.OWNING_SYSTEM_ID) {
            return (V)this.getOwningSystemID();
        }
        if (attribute == WorkloadType.AUTOMATIC_AFFINITY_CREATION) {
            return (V)this.getAutomaticAffinityCreation();
        }
        if (attribute == WorkloadType.SHARED) {
            return (V)this.getShared();
        }
        if (attribute == WorkloadType.OPTIMIZATION_STATUS) {
            return (V)this.getOptimizationStatus();
        }
        if (attribute == WorkloadType.WDEFCNT) {
            return (V)this.getWdefcnt();
        }
        if (attribute == WorkloadType.WTRNCNT) {
            return (V)this.getWtrncnt();
        }
        if (attribute == WorkloadType.WTGPCNT) {
            return (V)this.getWtgpcnt();
        }
        if (attribute == WorkloadType.WAFFCNT) {
            return (V)this.getWaffcnt();
        }
        V value = super.getAttributeValue(attribute);
        if (value != null) {
            return value;
        }
        throw new IllegalArgumentException("Supplied attribute \"" + attribute + "\" was not a valid attribute for type " + WorkloadType.getInstance());
    }
}

