/*<copyright                                                          */
/* notice="cics-rm-source-program"                                    */
/* pids="CA0U"                                                        */
/* years="2014,2015"                                                  */
/* crc="1090885440" >                                                 */
/* 	Licensed Materials - Property of IBM                              */
/* 	"Restricted Materials of IBM"                                     */
/* 	CA0U                                                              */
/* 	(C) Copyright IBM Corp. 2014, 2015                                */
/* 	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
/* </copyright>                                                       */
package com.ibm.cics.ucd.steps

import java.text.MessageFormat
import java.util.List;

import com.ibm.cics.core.model.CICSSystemManagerException
import com.ibm.cics.sm.comm.SystemManagerActions
import com.ibm.cics.core.model.FilteredContext
import com.ibm.cics.core.model.GenTypeClasses
import com.ibm.cics.core.model.ICPSM
import com.ibm.cics.core.model.CICSTypesRegistry
import com.ibm.cics.model.ICICSObject
import com.ibm.cics.model.ICICSType
import com.ibm.cics.sm.comm.ICICSAction;
import com.ibm.cics.sm.comm.IContext
import com.ibm.cics.ucd.CPSMHelper
import com.ibm.cics.ucd.CheckStatusHelper;
import com.ibm.cics.ucd.exceptions.StepFailedException
import com.ibm.cics.ucd.msg.CICSUCDMessage
import com.ibm.cics.ucd.properties.IntegerProperty
import com.ibm.cics.ucd.properties.ResourceNameListProperty
import com.ibm.cics.ucd.properties.ResourceNameListPropertySupportWildCard
import com.ibm.cics.ucd.steplabel.CICSUCDStepLabel
import com.urbancode.air.AirPluginTool

abstract class AbstractCheckActionStep extends CICSStep {
	// <copyright 
	// notice="cics-rm-source-program" 
	// pids="CA0U" 
	// years="2014,2015" 
	// crc="1813425462" > 
	// 	Licensed Materials - Property of IBM 
	// 	"Restricted Materials of IBM" 
	// 	CA0U 
	// 	(C) Copyright IBM Corp. 2014, 2015 
	// 	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
	// </copyright> 

	public static final String EXPECTED_STATUS = "expectedStatus"

	AbstractCheckActionStep(String inputPropertyFile, String outputPropertyFile) {
		super(inputPropertyFile, outputPropertyFile)
	}

	AbstractCheckActionStep(AirPluginTool apTool) {
		super(apTool)
	}

	/**
	 * Primarily to support unit testing
	 * @param cpsm
	 */
	AbstractCheckActionStep(String inputPropertyFile, String outputPropertyFile, ICPSM cpsm) {
		super(inputPropertyFile, outputPropertyFile)
		this.cpsm = cpsm
	}

	AbstractCheckActionStep(AirPluginTool apTool, ICPSM cpsm) {
		super(apTool)
		this.cpsm = cpsm
	}
	
	protected String getResourceType(Properties props){
		return props[RESOURCE_TYPE]
	}
	
	protected String getExpectedStatus(Properties props){
		return props[EXPECTED_STATUS]
	}
	
	protected List<String> getResourceNameList(CPSMHelper cpsmHelper, Properties props, String resourceType) {		
		return new ResourceNameListPropertySupportWildCard(CICSUCDStepLabel.RESOURCE_NAME_LIST, resourceType, cpsmHelper.isNameCaseSensitive(resourceType), true).parse(props['resourceNameList']).getValue()
		
	}
	
	protected void runCICSStep(ICPSM cpsm, IContext context) {
		
		String checkedField;
		def CheckStatusHelper = new CheckStatusHelper();
		def cpsmHelper = new CPSMHelper();

		def props = apTool.getStepProperties()
		def resourceType = getResourceType(props)
		def expectedStatus = getExpectedStatus(props)
		def timeout = new IntegerProperty("Timeout(s)", true).parse(props['timeout']).getValue()
		def resourceNameList = getResourceNameList(cpsmHelper, props, resourceType)

		ICICSType<?> type = CICSTypesRegistry.findForResourceTableName(resourceType);

		checkedField = determineCheckField(type);

		log(MessageFormat.format(CICSUCDMessage.BeforeCheckStatusStep,resourceType, expectedStatus))

		//Perform action on the resource
		boolean stepResult = CheckStatusHelper.queryActionWithTimeout(cpsm, type, context, resourceNameList,expectedStatus, timeout,checkedField,errorList)

		if (stepResult==false) {
			throw new StepFailedException("Step failed.");
		}
	}
	
	protected abstract String determineCheckField(ICICSType type);

}
