/*<copyright                                                          */
/* notice="cics-rm-source-program"                                    */
/* pids="CA0U"                                                        */
/* years="2014,2015"                                                  */
/* crc="3778686503" >                                                 */
/* 	Licensed Materials - Property of IBM                              */
/* 	"Restricted Materials of IBM"                                     */
/* 	CA0U                                                              */
/* 	(C) Copyright IBM Corp. 2014, 2015                                */
/* 	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
/* </copyright>                                                       */
package com.ibm.cics.ucd.steps

import com.ibm.cics.core.model.CICSSystemManagerException
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.CICSCore;
import com.ibm.cics.core.model.FilteredContext
import com.ibm.cics.core.model.GenTypeClasses
import com.ibm.cics.model.ICICSObject
import com.ibm.cics.model.ICICSType
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SystemManagerActions;
import com.ibm.cics.ucd.CPSMHelper
import com.ibm.cics.ucd.ExceptionHandler
import com.ibm.cics.ucd.exceptions.StepFailedException
import com.ibm.cics.ucd.properties.CommonCICSNameProperty
import com.ibm.cics.ucd.properties.ResourceNameListProperty
import com.ibm.cics.ucd.steplabel.CICSUCDStepLabel
import com.ibm.cics.ucd.msg.CICSUCDMessage
import com.urbancode.air.AirPluginTool;

import java.text.MessageFormat

class InstallResourceFromCSDStep extends CICSStep{
	// <copyright 
	// notice="cics-rm-source-program" 
	// pids="CA0U" 
	// years="2014,2015" 
	// crc="2449307340" > 
	// 	Licensed Materials - Property of IBM 
	// 	"Restricted Materials of IBM" 
	// 	CA0U 
	// 	(C) Copyright IBM Corp. 2014, 2015 
	// 	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
	// </copyright> 

	public InstallResourceFromCSDStep(String inputPropertyFile, String outputPropertyFile) {
		this(inputPropertyFile, outputPropertyFile, CICSCore.getCPSM())
	}

	public InstallResourceFromCSDStep(AirPluginTool apTool) {
		this(apTool, CICSCore.getCPSM())
	}

	/**
	 * Primarily to support unit testing
	 * @param cpsm
	 */
	InstallResourceFromCSDStep(String inputPropertyFile, String outputPropertyFile, ICPSM cpsm) {
		super(inputPropertyFile, outputPropertyFile)
		this.cpsm = cpsm
	}

	InstallResourceFromCSDStep(AirPluginTool apTool, ICPSM cpsm) {
		super(apTool)
		this.cpsm = cpsm
	}

	@Override
	protected void runCICSStep(ICPSM cpsm, IContext context) {

		def cpsmHelper = new CPSMHelper()
		def exceptionHandler = new ExceptionHandler();
		def props = apTool.getStepProperties()
		//Resource type is a list from the stepUI -- No user input
		final def resourceType = props[RESOURCE_TYPE]
		final def groupName = new CommonCICSNameProperty(CICSUCDStepLabel.RESOURCE_NAME, true).parse(props['groupName']).getValue()
		final def resourceNameList = new ResourceNameListProperty(CICSUCDStepLabel.RESOURCE_NAME_LIST, resourceType,
			cpsmHelper.isNameCaseSensitive(resourceType), true).parse(props['resourceNameList']).getValue()

		//Get the resource type from given property 'resourceType'
		Class<? extends ICICSType<ICICSObject>> typeClass = GenTypeClasses.getCICSTypeClassForResourceTableName(resourceType)
		ICICSType<?> type = typeClass.invokeMethod("getInstance", null)

		//For step execution status use
		boolean stepFail = false
		int successCount = 0
		int failCount = 0

		//Issue message to start the step execution
		log(MessageFormat.format(CICSUCDMessage.installfromCSD))

		//Iterate to install each resource
		for(int i=0; i < resourceNameList.size(); i++) {
			
			try {				
				//Invoke specific method to install the resource
				boolean installSuccess = cpsmHelper.installCSDResource(cpsm, type, context, resourceNameList.get(i), groupName)
				if(installSuccess) 
					successCount++

			} catch (CICSSystemManagerException e) {
				failCount++
				stepFail = true
				//Any exception thrown in the install process handled here
				exceptionHandler.handleException(e, resourceType, SystemManagerActions.Install, resourceNameList.get(i),errorList)
			}

		}

		log(MessageFormat.format(CICSUCDMessage.resultSummary, 'INSTALL', Integer.toString(successCount), Integer.toString(failCount)))

		if (stepFail) {
			throw new StepFailedException("Step failed.");
		}


	}

}
