/*<copyright                                                          */
/* notice="cics-rm-source-program"                                    */
/* pids="CA0U"                                                        */
/* years="2015"                                                       */
/* crc="1921302770" >                                                 */
/* 	Licensed Materials - Property of IBM                              */
/* 	"Restricted Materials of IBM"                                     */
/* 	CA0U                                                              */
/* 	(C) Copyright IBM Corp. 2014, 2015                                */
/* 	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
/* </copyright>                                                       */
package com.ibm.cics.ucd

import static com.ibm.cics.model.AttributeValue.av
import static com.ibm.cics.ucd.StepLogHelper.printStepLog

import java.text.MessageFormat

import com.ibm.cics.core.model.CICSSystemManagerException
import com.ibm.cics.core.model.FilteredContext
import com.ibm.cics.core.model.ICPSM
import com.ibm.cics.model.ICICSType
import com.ibm.cics.sm.comm.ICICSAction
import com.ibm.cics.sm.comm.IContext
import com.ibm.cics.ucd.msg.CICSUCDMessage

class PerformActionHelper {

	// <copyright
	// notice="cics-rm-source-program"
	// pids="CA0U"
	// years="2015"
	// crc="1921302770" >
	// 	Licensed Materials - Property of IBM
	// 	"Restricted Materials of IBM"
	// 	CA0U
	// 	(C) Copyright IBM Corp. 2015
	// 	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
	// </copyright>

	private exceptionHandler = new ExceptionHandler();

	//Used by all perform actions(newcopy, phasein, enable, disable) and install resource description
	def performAction(ICPSM cpsm, ICICSType type, IContext context, ICICSAction cicsAction,String resourceName) throws Exception {
		cpsm.perform(context, type, cicsAction);
		printStepLog(MessageFormat.format(CICSUCDMessage.actionSucceedWithObjectNameAndType,
				cicsAction.getActionName(), type.getResourceTableName(), resourceName))
		return true;
	}

	//Perform action on all the resources from the resourceList, return a failedResourceName list
	def performActionOnResourceList(ICPSM cpsm, ICICSType type, IContext context, ICICSAction cicsAction, List<String> resourceNameList, List errorList) throws Exception {
		List<String> failedResourceNameList = new ArrayList<String>();
		for(int i=0; i < resourceNameList.size(); i++) {
			try {
				//Set a filter for the context
				FilteredContext filteredContext = new FilteredContext(context)
				filteredContext.setAttributeValue(type.NAME, resourceNameList.get(i))
				//Perform action on the resource
				performAction(cpsm, type, filteredContext, cicsAction, resourceNameList.get(i))

			} catch (CICSSystemManagerException e) {
				//Any exception thrown in the perform process handled here
				failedResourceNameList.add(resourceNameList.get(i));
				exceptionHandler.handleException(e, type.getResourceTableName(), cicsAction, resourceNameList.get(i),errorList)
			}
		}
		return failedResourceNameList
	}

	//Perform action on resourceNameList with retry and interval
	//Currently only used for NEWCOPY step
	def performActionWithRetry(ICPSM cpsm, ICICSType type, IContext context, ICICSAction cicsAction, List<String> resourceNameList, int retryTimes, int retryInterval,  List errorList) throws Exception {
		
		//RetryInterval always set to 0 when set to negative number
		if(retryInterval < 0)
			retryInterval = 0
		// number of attempts must be at least one, and should include retries as well as the original try
		int numberOfAttemptsRemaining = Math.max(1, retryTimes+1)
		List<String> failedResourceNameList = new ArrayList<String>(resourceNameList);
		List<String> tempResourceNameList = new ArrayList<String>();

		//Loop to do action on resources from failedResourceNameList
		while(numberOfAttemptsRemaining > 0 && failedResourceNameList.size() > 0){
			
			//Store failed resource name list into temporary one as we will clean failedresourceNameList first then add new failed resource into it
			tempResourceNameList.clear();
			tempResourceNameList.addAll(failedResourceNameList);
			failedResourceNameList.clear();
			failedResourceNameList = performActionOnResourceList(cpsm, type,context, cicsAction, tempResourceNameList,errorList)

			//Do not print wait message after last retry or failedResourceNameList size equals 0
			if((numberOfAttemptsRemaining != 1) && failedResourceNameList.size() != 0 ) {
				printStepLog(MessageFormat.format(CICSUCDMessage.retrySecondLater, retryInterval))
				Thread.sleep(retryInterval* 1000)
			}
			numberOfAttemptsRemaining--
		}
		return failedResourceNameList
	}

}
