/*<copyright                                                          */
/* notice="cics-rm-source-program"                                    */
/* pids="CA0U"                                                        */
/* years="2014,2015"                                                  */
/* crc="1921302770" >                                                 */
/* 	Licensed Materials - Property of IBM                              */
/* 	"Restricted Materials of IBM"                                     */
/* 	CA0U                                                              */
/* 	(C) Copyright IBM Corp. 2014, 2015                                */
/* 	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
/* </copyright>                                                       */
package com.ibm.cics.ucd

import org.eclipse.core.runtime.IStatus
import org.eclipse.core.runtime.MultiStatus

import com.ibm.cics.core.model.CICSSystemManagerException
import com.ibm.cics.core.model.Context
import com.ibm.cics.core.model.FilteredContext
import com.ibm.cics.core.model.ICPSM
import com.ibm.cics.core.model.ScopedContext
import com.ibm.cics.core.model.context.CPSMDefinitionPrimaryKey
import com.ibm.cics.core.model.internal.CICSResource
import com.ibm.cics.core.model.CICSObjectPrimaryKey
import com.ibm.cics.core.ui.ExceptionMessageHelper
import com.ibm.cics.model.ICICSAttribute
import com.ibm.cics.model.ICICSDefinition
import com.ibm.cics.model.ICICSObject
import com.ibm.cics.model.ICICSType
import com.ibm.cics.model.IDefinition
import com.ibm.cics.sm.comm.ICICSAction
import com.ibm.cics.sm.comm.IContext
import com.ibm.cics.sm.comm.IFilteredContext
import com.ibm.cics.sm.comm.IPrimaryKey
import com.ibm.cics.sm.comm.IResourceErrorCode
import com.ibm.cics.sm.comm.ISystemManagerResponseValues
import com.ibm.cics.sm.comm.ISystemManagerReasonValues
import com.ibm.cics.sm.comm.IScopedContext
import com.ibm.cics.sm.comm.InstallException
import com.ibm.cics.sm.comm.SMConnectionRecord
import com.ibm.cics.sm.comm.SMConnectionResponse
import com.ibm.cics.sm.comm.SystemManagerActions
import com.ibm.cics.sm.comm.SystemManagerConnectionException
import com.ibm.cics.ucd.exceptions.StepFailedException
import com.ibm.cics.ucd.exceptions.CICSUCDPluginException
import com.ibm.cics.ucd.msg.CICSUCDMessage
import com.ibm.cics.ucd.steplabel.CICSUCDStepLabel
import com.ibm.cics.ucd.ExceptionHandler;

import static com.ibm.cics.ucd.StepLogHelper.printStepLog
import static com.ibm.cics.model.AttributeValue.av;

import com.ibm.cics.core.model.AbstractCICSDefinitionType;

import java.text.MessageFormat

class CPSMHelper {

	// <copyright 
	// notice="cics-rm-source-program" 
	// pids="CA0U" 
	// years="2014,2015" 
	// crc="1921302770" > 
	// 	Licensed Materials - Property of IBM 
	// 	"Restricted Materials of IBM" 
	// 	CA0U 
	// 	(C) Copyright IBM Corp. 2014, 2015 
	// 	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
	// </copyright> 

	def exceptionHandler = new ExceptionHandler();
	//Return a boolean indicating if the given resource type is caseSensitive
	def isNameCaseSensitive(String resourceType){
		def caseSensitiveType = ['BUNDDEF','EJCODEF','DB2EDEF','DB2TDEF','EJDJDEF','DOCDEF','ENQMDEF','JVMSVDEF','PROCDEF','PROFDEF',
			'RQMDEF','TDQDEF','TERMDEF','TRANDEF','URIMPDEF','WEBSVDEF',
			'BUNDLE', 'DB2ENTRY', 'DB2TRN', 'DOCTEMP', 'JVMSERV', 'PROCTYP', 'EXTRATDQ',
			'INDTDQ', 'INTRATDQ', 'REMTDQ', 'TERMNL', 'LOCTRAN', 'URIMAP', 'WEBSERV',
			'EPADAPT','EPADSET','EVNTBIND']
		return caseSensitiveType.contains(resourceType)
	}

	//Use by install all CICS and CPSM resource, resource group etc.
	def installAction(ICPSM cpsm, IDefinition cicsDefinition, IScopedContext target, ICICSType type, String resourceName ) throws CICSSystemManagerException{

		cpsm.install(cicsDefinition, target)
		printStepLog(MessageFormat.format(CICSUCDMessage.actionSucceedWithObjectNameAndType,
				'Install', type.getResourceTableName(), resourceName))
		return true
	}

	//For step 'Install Resource form CSD'
	def installCSDResource(ICPSM cpsm,  ICICSType type, IContext context, String resourceName, String csdGroup) throws CICSSystemManagerException{

		boolean success = false
		ICICSDefinition definition = null
		def primaryKey = createPrimaryKeyForCsdResource(context, resourceName, csdGroup)
		definition = (ICICSDefinition) cpsm.get(type, primaryKey)
		success = installAction(cpsm, definition, context, type, resourceName)
		return success
	}

	//For step  'Install Resource form Data Repository'
	def installDREPResource(ICPSM cpsm,  ICICSType type, IScopedContext context, String resourceName, long version) throws CICSSystemManagerException{

		boolean success = false
		ICICSDefinition definition = null

		//For CPSM DREP install, the context for getting definition and target scope are not the same.
		//Getting CICS definition will only require a context with 'context' and scope null.
		//New a context from given FilteredContext
		IContext contextForDrepResource = new Context(context.getContext())
		def primaryKey = createPrimaryKeyForDrepResource(contextForDrepResource, resourceName, version)
		definition = (ICICSDefinition) cpsm.get(type, primaryKey)
		success = installAction(cpsm, definition ,new ScopedContext(context), type, resourceName)
		return success
	}

	//For step 'Install group or list from CSD'
	def installCSDGroupOrList(ICPSM cpsm,  ICICSType type, IScopedContext context, String groupOrListName) throws CICSSystemManagerException{

		boolean success = false
		IDefinition definition = null
		def primaryKey = createPrimaryKeyForCsdGroupAndList(context, groupOrListName)
		definition = (IDefinition) cpsm.get(type, primaryKey)
		success = installAction(cpsm, definition ,new ScopedContext(context), type, groupOrListName)
		return success
	}

	//For step 'Install resource group from CPSM DREP'
	def installDREPResourceGroup(ICPSM cpsm,  ICICSType type, IScopedContext context, String resourceGroupName) throws CICSSystemManagerException{

		boolean success = false
		IDefinition definition = null
		//For CPSM DREP install, the context for getting definition and target scope are not the same.
		//Getting CICS definition will only require a context with 'context' and scope null.
		//New a context from given FilteredContext
		IContext contextForDrepResource = new Context(context.getContext())
		def primaryKey = createPrimaryKeyForCPSMResource(type, contextForDrepResource, resourceGroupName)
		definition = (IDefinition) cpsm.get(type, primaryKey)
		success = installAction(cpsm, definition ,new ScopedContext(context), type, resourceGroupName)
		return success
	}

	//For step 'Install resource description from CPSM DREP'
	def installResDescription(ICPSM cpsm, ICICSType type, IContext context, ICICSAction cicsAction, String resourceDescName) throws CICSSystemManagerException{
		boolean success = false
		def performActionHelper = new PerformActionHelper();
		IContext contextForDrepResource = new Context(context.getContext())
		def primaryKey = createPrimaryKeyForCPSMResource(type, contextForDrepResource, resourceDescName)
		success = performActionHelper.performAction(cpsm, type, primaryKey, cicsAction, resourceDescName)
		return success
	}

	//For step 'Discard resources'
	def discard(ICPSM cpsm, ICICSType type, IContext context, String resourceName) {
		boolean success = false
		IPrimaryKey primaryKey = createPrimaryKeyForResource(context, type, resourceName)
		success = discardResource(cpsm, type, primaryKey, resourceName)
		return success;
	}

	//Used by discard function
	def discardResource(ICPSM cpsm, ICICSType type, IPrimaryKey primaryKey, String resourceName) throws CICSSystemManagerException{
		cpsm.discard(type, primaryKey)
		printStepLog(MessageFormat.format(CICSUCDMessage.actionSucceedWithObjectNameAndType,
				SystemManagerActions.Discard.actionName, type.resourceTableName, resourceName))
		return true
	}

	//PrimaryKey created with resource definition version, for DREP resource use
	def createPrimaryKeyForDrepResource(IContext context, String name, Long version){
		def key = new CICSObjectPrimaryKey(
				context,
				av(AbstractCICSDefinitionType.NAME, name),
				av(AbstractCICSDefinitionType.VERSION, version),
				av(AbstractCICSDefinitionType.CSDGROUP, ""))
		return key
	}

	//PrimaryKey created with CSD group, for CSD resource use
	def createPrimaryKeyForCsdResource(IContext context, String name, String csdGroup){
		def key = new CICSObjectPrimaryKey(context,
				av(AbstractCICSDefinitionType.NAME, name),
				av(AbstractCICSDefinitionType.VERSION, 0L),
				av(AbstractCICSDefinitionType.CSDGROUP, csdGroup))
		return key
	}

	//PrimaryKey created with CSD group/List, for group/list install
	def createPrimaryKeyForCsdGroupAndList(IContext context, String name){
		def key = new CICSObjectPrimaryKey(context,
				av(AbstractCICSDefinitionType.NAME, name))
		return key
	}

	//PrimaryKey created for CPSM resource type ( resource group , resource description)
	def createPrimaryKeyForCPSMResource(ICICSType type, IContext context, String name){
		def key = new CPSMDefinitionPrimaryKey(type, context, name)
		return key
	}

	//PrimaryKey created with resource name
	def createPrimaryKeyForResource(IContext context, ICICSType type, String name){
		String nameAttribute = type.getNameAttribute()
		ICICSAttribute<?> attribute = type.findAttributeByCicsName(nameAttribute)
		def key = new CICSObjectPrimaryKey(context, av(attribute, name))
		return key
	}

	}
