/*<copyright                                                          */
/* notice="cics-rm-source-program"                                    */
/* pids="CA0U"                                                        */
/* years="2014,2015"                                                  */
/* crc="1921302770" >                                                 */
/* 	Licensed Materials - Property of IBM                              */
/* 	"Restricted Materials of IBM"                                     */
/* 	CA0U                                                              */
/* 	(C) Copyright IBM Corp. 2014, 2015                                */
/* 	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
/* </copyright>                                                       */
package com.ibm.cics.ucd

import org.eclipse.core.runtime.IStatus
import org.eclipse.core.runtime.MultiStatus

import com.ibm.cics.core.model.CICSSystemManagerException
import com.ibm.cics.core.model.Context
import com.ibm.cics.core.model.FilteredContext
import com.ibm.cics.core.model.ICPSM
import com.ibm.cics.core.model.ScopedContext
import com.ibm.cics.core.model.context.CPSMDefinitionPrimaryKey
import com.ibm.cics.core.model.internal.CICSResource
import com.ibm.cics.core.model.CICSObjectPrimaryKey
import com.ibm.cics.core.ui.ExceptionMessageHelper
import com.ibm.cics.model.ICICSAttribute
import com.ibm.cics.model.ICICSDefinition
import com.ibm.cics.model.ICICSObject
import com.ibm.cics.model.ICICSType
import com.ibm.cics.model.IDefinition
import com.ibm.cics.sm.comm.ICICSAction
import com.ibm.cics.sm.comm.IContext
import com.ibm.cics.sm.comm.IFilteredContext
import com.ibm.cics.sm.comm.IPrimaryKey
import com.ibm.cics.sm.comm.IResourceErrorCode
import com.ibm.cics.sm.comm.ISystemManagerResponseValues
import com.ibm.cics.sm.comm.ISystemManagerReasonValues
import com.ibm.cics.sm.comm.IScopedContext
import com.ibm.cics.sm.comm.InstallException
import com.ibm.cics.sm.comm.SMConnectionRecord
import com.ibm.cics.sm.comm.SMConnectionResponse
import com.ibm.cics.sm.comm.SystemManagerActions
import com.ibm.cics.sm.comm.SystemManagerConnectionException
import com.ibm.cics.ucd.exceptions.StepFailedException
import com.ibm.cics.ucd.exceptions.CICSUCDPluginException
import com.ibm.cics.ucd.msg.CICSUCDMessage
import com.ibm.cics.ucd.steplabel.CICSUCDStepLabel

import static com.ibm.cics.ucd.StepLogHelper.printStepLog
import static com.ibm.cics.model.AttributeValue.av;

import com.ibm.cics.core.model.AbstractCICSDefinitionType;

import java.text.MessageFormat

class ExceptionHandler {
	// <copyright
	// notice="cics-rm-source-program"
	// pids="CA0U"
	// years="2014,2015"
	// crc="1921302770" >
	// 	Licensed Materials - Property of IBM
	// 	"Restricted Materials of IBM"
	// 	CA0U
	// 	(C) Copyright IBM Corp. 2014, 2015
	// 	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
	// </copyright>
	
	//Method to handle all Exception
	def boolean handleException(CICSSystemManagerException e, String resourceType, ICICSAction action, String resourceName, List errorList) throws Exception{
		Map<String,Object> map = new HashMap<String,Object>();
		map.put("action", action.actionName);
		map.put("resourceName",resourceName);
		map.put("resourceType",resourceType);
		map.put("responseName","");
		map.put("reasonName","");
		map.put("attribute","");
		map.put("errorCode","");
		map.put("resp1Name","");
		map.put("resp2","");
		
		if(e.getMessage() == '0') {
			//CICS Explorer returns an Exception with the text '0' to indicate zero records were returned
			printStepLog(MessageFormat.format(CICSUCDMessage.actionFailWithObjectNameAndType, action.actionName, resourceType, resourceName))
			printStepLog(MessageFormat.format(CICSUCDMessage.canNotFindResourceDefinition, resourceType, resourceName))
		} else if (e.getCause() instanceof SystemManagerConnectionException) {
			SystemManagerConnectionException ex = (SystemManagerConnectionException) e.getCause();
			int responseCode = ex.getResponseCode();
			IResourceErrorCode errorCode = ex.getFeedbackErrorCode();
			int resp1 = ex.getResp1();
			String function = ex.getFunction();

			if (resp1 != 0){
				//Get the message when INSTALL action itself get failed, format the message. This fail should not stop STEP from executing
				//CNX0591E EXEC CICS command command RESP resp RESP2 resp2.
				printStepLog(MessageFormat.format(CICSUCDMessage.actionFailWithObjectNameAndType, action.actionName, resourceType, resourceName))
				printStepLog(MessageFormat.format(CICSUCDMessage.commandFailDetailMsg, ex.getFunction(), ex.getResp1Name(), ex.getResp2()))
				map.put("resp1Name", ex.getResp1Name())
				map.put("resp2", ex.getResp2().toString())
				errorList.add(map.sort());

			} else if (errorCode != null && errorCode.getErrorCode() != 0) {
				//CNX0592E Attribute Name (attribute_name) Error (error)
				printStepLog(MessageFormat.format(CICSUCDMessage.actionFailWithObjectNameAndType, action.actionName, resourceType, resourceName))
				printStepLog(MessageFormat.format(CICSUCDMessage.cpsmCommandFailMsg, ex.getAttribute(), errorCode.getLabel()))
				map.put("attribute", ex.getAttribute())
				map.put("errorCode", errorCode.getLabel())
				errorList.add(map.sort());

			} else if (ex.getResponse() != ISystemManagerResponseValues.OK) {
				//CNX0593E RESPONSE (response) REASON (reason)
				if (ex.getResponse() == ISystemManagerResponseValues.INVALIDPARM && ex.getReason() == ISystemManagerReasonValues.SCOPE) {
					//'INVALIDPARM, SCOPE' reported in exception when the context and scope are not correct
					//Throw the new exception as we need to stop STEP from execution in this situation
					throw new CICSUCDPluginException(MessageFormat.format(CICSUCDMessage.checkContextAndScope,
							CICSUCDStepLabel.CICS_SCOPE, CICSUCDStepLabel.CICSPLEX, CICSUCDStepLabel.CICS_SCOPE))

				}
				printStepLog(MessageFormat.format(CICSUCDMessage.actionFailWithObjectNameAndType, action.actionName, resourceType, resourceName))
				if(ex.getReason() == 0) {
					printStepLog(MessageFormat.format(CICSUCDMessage.actionFailMsgNoReason, ex.getResponseName()))
					map.put("responseName", ex.getResponseName())
					errorList.add(map.sort());
				} else {
					printStepLog(MessageFormat.format(CICSUCDMessage.actionFailMsg, ex.getResponseName(), ex.getReasonName()))
					map.put("responseName", ex.getResponseName())
					map.put("reasonName", ex.getReasonName())
					map.sort();
					errorList.add(map.sort());
				}
			} else {
				//Other unexpected CICSSystemManagerException caught
				printStepLog(MessageFormat.format(CICSUCDMessage.unexpectedException))
				throw ex
			}
		} else {
			//Other unexpected non-CICSSystemManagerException caught
			printStepLog(MessageFormat.format(CICSUCDMessage.unexpectedException))
			throw e
		}
	}


}
