/*<copyright                                                          */
/* notice="cics-rm-source-program"                                    */
/* pids="CA0U"                                                        */
/* years="2014,2015"                                                  */
/* crc="1383724860" >                                                 */
/* 	Licensed Materials - Property of IBM                              */
/* 	"Restricted Materials of IBM"                                     */
/* 	CA0U                                                              */
/* 	(C) Copyright IBM Corp. 2014, 2015                                */
/* 	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
/* </copyright>                                                       */
package com.ibm.cics.ucd.steps

import java.text.MessageFormat
import java.util.List;
import java.util.Properties;

import com.ibm.cics.core.model.CICSSystemManagerException
import com.ibm.cics.core.model.GenTypeClasses
import com.ibm.cics.core.model.ICPSM
import com.ibm.cics.model.ICICSObject
import com.ibm.cics.model.ICICSType
import com.ibm.cics.sm.comm.IContext
import com.ibm.cics.sm.comm.SystemManagerActions
import com.ibm.cics.ucd.CPSMHelper
import com.ibm.cics.ucd.ExceptionHandler
import com.ibm.cics.ucd.exceptions.StepFailedException
import com.ibm.cics.ucd.msg.CICSUCDMessage
import com.ibm.cics.ucd.properties.ResourceNameListProperty
import com.ibm.cics.ucd.steplabel.CICSUCDStepLabel
import com.urbancode.air.AirPluginTool

abstract class AbstractInstallResourceDescOrGroupFromDREPStep extends CICSStep {
	// <copyright 
	// notice="cics-rm-source-program" 
	// pids="CA0U" 
	// years="2014,2015" 
	// crc="1813425462" > 
	// 	Licensed Materials - Property of IBM 
	// 	"Restricted Materials of IBM" 
	// 	CA0U 
	// 	(C) Copyright IBM Corp. 2014, 2015 
	// 	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
	// </copyright> 

	abstract String resourceType;
	abstract String propertyName;
	
	AbstractInstallResourceDescOrGroupFromDREPStep(String inputPropertyFile, String outputPropertyFile) {
 		super(inputPropertyFile, outputPropertyFile)
	}

	AbstractInstallResourceDescOrGroupFromDREPStep(AirPluginTool apTool) {
 		super(apTool)
	}

	/**
	 * Primarily to support unit testing
	 * @param cpsm
	 */
 	AbstractInstallResourceDescOrGroupFromDREPStep(String inputPropertyFile, String outputPropertyFile, ICPSM cpsm) {
		super(inputPropertyFile, outputPropertyFile)
		this.cpsm = cpsm
	}

	AbstractInstallResourceDescOrGroupFromDREPStep(AirPluginTool apTool, ICPSM cpsm) {
		super(apTool)
		this.cpsm = cpsm
	}
	 
	@Override
	protected void runCICSStep(ICPSM cpsm, IContext context) {

		def cpsmHelper = new CPSMHelper()
		def exceptionHandler = new ExceptionHandler();
		def props = apTool.getStepProperties()
  		def resourceNameList = getResourceNameList(cpsmHelper, props, resourceType)
		//Get the resource type for resource group
		Class<? extends ICICSType<ICICSObject>> typeClass = GenTypeClasses.getCICSTypeClassForResourceTableName(resourceType)
		ICICSType<?> type = typeClass.invokeMethod("getInstance", null)

		//For step execution status use
		boolean stepFail = false
		int successCount = 0
		int failCount = 0

		log(MessageFormat.format(CICSUCDMessage.installfromDREP))

		//Iterate to install each resource
		for(int i=0; i < resourceNameList.size(); i++) {
			
			try {
				//Invoke specific method to install the resource
				boolean installSuccess = performInstall(cpsmHelper, cpsm, type, context, resourceNameList.get(i))
				if(installSuccess)
					successCount++
				
			} catch (CICSSystemManagerException e) {
				failCount++
				stepFail = true
				//Any exception thrown in the install process handled here
				exceptionHandler.handleException(e, resourceType, SystemManagerActions.Install, resourceNameList.get(i),errorList)
			}
		}

		log(MessageFormat.format(CICSUCDMessage.resultSummary, 'INSTALL', Integer.toString(successCount), Integer.toString(failCount)))//TODO

		if (stepFail) {
			throw new StepFailedException("Step failed.");
		}
	}
	
	@Override
	protected boolean supportedOnNonCICSplex() {
		return false
	}
	
	protected abstract boolean performInstall(CPSMHelper cpsmHelper, ICPSM cpsm, ICICSType<? extends ICICSObject> type, IContext context, String itemToInstall); 
	
	protected List<String> getResourceNameList(CPSMHelper cpsmHelper, Properties props, String resourceType) {
		return new ResourceNameListProperty(CICSUCDStepLabel.RESOURCE_NAME_LIST, resourceType, cpsmHelper.isNameCaseSensitive(resourceType), true).parse(props[propertyName]).getValue()
		
	}
}
