/*<copyright                                                          */
/* notice="cics-rm-source-program"                                    */
/* pids="CA0U"                                                        */
/* years="2014,2015"                                                  */
/* crc="2794054962" >                                                 */
/* 	Licensed Materials - Property of IBM                              */
/* 	"Restricted Materials of IBM"                                     */
/* 	CA0U                                                              */
/* 	(C) Copyright IBM Corp. 2014, 2015                                */
/* 	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
/* </copyright>                                                       */
package com.ibm.cics.ucd.steps

import com.ibm.cics.core.model.CICSSystemManagerException
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.CICSCore;
import com.ibm.cics.core.model.FilteredContext
import com.ibm.cics.core.model.GenTypeClasses
import com.ibm.cics.sm.comm.SystemManagerActions
import com.ibm.cics.model.ICICSObject
import com.ibm.cics.model.ICICSType
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.ucd.CPSMHelper
import com.ibm.cics.ucd.exceptions.StepFailedException
import com.ibm.cics.ucd.properties.ResourceNameListProperty
import com.ibm.cics.ucd.steplabel.CICSUCDStepLabel
import com.ibm.cics.ucd.msg.CICSUCDMessage
import com.urbancode.air.AirPluginTool;

import java.text.MessageFormat

class InstallResourceDescFromDREPStep extends AbstractInstallResourceDescOrGroupFromDREPStep {
	// <copyright 
	// notice="cics-rm-source-program" 
	// pids="CA0U" 
	// years="2014,2015" 
	// crc="1212001092" > 
	// 	Licensed Materials - Property of IBM 
	// 	"Restricted Materials of IBM" 
	// 	CA0U 
	// 	(C) Copyright IBM Corp. 2014, 2015 
	// 	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
	// </copyright> 
	
	public InstallResourceDescFromDREPStep(String inputPropertyFile, String outputPropertyFile) {
		this(inputPropertyFile, outputPropertyFile, CICSCore.getCPSM())
	}

	public InstallResourceDescFromDREPStep(AirPluginTool apTool) {
		this(apTool, CICSCore.getCPSM())
	}

	/**
	 * Primarily to support unit testing
	 * @param cpsm
	 */
	InstallResourceDescFromDREPStep(String inputPropertyFile, String outputPropertyFile, ICPSM cpsm) {
		super(inputPropertyFile, outputPropertyFile)
		this.cpsm = cpsm
		this.resourceType = "RESDESC";
		this.propertyName = "resourceDescriptionNameList";
	}

	InstallResourceDescFromDREPStep(AirPluginTool apTool, ICPSM cpsm) {
		super(apTool)
		this.cpsm = cpsm
		this.resourceType = "RESDESC";
		this.propertyName = "resourceDescriptionNameList";
	}


	@Override
	protected boolean performInstall(CPSMHelper cpsmHelper, ICPSM cpsm, ICICSType<? extends ICICSObject> type, IContext context, String itemToInstall) {
		return cpsmHelper.installResDescription(cpsm, type, context, SystemManagerActions.Install, itemToInstall)
	}
	
}
