/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.core.connections.ConnectionWidgetManager;
import com.ibm.cics.core.connections.internal.ConnectionStatus;
import com.ibm.cics.core.connections.internal.ConnectionTrimWidgetCategorySource;
import com.ibm.cics.core.connections.internal.InternalConnectionsPlugin;
import java.util.Map;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.ISourceProviderListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;
import org.eclipse.ui.services.ISourceProviderService;

public class ConnectionTrimWidget
extends WorkbenchWindowControlContribution {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2013, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ConnectionWidgetManager connectionWidgetManager;
    private boolean disposed = false;
    private final ISourceProviderListener listener = new ISourceProviderListener(){

        public void sourceChanged(int sourcePriority, String sourceName, Object sourceValue) {
            if (!ConnectionTrimWidget.this.disposed && "com.ibm.cics.core.connections.trimConnectionCategory".equals(sourceName)) {
                ConnectionTrimWidget.this.connectionWidgetManager.setCurrentCategory((String)sourceValue);
            }
        }

        public void sourceChanged(int sourcePriority, Map sourceValuesByName) {
            this.sourceChanged(sourcePriority, "com.ibm.cics.core.connections.trimConnectionCategory", sourceValuesByName.get("com.ibm.cics.core.connections.trimConnectionCategory"));
        }
    };

    public ConnectionTrimWidget() {
    }

    public ConnectionTrimWidget(String id) {
        super(id);
    }

    protected Control createControl(Composite parent) {
        this.connectionWidgetManager = InternalConnectionsPlugin.getDefault().getActiveConnectionCategoryService();
        ConnectionStatus connectionStatus = new ConnectionStatus(parent, 0, this.connectionWidgetManager.getConnectionStatusController());
        this.connectionWidgetManager.setConnectionStateViewer(connectionStatus);
        this.connectionWidgetManager.setCurrentCategory(ConnectionTrimWidgetCategorySource.getActiveConnectionCategory());
        ISourceProvider sourceProvider = this.getSourceProvider();
        sourceProvider.addSourceProviderListener(this.listener);
        return connectionStatus;
    }

    public void dispose() {
        ISourceProvider sourceProvider = this.getSourceProvider();
        if (sourceProvider != null) {
            this.disposed = true;
            sourceProvider.removeSourceProviderListener(this.listener);
        }
        super.dispose();
    }

    private ISourceProvider getSourceProvider() {
        ISourceProviderService sourceProviderService = (ISourceProviderService)PlatformUI.getWorkbench().getService(ISourceProviderService.class);
        ISourceProvider sourceProvider = null;
        if (sourceProviderService != null) {
            sourceProvider = sourceProviderService.getSourceProvider("com.ibm.cics.core.connections.trimConnectionCategory");
        }
        return sourceProvider;
    }
}

