/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal.views;

import com.ibm.cics.core.comm.CredentialsConfiguration;
import com.ibm.cics.core.comm.IConnectionCategory;
import com.ibm.cics.core.comm.IConnectionDescriptor;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.ConnectionsImages;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.IConnectionManager;
import com.ibm.cics.core.connections.IConnectionState;
import com.ibm.cics.core.connections.internal.DefaultConnectionService;
import com.ibm.cics.core.connections.internal.views.ConnectionsContentProvider;
import com.ibm.cics.core.connections.internal.views.Messages;
import com.ibm.cics.eclipse.common.ui.QueryCompositeImageDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ConnectionsLabelDecorator
extends ObservableMapLabelProvider
implements ILabelDecorator {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IObservableMap activeCategoryConnection;
    private ImageRegistry imageRegistry = new ImageRegistry();
    private DefaultConnectionService defaultConnectionService;
    private DefaultConnectionService.DefaultConnectionServiceListener listener = new DefaultConnectionService.DefaultConnectionServiceListener(){

        public void event(DefaultConnectionService.DefaultConnectionChangedEvent event) {
            ConnectionProfile newProfile = event.getNewProfile();
            ConnectionProfile oldProfile = event.getOldProfile();
            final ArrayList<ConnectionProfile> changedProfiles = new ArrayList<ConnectionProfile>();
            if (newProfile != null) {
                changedProfiles.add(newProfile);
            }
            if (oldProfile != null) {
                changedProfiles.add(oldProfile);
            }
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    ConnectionsLabelDecorator.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)ConnectionsLabelDecorator.this, changedProfiles.toArray()));
                }
            });
        }
    };

    public ConnectionsLabelDecorator(IObservableMap activeCategoryConnection, DefaultConnectionService defaultConnectionService) {
        super(new IObservableMap[]{activeCategoryConnection});
        this.activeCategoryConnection = activeCategoryConnection;
        this.defaultConnectionService = defaultConnectionService;
        defaultConnectionService.addDefaultConnectionServiceListener(this.listener);
    }

    public void dispose() {
        super.dispose();
        this.listener.makeStale();
        this.imageRegistry.dispose();
    }

    public String decorateText(String text, Object element) {
        if (element instanceof ConnectionProfile) {
            ConnectionProfile configuration = (ConnectionProfile)element;
            StringBuffer buffer = new StringBuffer();
            buffer.append(text);
            CredentialsConfiguration credentials = configuration.getCredentials();
            if (credentials != null) {
                buffer.append(" [");
                if (credentials != null) {
                    buffer.append(credentials.getName());
                }
                buffer.append("]");
            }
            if (this.defaultConnectionService.isDefault(configuration)) {
                buffer.append(" (");
                buffer.append(Messages.ConnectionsLabelDecorator_Default);
                buffer.append(")");
            }
            return buffer.toString();
        }
        if (element instanceof IConnectionCategory) {
            ConnectionProfile connectionProfile;
            StringBuffer buffer = new StringBuffer();
            buffer.append(text);
            int totalNumberOfConnections = 0;
            IConnectionCategory category = (IConnectionCategory)element;
            IConnectionDescriptor[] iConnectionDescriptorArray = category.getConnections();
            int n = iConnectionDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConnectionDescriptor aConnectionDescriptor = iConnectionDescriptorArray[n2];
                totalNumberOfConnections += this.getNumberOfConnections(aConnectionDescriptor);
                ++n2;
            }
            this.appendTotal(buffer, totalNumberOfConnections);
            IConnectionState state = (IConnectionState)this.activeCategoryConnection.get((Object)category);
            if (state != null && (connectionProfile = state.getConnectionProfile()) != null) {
                buffer.append(" (" + connectionProfile.getName() + ")");
            }
            return buffer.toString();
        }
        if (element instanceof IConnectionDescriptor) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(text);
            int numberOfConnectionsForDescriptor = this.getNumberOfConnections((IConnectionDescriptor)element);
            this.appendTotal(buffer, numberOfConnectionsForDescriptor);
            return buffer.toString();
        }
        if (element instanceof ConnectionsContentProvider.ConnectionProviderDescriptorNode) {
            ConnectionsContentProvider.ConnectionProviderDescriptorNode node = (ConnectionsContentProvider.ConnectionProviderDescriptorNode)element;
            StringBuffer buffer = new StringBuffer();
            buffer.append(text);
            this.appendTotal(buffer, node.getConnectionProfiles().size());
            return buffer.toString();
        }
        return text;
    }

    private void appendTotal(StringBuffer buffer, int numberOfConnections) {
        if (numberOfConnections > 0) {
            buffer.append(" (");
            buffer.append(String.valueOf(numberOfConnections));
            buffer.append(")");
        }
    }

    private int getNumberOfConnections(IConnectionDescriptor aConnectionDescriptor) {
        IConnectionManager connectionManager = ConnectionsPlugin.getDefault().getConnectionService().getConnectionManager();
        Map<IConnectionDescriptor, List<ConnectionProfile>> configurationsByDescriptor = connectionManager.getConnectionProfilesByDescriptor();
        List<ConnectionProfile> list = configurationsByDescriptor.get(aConnectionDescriptor);
        return list != null ? list.size() : 0;
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public Image decorateImage(Image image, Object element) {
        if (element instanceof IConnectionCategory) {
            IConnectionState connState = (IConnectionState)this.activeCategoryConnection.get(element);
            Image connectImage = connState != null ? connState.getOverlayImage() : ConnectionsImages.getImage("DISCONNECTED_OVERLAY");
            QueryCompositeImageDescriptor queryCompositeImageDescriptor = new QueryCompositeImageDescriptor(image, connectImage, 3);
            Image newImage = queryCompositeImageDescriptor.createImage();
            String id = ((IConnectionCategory)element).getId();
            this.imageRegistry.remove(id);
            this.imageRegistry.put(id, newImage);
            return newImage;
        }
        return null;
    }
}

