/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.comm;

import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.cics.core.comm.IConnection;

public abstract class AbstractConnection
implements IConnection {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static ConnectionConfiguration nullConfiguration = new ConnectionConfiguration(null, null, 0, null, null);
    private ConnectionConfiguration configuration = nullConfiguration;

    @Override
    public void setConfiguration(ConnectionConfiguration connectionConfiguration) {
        this.configuration = connectionConfiguration != null ? connectionConfiguration : nullConfiguration;
    }

    @Override
    public ConnectionConfiguration getConfiguration() {
        return this.configuration == nullConfiguration ? nullConfiguration : new ConnectionConfiguration(this.configuration);
    }

    @Override
    public String getName() {
        return this.configuration.getName();
    }

    public String toString() {
        String host = this.getHost();
        return String.valueOf(this.getClass().getName()) + "@" + Integer.toHexString(this.hashCode()) + "[" + (host != null ? String.valueOf(this.getUserID()) + "@" + this.getHost() + ":" + this.getPort() : "") + "]";
    }

    @Override
    @Deprecated
    public boolean isSecure() {
        return this.configuration.getSecureHint();
    }

    @Override
    @Deprecated
    public String getHost() {
        return this.configuration.getHost();
    }

    @Override
    @Deprecated
    public int getPort() {
        return this.configuration.getPort();
    }

    @Override
    @Deprecated
    public String getUserID() {
        return this.configuration.getUserID();
    }

    @Deprecated
    protected String getPassword() {
        return this.configuration.getPassword();
    }

    protected boolean hasNullConfiguration() {
        return this.getConfiguration() == nullConfiguration;
    }
}

