/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.ISystemManagerConnection;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import com.ibm.cics.sm.comm.SMConnectionResponse;
import java.util.HashSet;
import java.util.Set;

public class CMCIConnectionFinder {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String EYUCMCIT = "EYUCMCIT";
    private static final String PLEXNAME = "PLEXNAME";
    private static final String PORT = "PORT";
    private static final String NAME = "NAME";
    private static final String EYUWUI = "EYUWUI";
    private static final String EYU_CICSNAME = "EYU_CICSNAME";
    public static final int UNKNOWN = -1;
    public static final int UNDETERMINED = -2;
    private ISystemManagerConnection connection;
    private Set<String> cicsplexes;
    private SMConnectionResponse tcpipServices;
    private String wuiName;
    private static final Debug DEBUG = new Debug(CMCIConnectionFinder.class);

    public CMCIConnectionFinder(ISystemManagerConnection connection) {
        this.connection = connection;
    }

    public int getCMCIPort() {
        try {
            this.connection.connect();
            this.getCICSplexes();
            this.findWUIServerInUse();
            if (this.wuiName != null) {
                int cmciPort = this.findCMCIPort();
                if (cmciPort != this.connection.getConfiguration().getPort()) {
                    int n = cmciPort;
                    return n;
                }
                return -2;
            }
            DEBUG.event("getCMCIPort", "Didn't find a WUI Server");
            return -1;
        }
        catch (ConnectionException ex) {
            DEBUG.warning("getCMCIPort", "Couldn't find a CMCI port as a ConnectionException was thrown trying to use a CPSMConnection to work it out", (Throwable)ex);
            return -1;
        }
        finally {
            if (this.connection.isConnected()) {
                try {
                    this.connection.disconnect();
                }
                catch (ConnectionException ex) {
                    DEBUG.warning("getCMCIPort", "An exception was thrown when attempting to disconnect from the CPSMConnection", (Throwable)ex);
                }
            }
        }
    }

    private int findCMCIPort() {
        int i = 0;
        while (i < this.tcpipServices.getRecordCount()) {
            SMConnectionRecord tcpipServiceRecord = this.tcpipServices.getRecord(i);
            if (this.isCMCI(tcpipServiceRecord) && this.isTargetWUI(tcpipServiceRecord)) {
                try {
                    int intValue = Integer.parseInt(tcpipServiceRecord.get(PORT));
                    DEBUG.event("findCMCIPort", "Found port: " + intValue);
                    return intValue;
                }
                catch (NumberFormatException ex) {
                    DEBUG.warning("findCMCIPort", "Couldn't parse port", (Throwable)ex);
                    return -2;
                }
            }
            ++i;
        }
        return -2;
    }

    private boolean isTargetWUI(SMConnectionRecord tcpipServiceRecord) {
        return this.wuiName.equals(tcpipServiceRecord.get(EYU_CICSNAME));
    }

    private boolean isCMCI(SMConnectionRecord tcpipServiceRecord) {
        return EYUCMCIT.equals(tcpipServiceRecord.get(NAME));
    }

    private void findWUIServerInUse() {
        for (String cicsplex : this.cicsplexes) {
            try {
                SMConnectionResponse tcpipServicesResponse = this.connection.getResources("TCPIPS", (IContext)new Context(cicsplex));
                int i = 0;
                while (i < tcpipServicesResponse.getRecordCount()) {
                    SMConnectionRecord tcpipServiceRecord = tcpipServicesResponse.getRecord(i);
                    if (this.isSMData(tcpipServiceRecord) && this.isConfigPort(tcpipServiceRecord)) {
                        this.tcpipServices = tcpipServicesResponse;
                        this.wuiName = tcpipServiceRecord.get(EYU_CICSNAME);
                        DEBUG.event("findWUIServerInUse", "Found WUI Server in use: " + this.wuiName);
                        return;
                    }
                    ++i;
                }
            }
            catch (ConnectionException ex) {
                DEBUG.warning("findWUIServerInUse", "Couldn't find any WUI Servers in CICSplex " + cicsplex + ", as an exception was thrown", (Throwable)ex);
            }
        }
    }

    private boolean isConfigPort(SMConnectionRecord tcpipServiceRecord) {
        return String.valueOf(this.connection.getConfiguration().getPort()).equals(tcpipServiceRecord.get(PORT));
    }

    private boolean isSMData(SMConnectionRecord tcpipServiceRecord) {
        return EYUWUI.equals(tcpipServiceRecord.get(NAME));
    }

    private void getCICSplexes() throws ConnectionException {
        SMConnectionResponse cicsplexResponse = this.connection.getResources("CICSPLEX", (IContext)new Context(null));
        this.cicsplexes = new HashSet<String>();
        int i = 0;
        while (i < cicsplexResponse.getRecordCount()) {
            String plexName = cicsplexResponse.getRecord(i).get(PLEXNAME);
            this.cicsplexes.add(plexName);
            DEBUG.event("getCICSplexes", "Found CICSplex: " + plexName);
            ++i;
        }
    }

    private static class Context
    implements IContext {
        private final String context;

        public Context(String context) {
            this.context = context;
        }

        public String getContext() {
            return this.context;
        }
    }
}

