/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal;

import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.IFilterVisitor;
import com.ibm.cics.sm.comm.sm.internal.SMCPSMConnection;
import java.util.Stack;

public final class SMCPSMComplexFilterVisitor
implements IFilterVisitor {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Stack<String> criteriaStack = new Stack();

    public void or() {
        String operandTwo = this.criteriaStack.pop();
        String operandOne = this.criteriaStack.pop();
        this.criteriaStack.push(String.valueOf(this.bracketed(operandOne)) + "%20OR%20" + this.bracketed(operandTwo));
    }

    public void and() {
        String operandTwo = this.criteriaStack.pop();
        String operandOne = this.criteriaStack.pop();
        this.criteriaStack.push(String.valueOf(this.bracketed(operandOne)) + "%20AND%20" + this.bracketed(operandTwo));
    }

    public void not() {
        String expression = this.criteriaStack.pop();
        this.criteriaStack.push("NOT(" + expression + ")");
    }

    public <T> void eq(ICICSAttribute<T> attribute, T value) {
        this.criteriaStack.push(this.getAttributeExpression(attribute, "=", value));
    }

    public <T> void is(ICICSAttribute<T> attribute, T value) {
        this.criteriaStack.push(this.getAttributeExpression(attribute, "==", value));
    }

    public <T> void le(ICICSAttribute<T> attribute, T value) {
        this.criteriaStack.push(this.getAttributeExpression(attribute, "<=", value));
    }

    public <T> void lt(ICICSAttribute<T> attribute, T value) {
        this.criteriaStack.push(this.getAttributeExpression(attribute, "<", value));
    }

    public <T> void ge(ICICSAttribute<T> attribute, T value) {
        this.criteriaStack.push(this.getAttributeExpression(attribute, ">=", value));
    }

    public <T> void gt(ICICSAttribute<T> attribute, T value) {
        this.criteriaStack.push(this.getAttributeExpression(attribute, ">", value));
    }

    public <T> void ne(ICICSAttribute<T> attribute, T value) {
        this.criteriaStack.push(this.getAttributeExpression(attribute, "%AC=", value));
    }

    private <T> String getAttributeExpression(ICICSAttribute<T> attribute, String operator, T value) {
        return String.valueOf(attribute.getCicsName()) + operator + '\'' + SMCPSMConnection.cmciEscape(attribute.internalToExternal(value)) + '\'';
    }

    private String bracketed(String string) {
        return String.valueOf('(') + string + ')';
    }

    public String getCriteriaString() {
        if (this.criteriaStack.size() == 0) {
            return "";
        }
        if (this.criteriaStack.size() == 1) {
            return (String)this.criteriaStack.get(0);
        }
        throw new IllegalStateException();
    }
}

