/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.comm.internal;

import com.ibm.cics.core.comm.ConnectionException;
import java.net.ConnectException;
import java.net.SocketException;
import java.security.InvalidAlgorithmParameterException;
import javax.net.ssl.SSLException;

public class ConnectionExceptionUtils {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2012, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SSLSERVER1 = "534 ";
    private static final String[] SSLSERVER = new String[]{"534 Server requires authentication before USER command", "534 Server is not willing to accept security mechanism", "Unexpected end of file from server", "Unrecognized SSL message, plaintext connection?", "Software caused connection abort: recv failed", "Remote host closed connection during handshake", "the trustAnchors parameter must be non-empty"};

    public static Exception getPossibleSSLException(ConnectionException ex) {
        if (ex.getMessage().startsWith(SSLSERVER1)) {
            return new SocketException(ex.getMessage());
        }
        Throwable rootCause = ex.getCause();
        int maxlaps = 5;
        int i = 0;
        while (i < maxlaps) {
            if (rootCause != null) {
                if (!(rootCause instanceof ConnectException) && (rootCause instanceof SocketException || rootCause instanceof SSLException || rootCause instanceof InvalidAlgorithmParameterException)) {
                    String[] stringArray = SSLSERVER;
                    int n = SSLSERVER.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String potential = stringArray[n2];
                        if (rootCause.getMessage().trim().startsWith(potential)) {
                            return (Exception)rootCause;
                        }
                        ++n2;
                    }
                }
                rootCause = rootCause.getCause();
            }
            ++i;
        }
        return null;
    }
}

