/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.actions;

import com.ibm.cics.core.model.CICSSystemManagerException;
import com.ibm.cics.core.model.CSDGroupDefinitionType;
import com.ibm.cics.core.model.CSDListDefinitionType;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.ICoreObject;
import com.ibm.cics.core.ui.ExceptionMessageHelper;
import com.ibm.cics.core.ui.Messages;
import com.ibm.cics.core.ui.actions.GetExecutionDelegate;
import com.ibm.cics.eclipse.common.ops.ExecutionFailedException;
import com.ibm.cics.eclipse.common.ops.IOperationExecutionDelegate;
import com.ibm.cics.model.CICSActionException;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.ICSDGroupDefinition;
import com.ibm.cics.model.ICSDListDefinition;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IPrimaryKey;
import org.eclipse.core.runtime.IStatus;

public class RemoveFromCSDListExecutionDelegate
implements IOperationExecutionDelegate<ICSDGroupDefinition> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IPrimaryKey csdListPrimaryKey;
    private ICSDListDefinition csdList;

    public RemoveFromCSDListExecutionDelegate(IPrimaryKey primaryKey) {
        this.csdListPrimaryKey = primaryKey;
    }

    private ICSDListDefinition getCSDList(ICPSM cpsm) throws ExecutionFailedException {
        if (this.csdList == null) {
            GetExecutionDelegate executionDelegate = new GetExecutionDelegate((ICICSType<?>)CSDListDefinitionType.getInstance(), cpsm);
            executionDelegate.execute(this.csdListPrimaryKey);
            this.csdList = (ICSDListDefinition)executionDelegate.getCICSObject();
        }
        return this.csdList;
    }

    public void execute(ICSDGroupDefinition target) throws ExecutionFailedException {
        ICPSM cpsm = ((ICoreObject)target).getCPSM();
        try {
            cpsm.remove(this.getCSDList(cpsm), target);
        }
        catch (CICSSystemManagerException ex) {
            IStatus status = ExceptionMessageHelper.getStatus((CICSActionException)((Object)ex), CSDListDefinitionType.getInstance(), 4);
            throw new ExecutionFailedException(status);
        }
    }

    public String getOperationDescription(ICSDGroupDefinition target) {
        String groupTypeName = Messages.getTableDescription(CSDGroupDefinitionType.getInstance().getResourceTableName());
        String listTypeName = Messages.getTableDescription(CSDListDefinitionType.getInstance().getResourceTableName());
        String groupName = target.getName();
        String listName = this.csdListPrimaryKey.getAttributeValue(CSDListDefinitionType.NAME.getCicsName());
        String repositoryName = ExceptionMessageHelper.getContextOrScopeNameFor((IContext)this.csdListPrimaryKey);
        return com.ibm.cics.core.ui.actions.Messages.getString("operation.removeGroupFromList.description", groupTypeName, groupName, listTypeName, listName, repositoryName);
    }

    public String getOperationName() {
        return com.ibm.cics.core.ui.actions.Messages.getString("RemoveFromCSDListExecutionDelegate.removeFromCSDList");
    }

    public int getID() {
        return 613;
    }
}

