/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.decorators;

import com.ibm.cics.core.model.CMASDetailsType;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.ICoreObject;
import com.ibm.cics.core.ui.Debug;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.ICMASDetails;
import com.ibm.cics.model.ICMASList;
import com.ibm.cics.sm.comm.ICICSOperation;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.context.ICMASContext;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;

public class CMASListLabelDecorator
implements ILightweightLabelDecorator {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(CMASListLabelDecorator.class.getPackage().getName());

    public void decorate(Object element, IDecoration decoration) {
        Debug.enter((Logger)logger, (String)CMASListLabelDecorator.class.getName(), (String)"decorate", (Object)this, (Object)element, (Object)decoration);
        if (element instanceof ICMASList) {
            ICMASList cmasList = (ICMASList)element;
            ICPSM cpsm = ((ICoreObject)cmasList).getCPSM();
            final String cmasContext = cmasList.getName();
            String applid = null;
            if (cmasList != null && cmasList.getStatus().equals((Object)ICMASList.StatusValue.ACTIVE)) {
                ICMASDetails[] cmasDetails;
                if (cpsm.checkPermission(ICICSOperation.GET, (ICICSType)CMASDetailsType.getInstance()) && (cmasDetails = (ICMASDetails[])cpsm.getDefinitions((ICICSType)CMASDetailsType.getInstance(), (IContext)new ICMASContext(){

                    public String getContext() {
                        return cmasContext;
                    }
                })).length == 1) {
                    applid = cmasDetails[0].getApplID();
                }
                String suffix = " (" + applid + ")";
                Debug.event((Logger)logger, (String)CMASListLabelDecorator.class.getName(), (String)"decorate", (Object)cmasList, (Object)suffix);
                decoration.addSuffix(suffix);
            }
        }
        Debug.exit((Logger)logger, (String)CMASListLabelDecorator.class.getName(), (String)"decorate");
    }

    public void addListener(ILabelProviderListener listener) {
        if (Debug.DEBUG_DECORATORS) {
            Debug.event((Logger)logger, (String)CMASListLabelDecorator.class.getName(), (String)"addListener", (Object)(" " + this + " listener=" + listener));
        }
    }

    public void dispose() {
        if (Debug.DEBUG_DECORATORS) {
            Debug.event((Logger)logger, (String)CMASListLabelDecorator.class.getName(), (String)"dispose");
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

