/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.internal.views;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.ui.views.LegacyTableManager;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSType;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;

public class ColumnDataManager {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(ColumnDataManager.class);
    private IPreferenceStore preferenceStore;

    public ColumnDataManager(IPreferenceStore preferenceStore) {
        this.preferenceStore = preferenceStore;
    }

    public List<LegacyTableManager.ColumnData> getSavedColumnData(ICICSType<?> elementType) {
        debug.enter("getSavedColumnData", (Object)("type=" + elementType));
        String columnNamesPrefName = String.valueOf(elementType.getResourceTableName()) + ".columnNames";
        String columnWidthsPrefName = String.valueOf(elementType.getResourceTableName()) + ".columnWidths";
        String columnNamesPrefValue = this.preferenceStore.getString(columnNamesPrefName);
        String columnWidthsPrefValue = this.preferenceStore.getString(columnWidthsPrefName);
        debug.event("getSavedColumnData", "columnNamesPref=" + columnNamesPrefName + ", value=" + columnNamesPrefValue);
        debug.event("getSavedColumnData", "columnWidthsPref=" + columnWidthsPrefName + ", value=" + columnWidthsPrefValue);
        if (columnNamesPrefValue.equals("")) {
            return new ArrayList<LegacyTableManager.ColumnData>();
        }
        List<LegacyTableManager.ColumnData> columns = this.getColumns(elementType, columnNamesPrefValue, columnWidthsPrefValue);
        debug.exit("getSavedColumnData", columns);
        return columns;
    }

    private List<LegacyTableManager.ColumnData> getColumns(ICICSType<?> type, String columnNames, String columnWidths) {
        ArrayList<LegacyTableManager.ColumnData> columns = new ArrayList<LegacyTableManager.ColumnData>();
        String[] names = columnNames.split(",");
        String[] widths = columnWidths.split(",");
        int i = 0;
        while (i < names.length) {
            ICICSAttribute attribute;
            Integer width = -1;
            if (i < widths.length) {
                try {
                    width = Integer.parseInt(widths[i]);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if ((attribute = type.findAttributeByID(names[i])) != null) {
                columns.add(new LegacyTableManager.ColumnData(attribute, width));
            } else {
                debug.warning("getColumns", (Object)names[i], (Object)"Couldn't find column data. It is likely that the column name has changed.");
            }
            ++i;
        }
        return columns;
    }

    public void resetColumnData(ICICSType<?> type) {
        this.preferenceStore.setToDefault(String.valueOf(type.getResourceTableName()) + ".columnNames");
        this.preferenceStore.setToDefault(String.valueOf(type.getResourceTableName()) + ".columnWidths");
    }

    public void storeColumnData(List<LegacyTableManager.ColumnData> columns, ICICSType<?> type) {
        StringBuffer namesPrefValue = new StringBuffer();
        StringBuilder widthsPrefValue = new StringBuilder();
        for (LegacyTableManager.ColumnData column : columns) {
            namesPrefValue.append(((ICICSAttribute)column.id).getPropertyId());
            if (column.width != -1) {
                widthsPrefValue.append(column.width);
            }
            namesPrefValue.append(",");
            widthsPrefValue.append(",");
        }
        if (!columns.isEmpty()) {
            namesPrefValue.deleteCharAt(namesPrefValue.length() - 1);
            widthsPrefValue.deleteCharAt(widthsPrefValue.length() - 1);
        }
        String columnNamesPrefName = String.valueOf(type.getResourceTableName()) + ".columnNames";
        String columnWidthsPrefName = String.valueOf(type.getResourceTableName()) + ".columnWidths";
        debug.event("Scheduler.saveColumns()", (Object)namesPrefValue, (Object)widthsPrefValue);
        this.preferenceStore.putValue(columnNamesPrefName, namesPrefValue.toString());
        this.preferenceStore.putValue(columnWidthsPrefName, widthsPrefValue.toString());
    }
}

