/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.views;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.ActiveWorkloadDefinitionType;
import com.ibm.cics.core.ui.PluginConstants;
import com.ibm.cics.core.ui.views.IDefaultColumnsProvider;
import com.ibm.cics.core.ui.views.IElementTypeService;
import com.ibm.cics.core.ui.views.ResourcesTable;
import com.ibm.cics.core.ui.views.ResourcesView;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSType;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class ActiveWorkloadDefinitionsView
extends ResourcesView {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(ActiveWorkloadDefinitionsView.class);

    public ActiveWorkloadDefinitionsView() {
        super((ICICSType<?>)ActiveWorkloadDefinitionType.getInstance());
    }

    @Override
    protected String getHelpContextId() {
        return PluginConstants.ACTIVE_WORKLOAD_DEFINITIONS_VIEW_HELP_CTX_ID;
    }

    @Override
    protected List<ICICSAttribute<?>> getDefaultColumns() {
        return Arrays.asList(ActiveWorkloadDefinitionType.WORKLOAD, ActiveWorkloadDefinitionType.WORKLOAD_OWNER, ActiveWorkloadDefinitionType.DESCRIPTION, ActiveWorkloadDefinitionType.NAME, ActiveWorkloadDefinitionType.TRANSACTION_GROUP, ActiveWorkloadDefinitionType.LU_NAME, ActiveWorkloadDefinitionType.PROCESS_TYPE, ActiveWorkloadDefinitionType.TARGET_SCOPE);
    }

    @Override
    protected ResourcesTable createResourcesTable(IElementTypeService elementTypeService, IDefaultColumnsProvider defaultColumnsProvider, String connectionCategoryId, boolean multiSelect) {
        return new ResourcesTable(elementTypeService, defaultColumnsProvider, connectionCategoryId, multiSelect){

            @Override
            protected void performDefaultViewAction(ICICSObject aCICSObject) {
                IActionFilter actionFilter = (IActionFilter)Platform.getAdapterManager().getAdapter((Object)aCICSObject, IActionFilter.class);
                if (actionFilter != null && actionFilter.testAttribute((Object)aCICSObject, "mutable", "true")) {
                    try {
                        Bundle editorsBundle = Platform.getBundle((String)"com.ibm.cics.core.ui.editors");
                        Class editAction = editorsBundle.loadClass("com.ibm.cics.core.ui.editors.actions.EditRoutingRuleAction");
                        IObjectActionDelegate editResourceDefinitionAction = (IObjectActionDelegate)editAction.newInstance();
                        editResourceDefinitionAction.setActivePart(null, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart());
                        editResourceDefinitionAction.selectionChanged(null, (ISelection)new StructuredSelection((Object)aCICSObject));
                        editResourceDefinitionAction.run(null);
                    }
                    catch (Exception ex) {
                        debug.error("createResourcesTable", (Throwable)ex);
                    }
                }
            }
        };
    }
}

