/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.views;

import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.model.ICICSplexRepository;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.ISystemGroupRoot;
import com.ibm.cics.core.model.context.IAssociationContextProvider;
import com.ibm.cics.core.ui.Debug;
import com.ibm.cics.core.ui.PluginConstants;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.actions.NewDefinitionWizardDropdownAction;
import com.ibm.cics.core.ui.actions.RemoveGroupFromListAction;
import com.ibm.cics.core.ui.adapters.WorkbenchAdapterFactory;
import com.ibm.cics.core.ui.views.Messages;
import com.ibm.cics.core.ui.views.ResourcesTreeView;
import com.ibm.cics.explorer.tables.ui.CommonMessages;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSRegionDefinition;
import com.ibm.cics.model.ICICSRegionGroupDefinition;
import com.ibm.cics.model.ICICSplex;
import com.ibm.cics.model.ICSDGroupDefinition;
import com.ibm.cics.model.IDefinition;
import com.ibm.cics.model.IResourceGroupDefinition;
import com.ibm.cics.model.ui.ICICSWorkbenchActionConstants;
import com.ibm.cics.sm.comm.context.IAssociationContext;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;

public class CICSplexRepositoriesView
extends ResourcesTreeView {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ConnectionServiceListener connectionServiceListener;
    private static final Logger logger = Logger.getLogger(CICSplexRepositoriesView.class.getPackage().getName());

    @Override
    public void createPartControl(Composite parent) {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"createPartControl", (Object)((Object)this), (Object)parent);
        super.createPartControl(parent);
        this.createPopupMenu();
        this.addResourceManagerListener();
        this.initDragAndDrop(this.viewer);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), PluginConstants.GROUPS_VIEW_HELP_CTX_ID);
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"createPartControl");
    }

    protected void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                CICSplexRepositoriesView.this.fillContextMenu(manager);
            }
        });
        Menu popupMenu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(popupMenu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager aMenuManager) {
        IAssociationContext context;
        Object object;
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 1 && !(selection.getFirstElement() instanceof ICICSRegionGroupDefinition)) {
            ICICSplexRepository cicsPlexRepository;
            NewDefinitionWizardDropdownAction action = new NewDefinitionWizardDropdownAction();
            boolean enabled = UIPlugin.getDefault().getConnectionContextManager().canCreateCICSDefinition();
            ICICSObject selected = (ICICSObject)selection.getFirstElement();
            if (selected instanceof ICICSplexRepository && !(cicsPlexRepository = (ICICSplexRepository)selected).mpCMASActive()) {
                enabled = false;
            }
            action.setEnabled(enabled);
            aMenuManager.add((IAction)action);
        }
        for (String separatorName : ICICSWorkbenchActionConstants.getMenuSeparatorNames()) {
            aMenuManager.add((IContributionItem)new Separator(separatorName));
        }
        if (selection.size() == 1 && ((object = selection.getFirstElement()) instanceof IResourceGroupDefinition || object instanceof ICSDGroupDefinition) && (context = this.getAssociationContext((IDefinition)object)) != null) {
            ICPSM cpsm = ((ISystemGroupRoot)this.viewer.getInput()).getCPSM();
            aMenuManager.appendToGroup("commonActions", (IAction)new RemoveGroupFromListAction(cpsm, context, selection));
        }
    }

    @Override
    protected IDeferredWorkbenchAdapter getAdapter(Object element) {
        if (element instanceof ICICSplex) {
            return WorkbenchAdapterFactory.cicsPlexToGroupsAdapter;
        }
        return null;
    }

    private void initDragAndDrop(TreeViewer viewer) {
        ViewerDropAdapter listener = new ViewerDropAdapter((Viewer)viewer){

            public void dragEnter(DropTargetEvent event) {
                if (Debug.DEBUG_DRAGANDDROP) {
                    Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"dragEnter", (Object)("detail=" + event.detail));
                }
                if (event.detail == 16) {
                    event.detail = (event.operations & 4) != 0 ? 4 : 0;
                }
                super.dragEnter(event);
                if (Debug.DEBUG_DRAGANDDROP) {
                    Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"dragEnter", (Object)("detail=" + event.detail));
                }
            }

            public boolean performDrop(Object data) {
                if (Debug.DEBUG_DRAGANDDROP) {
                    Debug.event((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"performDrop", (Object)("data=" + data));
                }
                return true;
            }

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                if (Debug.DEBUG_DRAGANDDROP) {
                    Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"validateDrop", (Object)("target=" + target + ", operation=" + operation + ", type=" + transferType));
                }
                boolean result = LocalSelectionTransfer.getTransfer().isSupportedType(transferType);
                if (Debug.DEBUG_DRAGANDDROP) {
                    Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"validateDrop", (Object)("result=" + result));
                }
                return result;
            }
        };
        Transfer[] transferTypes = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        viewer.addDropSupport(20, transferTypes, (DropTargetListener)listener);
    }

    @Override
    protected void accessibilitySelectionHandling(AccessibleEvent e, Object selected) {
        if (selected != null && selected instanceof ICICSplexRepository) {
            e.result = ((ICICSplexRepository)selected).getName();
        } else if (selected != null && selected instanceof ICICSRegionGroupDefinition) {
            e.result = ((ICICSRegionGroupDefinition)selected).getName();
        } else if (selected != null && selected instanceof ICICSRegionDefinition) {
            e.result = ((ICICSRegionDefinition)selected).getName();
        }
    }

    @Override
    public void dispose() {
        try {
            this.removeListeners();
        }
        finally {
            super.dispose();
        }
    }

    private void addResourceManagerListener() {
        this.setResourceManager((ICPSM)ConnectionsPlugin.getDefault().getConnectionService().getConnectable("com.ibm.cics.sm.connection"));
        this.connectionServiceListener = new ConnectionServiceListener(){

            public void event(final ConnectionServiceListener.ConnectionServiceEvent event) {
                if ("com.ibm.cics.sm.connection".equals(event.getConnectionCategoryId())) {
                    CICSplexRepositoriesView.this.viewer.getTree().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (event instanceof ConnectionServiceListener.ConnectedEvent) {
                                CICSplexRepositoriesView.this.setResourceManager((ICPSM)event.getConnectable());
                            } else if (event instanceof ConnectionServiceListener.ConnectingEvent) {
                                CICSplexRepositoriesView.this.setContentDescription(CommonMessages.ResourcesView_statusConnecting);
                            } else if (event instanceof ConnectionServiceListener.DisconnectedEvent) {
                                CICSplexRepositoriesView.this.setResourceManager(null);
                            }
                        }
                    });
                }
            }
        };
        ConnectionsPlugin.getDefault().getConnectionService().addConnectionServiceListener(this.connectionServiceListener);
    }

    private void removeListeners() {
        this.connectionServiceListener.makeStale();
    }

    public void setResourceManager(ICPSM cpsm) {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"setResourceManager", (Object)((Object)this), (Object)cpsm);
        if (cpsm != null) {
            this.viewer.setInput((Object)cpsm.getSystemGroupRoot());
            String description = Messages.getString("ResourcesView.status.connected", cpsm.getName());
            this.setContentDescription(description);
        } else {
            this.viewer.setInput(null);
            this.setContentDescription(CommonMessages.ResourcesView_statusDisconnected);
        }
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"setResourceManager");
    }

    private IAssociationContext getAssociationContext(IDefinition definition) {
        IAssociationContextProvider contextProvider;
        Object parent;
        TreePath parentPath;
        TreeSelection selection = (TreeSelection)this.viewer.getSelection();
        TreePath[] paths = selection.getPathsFor((Object)definition);
        if (paths.length == 1 && (parentPath = paths[0].getParentPath()) != null && (parent = parentPath.getLastSegment()) instanceof ICICSObject && (contextProvider = (IAssociationContextProvider)Platform.getAdapterManager().getAdapter(parent, IAssociationContextProvider.class)) != null) {
            return contextProvider.getContext((ICICSObject)parent);
        }
        return null;
    }
}

