/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.views;

import com.ibm.cics.common.util.EventManager;
import com.ibm.cics.common.util.IStaleableEventListener;
import com.ibm.cics.core.ui.views.IElementTypeService;
import com.ibm.cics.core.ui.views.ResourcesView;
import com.ibm.cics.explorer.tables.ui.IBaseContextProvider;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.sm.comm.IScopedContext;

public abstract class CSDAwareResourcesView
extends ResourcesView {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ContextAwareElementTypeService ets;

    public CSDAwareResourcesView(ContextAwareElementTypeService ets) {
        super(ets);
        this.ets = ets;
        this.ets.setScoped(this.getContext() instanceof IScopedContext);
    }

    protected CSDAwareResourcesView(ICICSType<?> fullContextElementType, ICICSType<?> scopedContextElementType) {
        this(new ContextAwareElementTypeService(fullContextElementType, scopedContextElementType));
        this.resourcesTable.getBaseContextProvider().addListener(new IBaseContextProvider.Listener(){

            public void event(IBaseContextProvider.ContextChangedEvent event) {
                if (event instanceof IBaseContextProvider.ContextChangedEvent) {
                    CSDAwareResourcesView.this.ets.setScoped(event.getContext() instanceof IScopedContext);
                }
            }
        });
    }

    protected boolean canCreate() {
        return this.ets.canCreate();
    }

    private static class ContextAwareElementTypeService
    implements IElementTypeService {
        private ICICSType<?> fullContextElementType;
        private ICICSType<?> scopedContextElementType;
        private boolean scoped = false;
        private EventManager<IElementTypeService.Event> eventManager = new EventManager();

        public ContextAwareElementTypeService(ICICSType<?> fullContextElementType, ICICSType<?> scopedContextElementType) {
            this.fullContextElementType = fullContextElementType;
            this.scopedContextElementType = scopedContextElementType;
        }

        public boolean canCreate() {
            return this.getElementType().equals(this.fullContextElementType);
        }

        @Override
        public ICICSType<?> getElementType() {
            if (this.scoped) {
                return this.scopedContextElementType;
            }
            return this.fullContextElementType;
        }

        private void setScoped(boolean scoped) {
            if (this.scoped ^ scoped) {
                this.scoped = scoped;
                if (this.scoped) {
                    this.eventManager.notifyListeners((Object)new IElementTypeService.ElementTypeChangedEvent(this.fullContextElementType, this.scopedContextElementType));
                } else {
                    this.eventManager.notifyListeners((Object)new IElementTypeService.ElementTypeChangedEvent(this.scopedContextElementType, this.fullContextElementType));
                }
            }
        }

        @Override
        public void addElementTypeServiceListener(IElementTypeService.ElementTypeServiceListener listener) {
            this.eventManager.addListener((IStaleableEventListener)listener);
        }
    }
}

