/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.views;

import com.ibm.cics.common.util.EventManager;
import com.ibm.cics.common.util.IStaleableEventListener;
import com.ibm.cics.common.util.StaleableEventListener;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class LegacyTableManager {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String LAYOUT_DATA = "org.eclipse.jface.LAYOUT_DATA";
    private final EventManager<Event> eventManager = new EventManager();
    private boolean tooltipSetOnViewer = false;
    private TableColumnLayout layout;
    private TableViewer tableViewer;
    private int[] lastColumnOrder;
    private final boolean multiSelect;

    public LegacyTableManager(boolean multiSelect) {
        this.multiSelect = multiSelect;
    }

    public void addListener(Listener listener) {
        this.eventManager.addListener((IStaleableEventListener)listener);
    }

    public void setColumns(List<? extends Object> ids) {
        ArrayList<ColumnData> newColumns = new ArrayList<ColumnData>();
        for (Object object : ids) {
            newColumns.add(new ColumnData(object, -1));
        }
        this.setColumnData(newColumns);
    }

    public void setColumnData(final List<ColumnData> newColumns) {
        this.withTableLayoutChanges(new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < newColumns.size()) {
                    ColumnData column = (ColumnData)newColumns.get(i);
                    LegacyTableManager.this.addColumn(column.id, column.width, i);
                    ++i;
                }
                int numCols = LegacyTableManager.this.tableViewer.getTable().getColumnCount() - 1;
                int numNewCols = newColumns.size();
                int numOldCols = numCols - numNewCols;
                int i2 = 0;
                while (i2 < numOldCols) {
                    LegacyTableManager.this.disposeColumn(LegacyTableManager.this.tableViewer.getTable().getColumn(numNewCols + 1));
                    ++i2;
                }
            }
        });
    }

    public Display getDisplay() {
        return this.tableViewer.getTable().getDisplay();
    }

    private void disposeColumn(TableColumn column) {
        Object id = this.getId(column);
        column.dispose();
        this.notify(new ColumnRemovedEvent(this, id));
    }

    private void withTableLayoutChanges(Runnable r) {
        try {
            this.tableViewer.getTable().setRedraw(false);
            r.run();
        }
        finally {
            this.tableViewer.getTable().setRedraw(true);
            this.tableViewer.getTable().getParent().layout();
            this.tableViewer.refresh();
        }
    }

    private Object getId(TableColumn column) {
        return column.getData();
    }

    public void addColumn(final Object id) {
        this.withTableLayoutChanges(new Runnable(){

            @Override
            public void run() {
                LegacyTableManager.this.addColumn(id, -1, -1);
            }
        });
    }

    public void removeColumn(final Object id) {
        this.withTableLayoutChanges(new Runnable(){

            @Override
            public void run() {
                TableColumn[] tableColumnArray = LegacyTableManager.this.tableViewer.getTable().getColumns();
                int n = tableColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumn column = tableColumnArray[n2];
                    Object columnId = LegacyTableManager.this.getId(column);
                    if (columnId == id) {
                        LegacyTableManager.this.disposeColumn(column);
                        break;
                    }
                    ++n2;
                }
            }
        });
    }

    private void notify(Event event) {
        if (event instanceof ColumnAddedEvent || event instanceof ColumnRemovedEvent || event instanceof ColumnMovedEvent) {
            this.lastColumnOrder = this.tableViewer.getTable().getColumnOrder();
        }
        this.eventManager.notifyListeners((Object)event);
    }

    public TableViewer createTableViewer(Composite parent) {
        return this.createTableViewer(parent, 0);
    }

    public TableViewer createTableViewer(Composite parent, int style) {
        int viewerModifiers = 0x10010300 | style;
        if (this.multiSelect) {
            viewerModifiers |= 2;
        }
        this.layout = new TableColumnLayout();
        parent.setLayout((Layout)this.layout);
        this.tableViewer = new TableViewer(parent, viewerModifiers);
        Table table = this.tableViewer.getTable();
        table.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        TableColumn column = new TableColumn(table, 0);
        this.layout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(0, 0, false));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                LegacyTableManager.this.notify(new TableDisposedEvent(LegacyTableManager.this));
            }
        });
        return this.tableViewer;
    }

    private ColumnLayoutData getLayoutData(int width) {
        if (width == -1) {
            return new ColumnWeightData(1, 75);
        }
        return new ColumnPixelData(width);
    }

    private void addColumn(final Object columnId, int width, int index) {
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewer, 16384, index < 0 ? index : index + 1);
        TableColumn tableColumn = tableViewerColumn.getColumn();
        this.layout.setColumnData((Widget)tableColumn, this.getLayoutData(width));
        tableColumn.setAlignment(16384);
        tableColumn.setMoveable(true);
        tableColumn.setData(columnId);
        if (!this.tooltipSetOnViewer) {
            this.tooltipSetOnViewer = true;
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer);
        }
        tableColumn.addControlListener(new ControlListener(){
            private boolean reentrant = false;

            public void controlResized(ControlEvent e) {
                TableColumn tableColumn = (TableColumn)e.widget;
                ColumnLayoutData columnLayoutData = (ColumnLayoutData)tableColumn.getData(LegacyTableManager.LAYOUT_DATA);
                if (columnLayoutData instanceof ColumnPixelData) {
                    Object id = LegacyTableManager.this.getId(tableColumn);
                    LegacyTableManager.this.notify(new ColumnResizedEvent(LegacyTableManager.this, id, ((ColumnPixelData)columnLayoutData).width));
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void controlMoved(ControlEvent e) {
                if (this.reentrant) return;
                try {
                    int[] newColumnOrder;
                    this.reentrant = true;
                    try {
                        newColumnOrder = LegacyTableManager.this.tableViewer.getTable().getColumnOrder();
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        if (!System.getProperty("os.name").startsWith("Mac")) throw ex;
                        this.reentrant = false;
                        return;
                    }
                    int[] moveData = LegacyTableManager.evaluateMove(LegacyTableManager.this.lastColumnOrder, newColumnOrder);
                    if (moveData == null) return;
                    if (moveData[1] == 0 || moveData[2] == 0) {
                        int[] columnOrder = LegacyTableManager.this.tableViewer.getTable().getColumnOrder();
                        int dummyIndex = columnOrder[1];
                        int realIndex = columnOrder[0];
                        columnOrder[0] = dummyIndex;
                        columnOrder[1] = realIndex;
                        LegacyTableManager.this.tableViewer.getTable().setColumnOrder(columnOrder);
                        if (moveData[1] == 1) {
                            return;
                        }
                        moveData[0] = 1;
                    }
                    TableColumn movedColumn = LegacyTableManager.this.tableViewer.getTable().getColumn(moveData[0]);
                    Object id = LegacyTableManager.this.getId(movedColumn);
                    LegacyTableManager.this.notify(new ColumnMovedEvent(LegacyTableManager.this, id, moveData[1], moveData[2]));
                    return;
                }
                finally {
                    this.reentrant = false;
                }
            }
        });
        tableColumn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LegacyTableManager.this.notify(new SortRequestedEvent(LegacyTableManager.this, columnId));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.notify(new ColumnAddedEvent(this, columnId, index, tableViewerColumn));
    }

    public void resetWidths() {
        this.withTableLayoutChanges(new Runnable(){

            @Override
            public void run() {
                TableColumn[] tableColumnArray = LegacyTableManager.this.tableViewer.getTable().getColumns();
                int n = tableColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumn column = tableColumnArray[n2];
                    if (LegacyTableManager.this.getId(column) != null) {
                        LegacyTableManager.this.layout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(1, 75));
                        LegacyTableManager.this.notify(new ColumnResizedEvent(LegacyTableManager.this, LegacyTableManager.this.getId(column), -1));
                    }
                    ++n2;
                }
            }
        });
    }

    public List<ColumnData> getColumnData() {
        if (!this.tableViewer.getTable().isDisposed()) {
            ArrayList<ColumnData> columnData = new ArrayList<ColumnData>();
            for (TableColumn column : this.getColumnsInOrder()) {
                Object id = this.getId(column);
                if (id == null) continue;
                int width = -1;
                ColumnLayoutData columnLayoutData = (ColumnLayoutData)column.getData(LAYOUT_DATA);
                if (columnLayoutData instanceof ColumnPixelData) {
                    width = column.getWidth();
                }
                columnData.add(new ColumnData(id, width));
            }
            return columnData;
        }
        return null;
    }

    private List<TableColumn> getColumnsInOrder() {
        return new ReorderedList<TableColumn>(this.tableViewer.getTable().getColumns(), this.tableViewer.getTable().getColumnOrder());
    }

    static int[] evaluateMove(int[] before, int[] after) {
        if (before.length != after.length) {
            return null;
        }
        int movedIndex = -1;
        int from = -1;
        int to = -1;
        int i = 0;
        while (i < after.length) {
            if (before[i] != after[i]) {
                if (movedIndex == -1) {
                    if (before[i + 1] == after[i]) {
                        movedIndex = before[i];
                        from = i;
                    } else {
                        movedIndex = after[i];
                        to = i;
                    }
                } else if (from == -1) {
                    if (before[i] == movedIndex) {
                        from = i;
                        break;
                    }
                } else if (to == -1 && after[i] == movedIndex) {
                    to = i;
                    break;
                }
            }
            ++i;
        }
        if (movedIndex != -1 && from != -1 && to != -1) {
            return new int[]{movedIndex, from, to};
        }
        return null;
    }

    public void setSortColumn(Object id, boolean direction) {
        Table table = this.tableViewer.getTable();
        if (!table.isDisposed()) {
            if (id != null) {
                TableColumn[] tableColumnArray = table.getColumns();
                int n = tableColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumn col = tableColumnArray[n2];
                    Object colID = col.getData();
                    if (id.equals(colID)) {
                        table.setSortColumn(col);
                        table.setSortDirection(direction ? 128 : 1024);
                    }
                    ++n2;
                }
            } else {
                table.setSortColumn(null);
            }
        }
    }

    public String[][] getSelectionData() {
        int[] columnOrder = this.tableViewer.getTable().getColumnOrder();
        TableItem[] selection = this.tableViewer.getTable().getSelection();
        String[][] data = new String[selection.length + 1][columnOrder.length - 1];
        TableColumn[] columns = this.tableViewer.getTable().getColumns();
        int col = 0;
        while (col < columnOrder.length - 1) {
            data[0][col] = columns[columnOrder[col + 1]].getText();
            ++col;
        }
        int row = 1;
        while (row < selection.length + 1) {
            int col2 = 0;
            while (col2 < columnOrder.length - 1) {
                data[row][col2] = selection[row - 1].getText(columnOrder[col2 + 1]);
                ++col2;
            }
            ++row;
        }
        return data;
    }

    public static class ColumnAddedEvent
    extends ColumnEvent {
        private final int index;
        private final TableViewerColumn column;

        public ColumnAddedEvent(LegacyTableManager legacyTableManager, Object id, int index, TableViewerColumn column) {
            super(legacyTableManager, id);
            this.index = index;
            this.column = column;
        }

        public int getIndex() {
            return this.index;
        }

        public TableViewerColumn getColumn() {
            return this.column;
        }
    }

    public static class ColumnData {
        public final Object id;
        public final int width;

        public ColumnData(Object id, int width) {
            this.id = id;
            this.width = width;
        }
    }

    public static abstract class ColumnEvent
    extends Event {
        private final Object id;

        public ColumnEvent(LegacyTableManager legacyTableManager, Object id) {
            super(legacyTableManager);
            this.id = id;
        }

        public Object getColumnId() {
            return this.id;
        }
    }

    public static class ColumnMovedEvent
    extends ColumnEvent {
        private final int from;
        private final int to;

        public ColumnMovedEvent(LegacyTableManager legacyTableManager, Object id, int from, int to) {
            super(legacyTableManager, id);
            this.from = from;
            this.to = to;
        }

        public int getFrom() {
            return this.to;
        }

        public int getTo() {
            return this.from;
        }
    }

    public static class ColumnRemovedEvent
    extends ColumnEvent {
        public ColumnRemovedEvent(LegacyTableManager legacyTableManager, Object id) {
            super(legacyTableManager, id);
        }
    }

    public static class ColumnResizedEvent
    extends ColumnEvent {
        private final int width;

        public ColumnResizedEvent(LegacyTableManager legacyTableManager, Object id, int width) {
            super(legacyTableManager, id);
            this.width = width;
        }

        public int getWidth() {
            return this.width;
        }
    }

    public static abstract class Event {
        private final LegacyTableManager legacyTableManager;

        public Event(LegacyTableManager legacyTableManager) {
            this.legacyTableManager = legacyTableManager;
        }

        public LegacyTableManager getTableManager() {
            return this.legacyTableManager;
        }
    }

    public static abstract class Listener
    extends StaleableEventListener<Event> {
    }

    private static class ReorderedList<T>
    extends AbstractList<T> {
        private final T[] elements;
        private final int[] elementOrder;

        public ReorderedList(T[] elements, int[] elementOrder) {
            this.elements = elements;
            this.elementOrder = elementOrder;
        }

        @Override
        public T get(int index) {
            return this.elements[this.elementOrder[index + 1]];
        }

        @Override
        public int size() {
            return this.elements.length - 1;
        }
    }

    public static class SortRequestedEvent
    extends ColumnEvent {
        public SortRequestedEvent(LegacyTableManager legacyTableManager, Object id) {
            super(legacyTableManager, id);
        }
    }

    public static class TableDisposedEvent
    extends Event {
        public TableDisposedEvent(LegacyTableManager legacyTableManager) {
            super(legacyTableManager);
        }
    }
}

