/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.views;

import com.ibm.cics.core.ui.Debug;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.flhsupport.FLHSupport;
import com.ibm.cics.core.ui.properties.CICSObjectPropertyDescriptorComparator;
import com.ibm.cics.core.ui.properties.CICSTypePropertySource;
import com.ibm.cics.core.ui.properties.IAttributePropertyDescriptor;
import com.ibm.cics.core.ui.properties.ICICSObjectPropertyDescriptor;
import com.ibm.cics.core.ui.views.LegacyTableManager;
import com.ibm.cics.core.ui.views.Messages;
import com.ibm.cics.core.ui.views.PreferenceService;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class ResourcesViewColumnDialog
extends TrayDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String ID = "com.ibm.cics.core.ui.views.columns";
    static final String PROPERTY_DESCRIPTOR = "PROPERTY_DESCRIPTOR";
    private static final String DIALOG_HELP_CONTEXT_ID = "com.ibm.cics.core.ui.dialog_ResourcesViewColumnDialog";
    private static final String NAME = "NAME";
    private static final int RESET = 12345;
    protected static ICICSType<?> currentType;
    FilteredTree currentlyUsedColumnsTree;
    private TreeViewer currentlyUsedColumnsTreeViewer;
    FilteredTree availableColumnsTree;
    private TreeViewer availableColumnsTreeViewer;
    private List<IPropertyDescriptor> currentlyUsedPropertyDescriptors = new ArrayList<IPropertyDescriptor>();
    private ArrayList<IPropertyDescriptor> availableColumnsPropertyDescriptors = new ArrayList();
    private Button addButton;
    private Button removeButton;
    private CICSTypePropertySource propertySource;
    private LegacyTableManager legacyTableManager;
    private PreferenceService preferenceService;
    static final String X_LOCATION = "ResourcesView.customizeColumns.dialog.x_location";
    static final String Y_LOCATION = "ResourcesView.customizeColumns.dialog.y_location";
    static final String WIDTH = "ResourcesView.customizeColumns.dialog.width";
    static final String HEIGHT = "ResourcesView.customizeColumns.dialog.height";
    private static final Logger logger;

    static {
        logger = Logger.getLogger(ResourcesViewColumnDialog.class.getPackage().getName());
    }

    public ResourcesViewColumnDialog(Shell parentShell, CICSTypePropertySource propertySource, LegacyTableManager legacyTableManager, PreferenceService preferenceService) {
        super(parentShell);
        this.preferenceService = preferenceService;
        Debug.enter((Logger)logger, (String)ResourcesViewColumnDialog.class.getName(), (String)"<init>", (Object)parentShell, (Object)propertySource, (Object)legacyTableManager);
        this.legacyTableManager = legacyTableManager;
        this.propertySource = propertySource;
        this.setShellStyle(this.getShellStyle() | 0x10000 | 0x10);
        Debug.exit((Logger)logger, (String)ResourcesViewColumnDialog.class.getName(), (String)"<init>", (Object)((Object)this));
    }

    protected void initializeBounds() {
        super.initializeBounds();
        int x_location = this.getPreferenceValue(X_LOCATION);
        int y_location = this.getPreferenceValue(Y_LOCATION);
        if (x_location != 0 && y_location != 0) {
            this.getShell().setLocation(x_location, y_location);
        }
        int width = this.getPreferenceValue(WIDTH);
        int height = this.getPreferenceValue(HEIGHT);
        if (width != 0 && height != 0) {
            this.getShell().setSize(width, height);
        }
    }

    private int getPreferenceValue(String preferenceKey) {
        return UIPlugin.getDefault().getPreferenceStore().getInt(preferenceKey);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.getString("ResourcesViewColumnDialog.customiseColumns", this.propertySource.getCICSType().getResourceTableName()));
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout(1, false));
        c.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite columnsComposite = new Composite(c, 0);
        columnsComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        columnsComposite.setLayout((Layout)new GridLayout(3, false));
        Label l = new Label(columnsComposite, 0);
        l.setText(Messages.getString("ResourcesViewColumnDialog.availableAttributes", new Object[0]));
        l = new Label(columnsComposite, 0);
        l = new Label(columnsComposite, 0);
        l.setText(Messages.getString("ResourcesViewColumnDialog.currentViewerColumns", new Object[0]));
        this.availableColumnsTree = new FilteredTree(columnsComposite, 2818, new PatternFilter(), true);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        data.widthHint = 150;
        this.availableColumnsTree.setLayoutData((Object)data);
        Composite buttonArea = new Composite(columnsComposite, 0);
        buttonArea.setLayout((Layout)new GridLayout(1, true));
        data = new GridData(0, 4, false, true);
        buttonArea.setLayoutData((Object)data);
        this.currentlyUsedColumnsTree = new FilteredTree(columnsComposite, 2818, new PatternFilter(), true);
        data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        data.widthHint = 150;
        this.currentlyUsedColumnsTree.setLayoutData((Object)data);
        ITreeContentProvider availableTreeContentProvider = this.getTreeContentProvider(this.availableColumnsPropertyDescriptors);
        ITreeContentProvider currentlyUsedTreeContentProvider = this.getTreeContentProvider(this.currentlyUsedPropertyDescriptors);
        LabelProvider treeLabelProvider = new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IPropertyDescriptor) {
                    return ((IPropertyDescriptor)element).getDisplayName();
                }
                return null;
            }

            public Image getImage(Object element) {
                return null;
            }
        };
        this.availableColumnsTreeViewer = this.availableColumnsTree.getViewer();
        this.availableColumnsTreeViewer.setContentProvider((IContentProvider)availableTreeContentProvider);
        this.availableColumnsTreeViewer.setInput(this.availableColumnsPropertyDescriptors);
        this.availableColumnsTreeViewer.setLabelProvider((IBaseLabelProvider)treeLabelProvider);
        this.currentlyUsedColumnsTreeViewer = this.currentlyUsedColumnsTree.getViewer();
        this.currentlyUsedColumnsTreeViewer.setContentProvider((IContentProvider)currentlyUsedTreeContentProvider);
        this.currentlyUsedColumnsTreeViewer.setInput(this.availableColumnsPropertyDescriptors);
        this.currentlyUsedColumnsTreeViewer.setLabelProvider((IBaseLabelProvider)treeLabelProvider);
        this.addButton = new Button(buttonArea, 8);
        this.addButton.setText(String.valueOf(Messages.getString("ResourcesViewColumnDialog.add", new Object[0])) + " -->");
        data = new GridData(4, 0, true, false);
        this.addButton.setLayoutData((Object)data);
        this.addButton.setEnabled(false);
        this.removeButton = new Button(buttonArea, 8);
        this.removeButton.setText("<-- " + Messages.getString("ResourcesViewColumnDialog.remove", new Object[0]));
        this.removeButton.setEnabled(false);
        this.removeButton.setLayoutData((Object)data);
        this.currentlyUsedColumnsTreeViewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourcesViewColumnDialog.this.removeButton.setEnabled(ResourcesViewColumnDialog.this.hasColumnsToRemove());
                if (ResourcesViewColumnDialog.this.getTray() != null) {
                    ResourcesViewColumnDialog.this.showHelpForTableItem((TypedEvent)e);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ResourcesViewColumnDialog.this.removeSelectedColumn();
            }
        });
        this.availableColumnsTreeViewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourcesViewColumnDialog.this.addButton.setEnabled(!ResourcesViewColumnDialog.this.availableColumnsTreeViewer.getSelection().isEmpty());
                if (ResourcesViewColumnDialog.this.getTray() != null) {
                    ResourcesViewColumnDialog.this.showHelpForTableItem((TypedEvent)e);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ResourcesViewColumnDialog.this.addSelectedColumn();
            }
        });
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourcesViewColumnDialog.this.addSelectedColumn();
            }
        });
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourcesViewColumnDialog.this.removeSelectedColumn();
            }
        });
        this.initialize();
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Point location = ResourcesViewColumnDialog.this.getShell().getLocation();
                Point size = ResourcesViewColumnDialog.this.getShell().getSize();
                IPreferenceStore preferenceStore = UIPlugin.getDefault().getPreferenceStore();
                preferenceStore.setValue(ResourcesViewColumnDialog.X_LOCATION, location.x);
                preferenceStore.setValue(ResourcesViewColumnDialog.Y_LOCATION, location.y);
                preferenceStore.setValue(ResourcesViewColumnDialog.WIDTH, size.x);
                preferenceStore.setValue(ResourcesViewColumnDialog.HEIGHT, size.y);
                UIPlugin.getDefault().savePluginPreferences();
            }
        });
        HelpListener helpListener = new HelpListener(){

            public void helpRequested(HelpEvent e) {
                ResourcesViewColumnDialog.this.showHelpForTableItem((TypedEvent)e);
            }
        };
        this.availableColumnsTree.addHelpListener(helpListener);
        this.currentlyUsedColumnsTree.addHelpListener(helpListener);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent.getShell(), DIALOG_HELP_CONTEXT_ID);
        return c;
    }

    private void showHelpForTableItem(TypedEvent e) {
        if (e.widget instanceof FilteredTree) {
            FilteredTree tree = (FilteredTree)e.widget;
            if (tree.getViewer().getTree().getSelectionCount() > 0) {
                TreeItem ti = tree.getViewer().getTree().getSelection()[0];
                IPropertyDescriptor pd = (IPropertyDescriptor)ti.getData();
                FLHSupport.showHelp((String)pd.getHelpContextIds());
            } else {
                FLHSupport.showHelp(DIALOG_HELP_CONTEXT_ID);
            }
        }
    }

    private boolean hasColumnsToRemove() {
        if (this.currentlyUsedColumnsTreeViewer.getTree().getSelectionCount() >= 2) {
            return true;
        }
        if (this.currentlyUsedColumnsTreeViewer.getTree().getSelectionCount() == 1) {
            return !NAME.equalsIgnoreCase((String)((IPropertyDescriptor)this.currentlyUsedColumnsTreeViewer.getTree().getSelection()[0].getData()).getId());
        }
        return false;
    }

    void addSelectedColumn() {
        IStructuredSelection selectedItems = (IStructuredSelection)this.availableColumnsTreeViewer.getSelection();
        List propertyDescriptors = selectedItems.toList();
        for (IPropertyDescriptor propertyDescriptor : propertyDescriptors) {
            this.addCurrentlyUsedDescriptor(propertyDescriptor);
            this.removeAvailableDescriptor(propertyDescriptor);
            ICICSAttribute attribute = ((ICICSObjectPropertyDescriptor)propertyDescriptor).getAttribute();
            this.legacyTableManager.addColumn(attribute);
        }
        this.addButton.setEnabled(false);
    }

    void removeSelectedColumn() {
        IStructuredSelection selectedItems = (IStructuredSelection)this.currentlyUsedColumnsTreeViewer.getSelection();
        List propertyDescriptors = selectedItems.toList();
        for (IPropertyDescriptor propertyDescriptor : propertyDescriptors) {
            if (NAME.equalsIgnoreCase((String)propertyDescriptor.getId())) continue;
            this.removeCurrentlyUsedDescriptor(propertyDescriptor);
            ICICSAttribute attribute = ((ICICSObjectPropertyDescriptor)propertyDescriptor).getAttribute();
            this.legacyTableManager.removeColumn(attribute);
            this.addAvailableDescriptor(propertyDescriptor);
        }
        this.removeButton.setEnabled(false);
    }

    private void initialize() {
        List<LegacyTableManager.ColumnData> columns = this.legacyTableManager.getColumnData();
        this.currentlyUsedPropertyDescriptors.clear();
        for (LegacyTableManager.ColumnData column : columns) {
            IAttributePropertyDescriptor propertyDescriptor = this.propertySource.getPropertyDescriptor((Object)((ICICSAttribute)column.id).getPropertyId());
            this.addCurrentlyUsedDescriptor((IPropertyDescriptor)propertyDescriptor);
        }
        this.refreshAvailablePropertyDescriptors();
        this.currentlyUsedColumnsTreeViewer.refresh();
        this.availableColumnsTreeViewer.refresh();
    }

    private void refreshAvailablePropertyDescriptors() {
        IPropertyDescriptor[] propertyDescriptors = (IPropertyDescriptor[])this.propertySource.getPropertyDescriptors().clone();
        Arrays.sort(propertyDescriptors, new CICSObjectPropertyDescriptorComparator());
        IPropertyDescriptor[] iPropertyDescriptorArray = propertyDescriptors;
        int n = propertyDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertyDescriptor propertyDescriptor = iPropertyDescriptorArray[n2];
            if (!this.currentlyUsedPropertyDescriptors.contains(propertyDescriptor)) {
                this.availableColumnsPropertyDescriptors.add(propertyDescriptor);
            }
            ++n2;
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 12345) {
            this.preferenceService.resetColumns();
            this.availableColumnsPropertyDescriptors.clear();
            this.currentlyUsedPropertyDescriptors.clear();
            this.initialize();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 12345, Messages.getString("ResourcesViewColumnDialog.reset", new Object[0]), false);
        this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, true);
    }

    private void addCurrentlyUsedDescriptor(IPropertyDescriptor propertyDescriptor) {
        this.currentlyUsedPropertyDescriptors.add(propertyDescriptor);
        this.currentlyUsedColumnsTreeViewer.refresh(true);
    }

    private void removeCurrentlyUsedDescriptor(IPropertyDescriptor propertyDescriptor) {
        this.currentlyUsedPropertyDescriptors.remove(propertyDescriptor);
        this.currentlyUsedColumnsTreeViewer.refresh(true);
    }

    private void addAvailableDescriptor(IPropertyDescriptor propertyDescriptor) {
        this.availableColumnsPropertyDescriptors.add(propertyDescriptor);
        Collections.sort(this.availableColumnsPropertyDescriptors, new CICSObjectPropertyDescriptorComparator());
        this.availableColumnsTreeViewer.refresh(true);
    }

    private void removeAvailableDescriptor(IPropertyDescriptor propertyDescriptor) {
        this.availableColumnsPropertyDescriptors.remove(propertyDescriptor);
        this.availableColumnsTreeViewer.refresh(true);
    }

    private ITreeContentProvider getTreeContentProvider(final List<IPropertyDescriptor> propertyDescriptors) {
        ITreeContentProvider treeContentProvider = new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                return propertyDescriptors.toArray();
            }

            public Object[] getChildren(Object parentElement) {
                return null;
            }
        };
        return treeContentProvider;
    }

    public void init(IWorkbench workbench) {
    }
}

