/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.views;

import com.ibm.cics.core.model.TransactionDefinitionType;
import com.ibm.cics.core.ui.Debug;
import com.ibm.cics.core.ui.PluginConstants;
import com.ibm.cics.core.ui.views.ResourcesView;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSType;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;

public class TransactionDefinitionsView
extends ResourcesView {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(TransactionDefinitionsView.class.getPackage().getName());

    public TransactionDefinitionsView() {
        super((ICICSType<?>)TransactionDefinitionType.getInstance());
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.initDragAndDrop((StructuredViewer)this.resourcesTable.getTableViewer());
    }

    @Override
    protected List<ICICSAttribute<?>> getDefaultColumns() {
        return Arrays.asList(TransactionDefinitionType.NAME, TransactionDefinitionType.VERSION, TransactionDefinitionType.CREATE_TIME, TransactionDefinitionType.CHANGE_TIME, TransactionDefinitionType.DESCRIPTION, TransactionDefinitionType.STATUS);
    }

    private void initDragAndDrop(final StructuredViewer viewer) {
        DragSourceListener listener = new DragSourceListener(){

            public void dragSetData(DragSourceEvent event) {
                if (Debug.DEBUG_DRAGANDDROP) {
                    Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"dragSetData", (Object)("event=" + event));
                }
                if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
                    IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
                    LocalSelectionTransfer transfer = LocalSelectionTransfer.getTransfer();
                    transfer.setSelection((ISelection)selection);
                    event.data = transfer;
                    if (Debug.DEBUG_DRAGANDDROP) {
                        Debug.event((Logger)logger, (String)this.getClass().getName(), (String)"dragSetData", (Object)("event=" + event));
                    }
                }
                if (Debug.DEBUG_DRAGANDDROP) {
                    Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"dragSetData", (Object)("event=" + event));
                }
            }

            public void dragFinished(DragSourceEvent event) {
                if (Debug.DEBUG_DRAGANDDROP) {
                    Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"dragFinished", (Object)("event=" + event));
                }
                boolean bl = event.doit = !viewer.getSelection().isEmpty();
                if (Debug.DEBUG_DRAGANDDROP) {
                    Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"dragFinished", (Object)event.doit);
                }
            }

            public void dragStart(DragSourceEvent event) {
                if (Debug.DEBUG_DRAGANDDROP) {
                    Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"dragStart", (Object)("event=" + event));
                }
                boolean bl = event.doit = !viewer.getSelection().isEmpty();
                if (Debug.DEBUG_DRAGANDDROP) {
                    Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"dragStart", (Object)event.doit);
                }
            }
        };
        viewer.addDragSupport(4, new Transfer[]{LocalSelectionTransfer.getTransfer()}, listener);
    }

    @Override
    protected String getHelpContextId() {
        return PluginConstants.TRANSACTIONDEFS_VIEW_HELP_CTX_ID;
    }
}

