/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm;

import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import com.ibm.cics.sm.comm.SMConnectionResponse;
import com.ibm.cics.sm.comm.sm.SMRecord;

public class SMResponse
extends SMConnectionResponse {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final String stub;
    private final String resourceType;
    private final IContext context;
    private String status = "OK";
    private String response = "OK";
    private final int recordTotal;
    private SMConnectionRecord[] records;

    public SMResponse(String stub, String resourceType, IContext context) {
        this.stub = stub;
        this.resourceType = resourceType;
        this.context = context;
        this.recordTotal = 0;
    }

    public SMResponse(String stub, String resourceType, String[] data, IContext context) {
        this(stub, resourceType, data, "OK", context);
    }

    public SMResponse(String stub, String resourceType, String[] data, String response, IContext context) {
        this.stub = stub;
        this.resourceType = resourceType;
        this.recordTotal = data.length;
        this.records = this.parseData(resourceType, data);
        this.response = response;
        this.context = context;
    }

    public SMResponse(String stub, String resourceType, int recordTotal, IContext context) {
        this.stub = stub;
        this.resourceType = resourceType;
        this.context = context;
        this.recordTotal = recordTotal;
        this.response = "OK";
    }

    public SMResponse(String stub, String resourceType, int recordTotal, IContext context, String response) {
        this.stub = stub;
        this.resourceType = resourceType;
        this.context = context;
        this.recordTotal = recordTotal;
        this.response = response;
    }

    public SMResponse(String stub, String resourceType, SMConnectionRecord[] records, IContext context) {
        this.stub = stub;
        this.resourceType = resourceType;
        this.recordTotal = records.length;
        this.records = records;
        this.response = "OK";
        this.context = context;
    }

    private SMConnectionRecord[] parseData(String resourceType, String[] data) {
        SMConnectionRecord[] records = new SMConnectionRecord[data.length];
        int i = 0;
        while (i < data.length) {
            records[i] = new SMRecord(resourceType, data[i], this.context);
            ++i;
        }
        return records;
    }

    public SMResponse(SMResponse response, int start, int count) {
        this(response.getStub(), response.getResourceType(), response.getRecords(start, count), response.getContext());
    }

    private SMConnectionRecord[] getRecords(int start, int count) {
        if (count == -1) {
            count = this.records.length;
        }
        SMConnectionRecord[] newRecords = new SMConnectionRecord[count];
        System.arraycopy(this.records, start, newRecords, 0, count);
        return newRecords;
    }

    public SMConnectionRecord getRecord(int index) {
        return this.records[index];
    }

    public int getRecordCount() {
        if (this.records == null) {
            return 0;
        }
        return this.records.length;
    }

    public int getRecordStart() {
        return 0;
    }

    public int getRecordTotal() {
        return this.recordTotal;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getStub() {
        return this.stub;
    }

    public String getStatus() {
        return this.status;
    }

    public String getResponse() {
        return this.response;
    }

    public IContext getContext() {
        return this.context;
    }

    public String toString() {
        return "SMResponse[" + this.resourceType + ", " + this.getRecordCount() + ", " + this.stub + "]";
    }
}

