/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal;

import com.ibm.cics.sm.comm.INormalizer;
import com.ibm.cics.sm.comm.NormalizationException;
import com.ibm.cics.sm.comm.sm.internal.INormalizerFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class CMCI41NormalizerFactory
implements INormalizerFactory {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Map<String, INormalizer> NORMALIZERS;
    private static final String UNSPECIFIED_DATE_STRING = "1900-01-01T00:00:00";
    private static Pattern cpsmTimePattern;
    private static Pattern rfc822TimePattern;
    private static final INormalizer DATE_NORMALIZER;

    static {
        cpsmTimePattern = Pattern.compile("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}");
        rfc822TimePattern = Pattern.compile("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[+-]\\d{4}");
        DATE_NORMALIZER = new INormalizer(){

            public String normalize(String denormalizedValue) throws NormalizationException {
                if (denormalizedValue == null) {
                    return null;
                }
                if (CMCI41NormalizerFactory.UNSPECIFIED_DATE_STRING.equals(denormalizedValue)) {
                    return "0000-00-00T00:00:00.000+0000";
                }
                if (CMCI41NormalizerFactory.isValidCPSMTime(denormalizedValue)) {
                    return String.valueOf(denormalizedValue) + ".000+0000";
                }
                return denormalizedValue;
            }

            public String denormalize(String normalizedValue) throws NormalizationException {
                if (normalizedValue == null) {
                    return null;
                }
                if ("0000-00-00T00:00:00.000+0000".equals(normalizedValue)) {
                    return CMCI41NormalizerFactory.UNSPECIFIED_DATE_STRING;
                }
                if (CMCI41NormalizerFactory.isValidRFC822Time(normalizedValue)) {
                    return normalizedValue.substring(0, 19);
                }
                return normalizedValue;
            }
        };
        HashMap<String, INormalizer> normalizers = new HashMap<String, INormalizer>();
        normalizers.put("DATE_NORMALIZER_KEY", DATE_NORMALIZER);
        NORMALIZERS = Collections.unmodifiableMap(normalizers);
    }

    private static boolean isValidCPSMTime(String testString) {
        return cpsmTimePattern.matcher(testString).matches();
    }

    private static boolean isValidRFC822Time(String testString) {
        return rfc822TimePattern.matcher(testString).matches();
    }

    @Override
    public Map<String, INormalizer> getNormalizers() {
        return NORMALIZERS;
    }
}

