/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.internal.ObjectGetter;
import com.ibm.cics.model.CICSActionException;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSObjectListFactory;
import com.ibm.cics.model.ICICSType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CICSObjectListFactory<T extends ICICSObject>
implements ICICSObjectListFactory<T> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug DEBUG = new Debug(CICSObjectListFactory.class);
    private List<T> resources;
    private final String description;
    private final ObjectGetter<T> getter;

    public CICSObjectListFactory(String description, ObjectGetter<T> getter) {
        this.description = description;
        this.getter = getter;
    }

    public boolean isActivated() {
        return this.resources != null;
    }

    public List<T> getAll() throws CICSActionException {
        if (!this.isActivated()) {
            this.activate();
        }
        List got = this.resources.size() == 0 ? Collections.emptyList() : this.get(0, this.resources.size());
        this.deactivate();
        return got;
    }

    public void deactivate() throws CICSActionException {
        this.getter.discard();
        this.resources = null;
    }

    public synchronized void activate() throws CICSActionException {
        DEBUG.enter("activate", (Object)this);
        int size = this.getter.get();
        this.resources = new ArrayList<T>(size);
        int i = 0;
        while (i < size) {
            this.resources.add(null);
            ++i;
        }
        DEBUG.exit("activate", (Object)size);
    }

    public List<T> get(int index, int count) throws CICSActionException {
        if (this.isActivated()) {
            FetchBounds fetchBounds = new FetchBounds(index, count);
            if (fetchBounds.fetchRequired()) {
                this.getData(fetchBounds);
            }
            return Collections.unmodifiableList(this.resources.subList(index, index + count));
        }
        throw new IllegalStateException("Not activated");
    }

    public T get(int index) throws CICSActionException {
        return (T)((ICICSObject)this.get(index, 1).get(0));
    }

    private synchronized void getData(FetchBounds bounds) throws CICSActionException {
        DEBUG.enter("getData", (Object)this, (Object)bounds);
        int count = bounds.upper - bounds.lower + 1;
        List<T> fetched = this.getter.fetch(bounds.lower, count);
        int i = 0;
        while (i < fetched.size()) {
            this.resources.set(bounds.lower + i, (ICICSObject)fetched.get(i));
            ++i;
        }
        DEBUG.exit("getData");
    }

    public ICICSType<T> getCICSType() {
        return this.getter.getCICSType();
    }

    public String getDescription() {
        return this.description;
    }

    public int getSize() {
        if (this.isActivated()) {
            return this.resources.size();
        }
        throw new IllegalStateException("Not activated");
    }

    private class FetchBounds {
        private int lower;
        private int upper;

        public FetchBounds(int lower, int count) {
            this.lower = lower;
            this.upper = lower + count - 1;
            if (!this.inBounds(lower)) {
                throw new IndexOutOfBoundsException("Index out of bounds: " + lower);
            }
            if (!this.inBounds(this.upper) || count == 0) {
                throw new IndexOutOfBoundsException("Count out of bounds: " + this.upper);
            }
            this.trimLower();
            this.trimUpper();
        }

        private void trimLower() {
            while (!this.needsFetch(this.lower) && this.lower < this.upper) {
                ++this.lower;
            }
        }

        private void trimUpper() {
            while (!this.needsFetch(this.upper) && this.upper > this.lower) {
                --this.upper;
            }
        }

        public boolean fetchRequired() {
            return this.upper >= 0 && (this.lower != this.upper || this.needsFetch(this.lower));
        }

        private boolean needsFetch(int index) {
            return this.inBounds(index) && CICSObjectListFactory.this.resources.get(index) == null;
        }

        private boolean inBounds(int index) {
            return CICSObjectListFactory.this.resources.size() > 0 && index >= 0 && index < CICSObjectListFactory.this.resources.size();
        }

        public String toString() {
            return "FetchBounds [lower=" + this.lower + ", upper=" + this.upper + ", fetchRequired()=" + this.fetchRequired() + "]";
        }
    }
}

