/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.model.AttributeValue;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.IFilterVisitor;
import com.ibm.cics.sm.comm.ContextHelper;
import com.ibm.cics.sm.comm.ICompoundFilteredContext;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IFilteredContext;
import com.ibm.cics.sm.comm.IPrimaryKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class FilterVisitor
implements IFilterVisitor {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2013, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final IContext baseContext;
    private final Stack<ICombineableContext> stack = new Stack();

    public FilterVisitor(IContext baseContext) {
        this.baseContext = baseContext;
    }

    public void or() {
        ICombineableContext operand2 = this.stack.pop();
        ICombineableContext operand1 = this.stack.pop();
        this.stack.push(operand1.or(operand2));
    }

    public void and() {
        ICombineableContext operand2 = this.stack.pop();
        ICombineableContext operand1 = this.stack.pop();
        this.stack.push(operand1.and(operand2));
    }

    public void not() {
        throw new UnsupportedOperationException();
    }

    public <T> void eq(ICICSAttribute<T> attribute, T value) {
        this.stack.push(new FilteredContext(attribute, value));
    }

    public <T> void is(ICICSAttribute<T> attribute, T value) {
        this.stack.push(new PrimaryKey(attribute, value));
    }

    public <T> void le(ICICSAttribute<T> attribute, T value) {
        throw new UnsupportedOperationException();
    }

    public <T> void lt(ICICSAttribute<T> attribute, T value) {
        throw new UnsupportedOperationException();
    }

    public <T> void ge(ICICSAttribute<T> attribute, T value) {
        throw new UnsupportedOperationException();
    }

    public <T> void gt(ICICSAttribute<T> attribute, T value) {
        throw new UnsupportedOperationException();
    }

    public <T> void ne(ICICSAttribute<T> attribute, T value) {
        throw new UnsupportedOperationException();
    }

    private CompoundFilteredContext and(CompoundFilteredContext cfc, FilteredContext fc) {
        ArrayList<FilteredContext> newContexts = new ArrayList<FilteredContext>();
        for (FilteredContext context : cfc.contexts) {
            newContexts.add(context.and(fc));
        }
        return new CompoundFilteredContext(newContexts);
    }

    private CompoundFilteredContext or(CompoundFilteredContext cfc, FilteredContext fc) {
        ArrayList<FilteredContext> contexts = new ArrayList<FilteredContext>();
        contexts.addAll(cfc.contexts);
        contexts.add(fc);
        return new CompoundFilteredContext(contexts);
    }

    public IContext getContext() {
        if (this.stack.size() == 0) {
            return this.baseContext;
        }
        if (this.stack.size() == 1) {
            return (IContext)this.stack.get(0);
        }
        throw new IllegalStateException();
    }

    private class CompoundFilteredContext
    implements ICompoundFilteredContext,
    ICombineableContext {
        private final List<FilteredContext> contexts;

        public CompoundFilteredContext(List<FilteredContext> contexts) {
            this.contexts = contexts;
        }

        public String getContext() {
            return this.getParentContext().getContext();
        }

        public IContext getParentContext() {
            return this.contexts.get(0);
        }

        public Iterator<FilteredContext> iterator() {
            return this.contexts.iterator();
        }

        @Override
        public ICombineableContext or(ICombineableContext other) {
            if (other instanceof CompoundFilteredContext) {
                return this.or((CompoundFilteredContext)other);
            }
            return this.or((FilteredContext)other);
        }

        public CompoundFilteredContext or(FilteredContext other) {
            return FilterVisitor.this.or(this, other);
        }

        public CompoundFilteredContext or(CompoundFilteredContext other) {
            ArrayList<FilteredContext> contexts = new ArrayList<FilteredContext>();
            contexts.addAll(this.contexts);
            contexts.addAll(other.contexts);
            return new CompoundFilteredContext(contexts);
        }

        public CompoundFilteredContext and(CompoundFilteredContext other) {
            ArrayList<CompoundFilteredContext> newContexts = new ArrayList<CompoundFilteredContext>();
            for (FilteredContext context : this.contexts) {
                newContexts.add(context.and(other));
            }
            Iterator iterator = newContexts.iterator();
            CompoundFilteredContext cfc = (CompoundFilteredContext)iterator.next();
            while (iterator.hasNext()) {
                cfc = cfc.or((CompoundFilteredContext)iterator.next());
            }
            return cfc;
        }

        @Override
        public ICombineableContext and(ICombineableContext other) {
            if (other instanceof CompoundFilteredContext) {
                return this.and((CompoundFilteredContext)other);
            }
            return FilterVisitor.this.and(this, (FilteredContext)other);
        }
    }

    private class FilteredContext
    implements IFilteredContext,
    ICombineableContext {
        protected final Map<String, AttributeValue<?>> attributes;

        public <T> FilteredContext(ICICSAttribute<T> attribute, T value) {
            this.attributes = new HashMap();
            this.attributes.put(attribute.getCicsName(), new AttributeValue(attribute, value));
        }

        public FilteredContext(Map<String, AttributeValue<?>> attributes) {
            this.attributes = attributes;
        }

        public IContext getParentContext() {
            return FilterVisitor.this.baseContext;
        }

        public Set<String> getAttributeNames() {
            return this.attributes.keySet();
        }

        public String getAttributeValue(String attributeName) {
            AttributeValue<?> attributeValue = this.attributes.get(attributeName);
            if (attributeValue != null) {
                return attributeValue.getExternalValue();
            }
            return null;
        }

        public String getScope() {
            return ContextHelper.findScope((IContext)FilterVisitor.this.baseContext);
        }

        public String getContext() {
            return FilterVisitor.this.baseContext.getContext();
        }

        public FilteredContext and(FilteredContext other) {
            if (other instanceof PrimaryKey) {
                throw new IllegalArgumentException();
            }
            HashMap attributes = new HashMap();
            attributes.putAll(this.attributes);
            attributes.putAll(other.attributes);
            return new FilteredContext(attributes);
        }

        public CompoundFilteredContext and(CompoundFilteredContext other) {
            return FilterVisitor.this.and(other, this);
        }

        @Override
        public ICombineableContext and(ICombineableContext other) {
            if (other instanceof FilteredContext) {
                return this.and((FilteredContext)other);
            }
            return this.and((CompoundFilteredContext)other);
        }

        @Override
        public ICombineableContext or(ICombineableContext other) {
            if (other instanceof CompoundFilteredContext) {
                return FilterVisitor.this.or((CompoundFilteredContext)other, this);
            }
            ArrayList<FilteredContext> contexts = new ArrayList<FilteredContext>();
            contexts.add(this);
            contexts.add((FilteredContext)other);
            return new CompoundFilteredContext(contexts);
        }

        public String toString() {
            return "context[" + this.getParentContext() + "] attributes[" + this.attributes.values().toString() + "]";
        }
    }

    private static interface ICombineableContext
    extends IContext {
        public ICombineableContext and(ICombineableContext var1);

        public ICombineableContext or(ICombineableContext var1);
    }

    private class PrimaryKey
    extends FilteredContext
    implements IPrimaryKey {
        public PrimaryKey(Map<String, AttributeValue<?>> attributes) {
            super(attributes);
        }

        public <T> PrimaryKey(ICICSAttribute<T> attribute, T value) {
            super(attribute, value);
        }

        @Override
        public PrimaryKey and(FilteredContext other) {
            if (!(other instanceof PrimaryKey)) {
                throw new IllegalArgumentException();
            }
            HashMap attributes = new HashMap();
            attributes.putAll(this.attributes);
            attributes.putAll(other.attributes);
            return new PrimaryKey(attributes);
        }

        public boolean matches(IPrimaryKey other) {
            return false;
        }
    }
}

