/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.WLPServiceReference;
import com.ibm.cics.core.model.WLPServiceType;
import com.ibm.cics.core.model.internal.MutableCICSResource;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.IWLPService;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableWLPService;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;

public class MutableWLPService
extends MutableCICSResource
implements IMutableWLPService {
    private IWLPService delegate;
    private MutableSMRecord record;

    public MutableWLPService(ICPSM cpsm, IContext context, IWLPService cicsObject) {
        super(cpsm, context, (ICICSResource)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("WLPSERV");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    public Long getServiceId() {
        return this.delegate.getServiceId();
    }

    public IWLPService.ServiceStatusValue getServiceStatus() {
        return this.delegate.getServiceStatus();
    }

    public String getJvmServer() {
        return this.delegate.getJvmServer();
    }

    public String getBundle() {
        return this.delegate.getBundle();
    }

    public String getBundlePart() {
        return this.delegate.getBundlePart();
    }

    public String getApplication() {
        return this.delegate.getApplication();
    }

    public String getJavaClass() {
        return this.delegate.getJavaClass();
    }

    public String getServiceName() {
        return this.delegate.getServiceName();
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == WLPServiceType.SERVICE_ID) {
            return (V)this.getServiceId();
        }
        if (attribute == WLPServiceType.SERVICE_STATUS) {
            return (V)this.getServiceStatus();
        }
        if (attribute == WLPServiceType.JVM_SERVER) {
            return (V)this.getJvmServer();
        }
        if (attribute == WLPServiceType.BUNDLE) {
            return (V)this.getBundle();
        }
        if (attribute == WLPServiceType.BUNDLE_PART) {
            return (V)this.getBundlePart();
        }
        if (attribute == WLPServiceType.APPLICATION) {
            return (V)this.getApplication();
        }
        if (attribute == WLPServiceType.JAVA_CLASS) {
            return (V)this.getJavaClass();
        }
        if (attribute == WLPServiceType.SERVICE_NAME) {
            return (V)this.getServiceName();
        }
        return super.getAttributeValue(attribute);
    }

    public WLPServiceType getObjectType() {
        return WLPServiceType.getInstance();
    }

    @Override
    public WLPServiceReference getCICSObjectReference() {
        return new WLPServiceReference(this.getCICSContainer(), this.getServiceId(), this.getJvmServer());
    }
}

