/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.WLPServiceReference;
import com.ibm.cics.core.model.WLPServiceType;
import com.ibm.cics.core.model.internal.CICSResource;
import com.ibm.cics.model.IWLPService;
import com.ibm.cics.model.IllegalCICSAttributeException;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Map;

public class WLPService
extends CICSResource
implements IWLPService {
    private Long _wlpservice;
    private IWLPService.ServiceStatusValue _srvcstatus;
    private String _jvmserver;
    private String _bundle;
    private String _bundlepart;
    private String _wlpappl;
    private String _wlpclass;
    private String _srvcname;

    public WLPService(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("WLPSERVICE");
        this._wlpservice = (Long)((CICSAttribute)WLPServiceType.SERVICE_ID).get(stringValue, normalizers);
        stringValue = record.get("SRVCSTATUS");
        this._srvcstatus = (IWLPService.ServiceStatusValue)((CICSAttribute)WLPServiceType.SERVICE_STATUS).get(stringValue, normalizers);
        stringValue = record.get("JVMSERVER");
        this._jvmserver = (String)((CICSAttribute)WLPServiceType.JVM_SERVER).get(stringValue, normalizers);
        stringValue = record.get("BUNDLE");
        this._bundle = (String)((CICSAttribute)WLPServiceType.BUNDLE).get(stringValue, normalizers);
        stringValue = record.get("BUNDLEPART");
        this._bundlepart = (String)((CICSAttribute)WLPServiceType.BUNDLE_PART).get(stringValue, normalizers);
        stringValue = record.get("WLPAPPL");
        this._wlpappl = (String)((CICSAttribute)WLPServiceType.APPLICATION).get(stringValue, normalizers);
        stringValue = record.get("WLPCLASS");
        this._wlpclass = (String)((CICSAttribute)WLPServiceType.JAVA_CLASS).get(stringValue, normalizers);
        stringValue = record.get("SRVCNAME");
        this._srvcname = (String)((CICSAttribute)WLPServiceType.SERVICE_NAME).get(stringValue, normalizers);
    }

    public final String getName() {
        try {
            return WLPServiceType.SERVICE_NAME.internalToExternal((Object)this.getServiceName());
        }
        catch (IllegalCICSAttributeException illegalCICSAttributeException) {
            return "";
        }
    }

    public Long getServiceId() {
        return this._wlpservice;
    }

    public IWLPService.ServiceStatusValue getServiceStatus() {
        return this._srvcstatus;
    }

    public String getJvmServer() {
        return this._jvmserver;
    }

    public String getBundle() {
        return this._bundle;
    }

    public String getBundlePart() {
        return this._bundlepart;
    }

    public String getApplication() {
        return this._wlpappl;
    }

    public String getJavaClass() {
        return this._wlpclass;
    }

    public String getServiceName() {
        return this._srvcname;
    }

    public WLPServiceType getObjectType() {
        return WLPServiceType.getInstance();
    }

    @Override
    public WLPServiceReference getCICSObjectReference() {
        return new WLPServiceReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == WLPServiceType.SERVICE_ID) {
            return (V)this.getServiceId();
        }
        if (attribute == WLPServiceType.SERVICE_STATUS) {
            return (V)this.getServiceStatus();
        }
        if (attribute == WLPServiceType.JVM_SERVER) {
            return (V)this.getJvmServer();
        }
        if (attribute == WLPServiceType.BUNDLE) {
            return (V)this.getBundle();
        }
        if (attribute == WLPServiceType.BUNDLE_PART) {
            return (V)this.getBundlePart();
        }
        if (attribute == WLPServiceType.APPLICATION) {
            return (V)this.getApplication();
        }
        if (attribute == WLPServiceType.JAVA_CLASS) {
            return (V)this.getJavaClass();
        }
        if (attribute == WLPServiceType.SERVICE_NAME) {
            return (V)this.getServiceName();
        }
        V value = super.getAttributeValue(attribute);
        if (value != null) {
            return value;
        }
        throw new IllegalArgumentException("Supplied attribute \"" + attribute + "\" was not a valid attribute for type " + WLPServiceType.getInstance());
    }
}

