/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.actions;

import com.ibm.cics.model.ICICSObject;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;

public class ActionToCommandHelper {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static boolean isSelectionOneItemOnly() {
        IStructuredSelection selection = ActionToCommandHelper.getSelection();
        return selection != null && selection.size() == 1;
    }

    public static IStructuredSelection getSelection() {
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        Object activeMenuSelection = handlerService.getCurrentState().getVariable("activeMenuSelection");
        return activeMenuSelection instanceof IStructuredSelection ? (IStructuredSelection)activeMenuSelection : null;
    }

    public static boolean isEnabled(Map<String, String> variablesToValidValues) {
        IStructuredSelection selection = ActionToCommandHelper.getSelection();
        if (selection != null && !selection.isEmpty()) {
            boolean enabled = true;
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object next = objectArray[n2];
                if (next instanceof ICICSObject) {
                    boolean anyVariablesTrue = false;
                    for (Map.Entry<String, String> entry : variablesToValidValues.entrySet()) {
                        anyVariablesTrue |= ActionToCommandHelper.testActionFilterAttribute((ICICSObject)next, entry.getKey(), entry.getValue());
                    }
                    enabled = enabled && anyVariablesTrue;
                }
                ++n2;
            }
            return enabled;
        }
        return false;
    }

    public static boolean testActionFilterAttribute(ICICSObject object, String name, String value) {
        IActionFilter adapter = (IActionFilter)Platform.getAdapterManager().getAdapter((Object)object, IActionFilter.class);
        return adapter.testAttribute((Object)object, name, value);
    }
}

