/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.breadcrumb;

import com.ibm.cics.core.model.WorkloadType;
import com.ibm.cics.core.ui.Messages;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.breadcrumb.CICSplexNode;
import com.ibm.cics.core.ui.breadcrumb.IBreadcrumbNode;
import com.ibm.cics.model.ICICSObject;
import org.eclipse.swt.graphics.Image;

public class WorkloadNode
implements IBreadcrumbNode {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final CICSplexNode cicsPlex;
    private final String workloadName;

    public WorkloadNode(ICICSObject object, String workloadName) {
        this.workloadName = workloadName;
        this.cicsPlex = CICSplexNode.createFor(object);
    }

    @Override
    public Image getImage() {
        return UIPlugin.getTableImage(WorkloadType.getInstance().getResourceTableName());
    }

    @Override
    public String getText() {
        return this.workloadName;
    }

    @Override
    public String getTooltipText() {
        return Messages.getTableDescription(WorkloadType.getInstance().getResourceTableName());
    }

    public CICSplexNode getCICSplexNode() {
        return this.cicsPlex;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.cicsPlex == null ? 0 : this.cicsPlex.hashCode());
        result = 31 * result + (this.workloadName == null ? 0 : this.workloadName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WorkloadNode other = (WorkloadNode)obj;
        if (this.cicsPlex == null ? other.cicsPlex != null : !this.cicsPlex.equals(other.cicsPlex)) {
            return false;
        }
        return !(this.workloadName == null ? other.workloadName != null : !this.workloadName.equals(other.workloadName));
    }
}

