/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.views;

import com.ibm.cics.core.comm.IConnectable;
import com.ibm.cics.core.ui.Debug;
import com.ibm.cics.core.ui.PluginConstants;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.actions.NewDefinitionWizardDropdownAction;
import com.ibm.cics.core.ui.adapters.CICSSystemsTreeAdapter;
import com.ibm.cics.core.ui.adapters.WorkbenchAdapterFactory;
import com.ibm.cics.core.ui.views.AbstractResourcesTreeView;
import com.ibm.cics.core.ui.views.Messages;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSRegionDefinition;
import com.ibm.cics.model.ICICSplex;
import com.ibm.cics.model.IManagedRegion;
import com.ibm.cics.model.ui.ICICSWorkbenchActionConstants;
import java.util.logging.Logger;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;

public class CICSplexView
extends AbstractResourcesTreeView {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String initialMasNameToFocusOn;
    private String initialCICSPlexName;
    private ITreeViewerListener expansionListener = null;
    private JobChangeAdapter expansionCompleteListener = null;
    private AbstractResourcesTreeView.ExplorerDeferredTreeContentProvider contentProvider;
    private static final Logger logger = Logger.getLogger(UIPlugin.class.getPackage().getName());
    private static final int SYSTEMS_EXPAND_LIMIT = 30;
    public static final String ID = "com.ibm.cics.core.ui.view.cicsplexes";

    @Override
    protected void fillContextMenu(IMenuManager aMenuManager) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 1 && this.showNewMenuForSelection(selection.getFirstElement())) {
            NewDefinitionWizardDropdownAction action = new NewDefinitionWizardDropdownAction();
            boolean enabled = UIPlugin.getDefault().getConnectionContextManager().canCreateCICSDefinition();
            action.setEnabled(enabled);
            aMenuManager.add((IAction)action);
        }
        for (String separatorName : ICICSWorkbenchActionConstants.getMenuSeparatorNames()) {
            aMenuManager.add((IContributionItem)new Separator(separatorName));
        }
    }

    private boolean showNewMenuForSelection(Object selection) {
        return selection instanceof IManagedRegion || selection instanceof ICICSRegionDefinition || selection instanceof ICICSplex;
    }

    @Override
    protected void accessibilitySelectionHandling(AccessibleEvent e, Object selected) {
        if (selected != null && selected instanceof IManagedRegion) {
            e.result = String.valueOf(((IManagedRegion)selected).getName()) + " " + (((IManagedRegion)selected).getState().equals((Object)IManagedRegion.StateValue.ACTIVE) ? Messages.getString("ResourcesView.status.active", new Object[0]) : Messages.getString("ResourcesView.status.inactive", new Object[0]));
        } else if (selected != null && selected instanceof ICICSplex) {
            e.result = ((ICICSplex)selected).getName();
        }
    }

    @Override
    protected void connected(IConnectable cpsm) {
        if (Debug.DEBUG_CONNECTION) {
            Debug.enter((Logger)logger, (String)CICSplexView.class.getName(), (String)"connected", (Object)("cpsm=" + cpsm));
        }
        super.connected(cpsm);
        this.addExpansionListeners();
        this.contentProvider = (AbstractResourcesTreeView.ExplorerDeferredTreeContentProvider)this.viewer.getContentProvider();
        this.contentProvider.getManager().addUpdateCompleteListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (CICSplexView.this.initialCICSPlexName != null) {
                    TreeItem[] treeItemArray = CICSplexView.this.viewer.getTree().getItems();
                    int n = treeItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem cicsPlexTreeItem = treeItemArray[n2];
                        Object data = cicsPlexTreeItem.getData();
                        if (data instanceof ICICSplex && ((ICICSplex)data).getName().equals(CICSplexView.this.initialCICSPlexName)) {
                            CICSplexView.this.initialCICSPlexName = null;
                            CICSplexView.this.viewer.getTree().select(cicsPlexTreeItem);
                            CICSplexView.this.viewer.expandToLevel(data, 2);
                            break;
                        }
                        ++n2;
                    }
                    CICSplexView.this.initialCICSPlexName = null;
                } else if (CICSplexView.this.initialMasNameToFocusOn != null && CICSplexView.this.viewer.getTree().getSelectionCount() == 1) {
                    TreeItem cicsPlexTreeItem = CICSplexView.this.viewer.getTree().getSelection()[0];
                    TreeItem[] treeItemArray = cicsPlexTreeItem.getItems();
                    int n = treeItemArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        TreeItem regionTreeItem = treeItemArray[n3];
                        Object data = regionTreeItem.getData();
                        if (data instanceof IManagedRegion && ((IManagedRegion)data).getName().equals(CICSplexView.this.initialMasNameToFocusOn)) {
                            CICSplexView.this.viewer.setSelection((ISelection)new StructuredSelection(data));
                            CICSplexView.this.initialMasNameToFocusOn = null;
                            break;
                        }
                        ++n3;
                    }
                }
            }
        });
        if (Debug.DEBUG_CONNECTION) {
            Debug.exit((Logger)logger, (String)CICSplexView.class.getName(), (String)"connected");
        }
    }

    private void addExpansionListeners() {
        this.expansionListener = new ITreeViewerListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                Object element = event.getElement();
                if (!(element instanceof ICICSplex)) {
                    return;
                }
                this.expandSystemsGroup((ICICSplex)element);
            }

            private void expandSystemsGroup(final ICICSplex element) {
                CICSplexView.this.expansionCompleteListener = new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        TreeItem[] treeItemArray = (this).CICSplexView.this.viewer.getTree().getItems();
                        int n = treeItemArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreeItem cicsPlexTreeItem = treeItemArray[n2];
                            if (cicsPlexTreeItem.getData().equals(element)) {
                                TreeItem[] children;
                                TreeItem[] treeItemArray2 = children = cicsPlexTreeItem.getItems();
                                int n3 = children.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    TreeItem child = treeItemArray2[n4];
                                    if (child.getData() instanceof CICSSystemsTreeAdapter) {
                                        ICICSObject[] systems = ((CICSSystemsTreeAdapter)child.getData()).getCICSSystems();
                                        if (systems.length > 30) break;
                                        (this).CICSplexView.this.viewer.expandToLevel(child.getData(), 2);
                                        break;
                                    }
                                    ++n4;
                                }
                                CICSplexView.this.contentProvider.getManager().removeUpdateCompleteListener((IJobChangeListener)this);
                            }
                            ++n2;
                        }
                    }
                };
                CICSplexView.this.contentProvider.getManager().addUpdateCompleteListener((IJobChangeListener)CICSplexView.this.expansionCompleteListener);
            }

            public void treeCollapsed(TreeExpansionEvent event) {
                Object element = event.getElement();
                if (!(element instanceof ICICSplex)) {
                    return;
                }
                CICSplexView.this.contentProvider.getManager().removeUpdateCompleteListener((IJobChangeListener)CICSplexView.this.expansionCompleteListener);
            }
        };
        this.viewer.addTreeListener(this.expansionListener);
    }

    private void removeExpansionListeners() {
        if (this.expansionListener != null) {
            this.viewer.removeTreeListener(this.expansionListener);
        }
        if (this.expansionCompleteListener != null) {
            AbstractResourcesTreeView.ExplorerDeferredTreeContentProvider contentProvider = (AbstractResourcesTreeView.ExplorerDeferredTreeContentProvider)this.viewer.getContentProvider();
            contentProvider.getManager().removeUpdateCompleteListener((IJobChangeListener)this.expansionCompleteListener);
            this.expansionCompleteListener = null;
        }
    }

    @Override
    protected void disconnected(IConnectable cpms) {
        this.removeExpansionListeners();
        super.disconnected(cpms);
    }

    @Override
    protected void refresh() {
        this.removeExpansionListeners();
        super.refresh();
        this.addExpansionListeners();
    }

    @Override
    protected IDeferredWorkbenchAdapter getAdapter(Object element) {
        if (element instanceof ICICSRegionDefinition) {
            return WorkbenchAdapterFactory.childlessCicsRegionDefinitionAdapter;
        }
        return null;
    }

    public void focusOn(String aCICSPlexName, String aMasName) {
        this.initialMasNameToFocusOn = aMasName;
        this.initialCICSPlexName = aCICSPlexName;
    }

    @Override
    protected String getHelpContextID() {
        return PluginConstants.CICSPLEX_VIEW_HELP_CTX_ID;
    }
}

