/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.common.util;

import com.ibm.cics.common.util.LabelUtil;
import java.text.MessageFormat;

public class ValidationRules {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2011, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String CICS_ALLOWABLE_CHARS_1 = "A-Za-z0-9\\$@#\\./\\-_%&\u00a2\\?!:\\|\"=\u00ac,;<>";

    public static void validateCicsAllowableChars(String value) {
        int indexOfSpace = value.trim().indexOf(32);
        if (indexOfSpace != -1) {
            throw new IllegalArgumentException("Embedded spaces are not valid");
        }
        ValidationRules.validateMatchRegEx(value, CICS_ALLOWABLE_CHARS_1);
    }

    public static void validateNoEmbeddedSpaces(String value) {
        int indexOfSpace = value.trim().indexOf(32);
        if (indexOfSpace != -1) {
            throw new IllegalArgumentException("Embedded spaces are not valid");
        }
    }

    public static void validateMaxLength(String string, int maxLength) throws IllegalArgumentException {
        if (maxLength >= 0 && string.length() > maxLength) {
            throw new IllegalArgumentException(MessageFormat.format(LabelUtil.getString("ValidationRules_MaxLength"), 8));
        }
    }

    public static void validateMatchRegEx(String value, String validCharacters) {
        String validExpression = "[" + validCharacters + "]*";
        if (!value.matches(validExpression)) {
            throw new IllegalArgumentException(MessageFormat.format(LabelUtil.getString("ValidationRules_invalidCharacter"), validCharacters));
        }
    }
}

