/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.Messages;
import com.ibm.cics.model.CICSRelease;
import com.ibm.cics.model.Debug;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSAttributeValidator;
import com.ibm.cics.model.IllegalCICSAttributeException;
import java.util.logging.Level;
import org.eclipse.osgi.util.NLS;

public class CICSEnumAttribute<T extends Enum<T>>
extends CICSAttribute<T> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private T unspecifiedValue;

    CICSEnumAttribute(String propertyId, String categoryId, String cicsName, Class<T> type, ICICSAttributeValidator validator, T defaultValue, CICSRelease validFrom, CICSRelease validTo) {
        super(propertyId, categoryId, cicsName, type, validator, defaultValue, CICSEnumAttribute.getUnexpected(type), CICSEnumAttribute.getUnsupported(type), validFrom, validTo);
        try {
            this.unspecifiedValue = Enum.valueOf(type, "_UNSPECIFIED");
        }
        catch (IllegalArgumentException ex) {
            logger.logp(Level.SEVERE, this.getClass().getName(), "CICSEnumAttribute", ex.getLocalizedMessage(), ex);
        }
    }

    private static <T extends Enum<T>> T getUnexpected(Class<T> enumType) {
        try {
            return Enum.valueOf(enumType, "_UNEXPECTED");
        }
        catch (IllegalArgumentException ex) {
            logger.logp(Level.SEVERE, CICSEnumAttribute.class.getName(), "getUnexpected", ex.getLocalizedMessage(), ex);
            return null;
        }
    }

    private static <T extends Enum<T>> T getUnsupported(Class<T> enumType) {
        try {
            return Enum.valueOf(enumType, "_UNSUPPORTED");
        }
        catch (IllegalArgumentException ex) {
            logger.logp(Level.SEVERE, CICSEnumAttribute.class.getName(), "getUnsupported", ex.getLocalizedMessage(), ex);
            return null;
        }
    }

    @Override
    public String getNormalizerKey() {
        return "ENUM_NORMALIZER_KEY";
    }

    @Override
    protected String internalToExternalImpl(T modelValue) throws IllegalCICSAttributeException {
        String externalValue = ((Enum)modelValue).name();
        if (externalValue == "_UNSPECIFIED") {
            return "";
        }
        if (externalValue.startsWith("_")) {
            return externalValue.substring(1);
        }
        return externalValue;
    }

    @Override
    public T externalToInternal(String stringValue) throws IllegalCICSAttributeException {
        if ("".equals(stringValue)) {
            if (Debug.DEBUG_ATTRIBUTES) {
                Exception exc = new Exception("e2i:" + this.getCicsName() + ": <emptystring>");
                logger.logp(Level.SEVERE, this.getClass().getName(), "e2i", exc.getLocalizedMessage(), exc);
            }
            return this.unspecifiedValue;
        }
        try {
            if (Character.isDigit(stringValue.charAt(0))) {
                stringValue = "_" + stringValue;
            }
            return Enum.valueOf(this.getType(), stringValue);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalCICSAttributeException(NLS.bind((String)Messages.CICSAttribute_invalidValue, (Object[])new Object[]{stringValue, this.getType().getSimpleName()}), (ICICSAttribute)this, (Object)stringValue);
        }
    }
}

