/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.Messages;
import com.ibm.cics.model.CICSRelease;
import com.ibm.cics.model.Debug;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSAttributeConstants;
import com.ibm.cics.model.ICICSAttributeHint;
import com.ibm.cics.model.ICICSAttributeValidator;
import com.ibm.cics.model.IllegalCICSAttributeException;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.osgi.util.NLS;

public class CICSLongAttribute
extends CICSAttribute<Long> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    CICSLongAttribute(String propertyId, String categoryId, String cicsName, ICICSAttributeValidator validator, Long defaultValue, CICSRelease validFrom, CICSRelease validTo) {
        super(propertyId, categoryId, cicsName, Long.class, validator, defaultValue, ICICSAttributeConstants.UNEXPECTED_LONG, ICICSAttributeConstants.UNSUPPORTED_LONG, validFrom, validTo);
    }

    @Override
    public String getNormalizerKey() {
        return "LONG_NORMALIZER_KEY";
    }

    @Override
    protected String internalToExternalImpl(Long modelValue) throws IllegalCICSAttributeException {
        ICICSAttributeHint hint = this.getValuesHint();
        if (hint != null && hint.hasSpecialValues()) {
            for (Map.Entry specialValuePair : hint.getSpecialValues().entrySet()) {
                if (specialValuePair.getValue() != modelValue) continue;
                if (Debug.DEBUG_ATTRIBUTES) {
                    Exception exc = new Exception("internalToExternalImpl:" + this.getCicsName() + ":" + modelValue + " > " + (String)specialValuePair.getKey());
                    logger.logp(Level.SEVERE, this.getClass().getName(), "internalToExternalImpl", exc.getLocalizedMessage(), exc);
                }
                return (String)specialValuePair.getKey();
            }
        }
        return modelValue.toString();
    }

    @Override
    public Long externalToInternal(String stringValue) throws IllegalCICSAttributeException {
        Long modelValue;
        ICICSAttributeHint hint = this.getValuesHint();
        stringValue = stringValue.trim();
        if (hint != null && hint.hasSpecialValues() && (modelValue = (Long)hint.getSpecialValues().get(stringValue)) != null) {
            if (Debug.DEBUG_ATTRIBUTES) {
                Exception exc = new Exception("externalToInternal:" + this.getCicsName() + ":" + stringValue + " > " + modelValue);
                logger.logp(Level.SEVERE, this.getClass().getName(), "externalToInternal", exc.getLocalizedMessage(), exc);
            }
            return modelValue;
        }
        try {
            return Long.parseLong(stringValue);
        }
        catch (NumberFormatException numberFormatException) {
            String message = this.getValuesHint().hasSpecialValues() ? NLS.bind((String)Messages.CICSAttribute_invalidValueGeneral, (Object[])new Object[]{stringValue}) : NLS.bind((String)Messages.CICSAttribute_invalidNumber, (Object[])new Object[]{stringValue});
            throw new IllegalCICSAttributeException(message, (ICICSAttribute)this, (Object)stringValue);
        }
    }
}

