/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model;

import com.ibm.cics.common.util.UTF8HexStringParser;
import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.model.CICSRelease;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSAttributeConstants;
import com.ibm.cics.model.ICICSAttributeValidator;
import com.ibm.cics.model.IllegalCICSAttributeException;

public class CICSUTF8HexStringAttribute
extends CICSAttribute<String> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    protected CICSUTF8HexStringAttribute(String propertyId, String categoryId, String cicsName, Class<String> type, ICICSAttributeValidator<String> validator, String defaultValue, CICSRelease validFrom, CICSRelease validTo) {
        super(propertyId, categoryId, cicsName, type, validator, defaultValue, ICICSAttributeConstants.UNEXPECTED_STRING, ICICSAttributeConstants.UNSUPPORTED_STRING, validFrom, validTo);
    }

    @Override
    public String externalToInternal(String externalValue) throws IllegalCICSAttributeException {
        try {
            String internalValue = UTF8HexStringParser.hexToString((String)externalValue);
            return internalValue.replaceAll("\u0000+$", "");
        }
        catch (RuntimeException ex) {
            throw new IllegalCICSAttributeException((Exception)ex, (ICICSAttribute)this, (Object)externalValue);
        }
    }

    @Override
    public String getNormalizerKey() {
        return "HEX_NORMALIER_KEY";
    }

    @Override
    protected String internalToExternalImpl(String modelValue) throws IllegalCICSAttributeException {
        try {
            return UTF8HexStringParser.stringToHex((String)modelValue);
        }
        catch (RuntimeException ex) {
            throw new IllegalCICSAttributeException((Exception)ex, (ICICSAttribute)this, (Object)modelValue);
        }
    }
}

