/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.DB2ConnectionReference;
import com.ibm.cics.core.model.DB2ConnectionType;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.internal.MutableCICSResource;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.IDB2Connection;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableDB2Connection;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Date;

public class MutableDB2Connection
extends MutableCICSResource
implements IMutableDB2Connection {
    private IDB2Connection delegate;
    private MutableSMRecord record;

    public MutableDB2Connection(ICPSM cpsm, IContext context, IDB2Connection cicsObject) {
        super(cpsm, context, (ICICSResource)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("DB2CONN");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    public IDB2Connection.AccountrecValue getAccountrec() {
        String result = this.record.get("ACCOUNTREC");
        if (result == null) {
            return this.delegate.getAccountrec();
        }
        return (IDB2Connection.AccountrecValue)((CICSAttribute)DB2ConnectionType.ACCOUNTREC).get(result, this.record.getNormalizers());
    }

    public String getAuthid() {
        String result = this.record.get("AUTHID");
        if (result == null) {
            return this.delegate.getAuthid();
        }
        return (String)((CICSAttribute)DB2ConnectionType.AUTHID).get(result, this.record.getNormalizers());
    }

    public IDB2Connection.AuthtypeValue getAuthtype() {
        String result = this.record.get("AUTHTYPE");
        if (result == null) {
            return this.delegate.getAuthtype();
        }
        return (IDB2Connection.AuthtypeValue)((CICSAttribute)DB2ConnectionType.AUTHTYPE).get(result, this.record.getNormalizers());
    }

    public Long getComthreads() {
        return this.delegate.getComthreads();
    }

    public Long getComthreadlim() {
        String result = this.record.get("COMTHREADLIM");
        if (result == null) {
            return this.delegate.getComthreadlim();
        }
        return (Long)((CICSAttribute)DB2ConnectionType.COMTHREADLIM).get(result, this.record.getNormalizers());
    }

    public String getComauthid() {
        String result = this.record.get("COMAUTHID");
        if (result == null) {
            return this.delegate.getComauthid();
        }
        return (String)((CICSAttribute)DB2ConnectionType.COMAUTHID).get(result, this.record.getNormalizers());
    }

    public IDB2Connection.ComauthtypeValue getComauthtype() {
        String result = this.record.get("COMAUTHTYPE");
        if (result == null) {
            return this.delegate.getComauthtype();
        }
        return (IDB2Connection.ComauthtypeValue)((CICSAttribute)DB2ConnectionType.COMAUTHTYPE).get(result, this.record.getNormalizers());
    }

    public IDB2Connection.ConnecterrorValue getConnecterror() {
        String result = this.record.get("CONNECTERROR");
        if (result == null) {
            return this.delegate.getConnecterror();
        }
        return (IDB2Connection.ConnecterrorValue)((CICSAttribute)DB2ConnectionType.CONNECTERROR).get(result, this.record.getNormalizers());
    }

    public IDB2Connection.StatusValue getStatus() {
        String result = this.record.get("CONNECTST");
        if (result == null) {
            return this.delegate.getStatus();
        }
        return (IDB2Connection.StatusValue)((CICSAttribute)DB2ConnectionType.STATUS).get(result, this.record.getNormalizers());
    }

    public String getSubsystemID() {
        String result = this.record.get("DB2ID");
        if (result == null) {
            return this.delegate.getSubsystemID();
        }
        return (String)((CICSAttribute)DB2ConnectionType.SUBSYSTEM_ID).get(result, this.record.getNormalizers());
    }

    public String getRelease() {
        return this.delegate.getRelease();
    }

    public IDB2Connection.DrollbackValue getDrollback() {
        return this.delegate.getDrollback();
    }

    public String getMsgqueue1() {
        String result = this.record.get("MSGQUEUE1");
        if (result == null) {
            return this.delegate.getMsgqueue1();
        }
        return (String)((CICSAttribute)DB2ConnectionType.MSGQUEUE_1).get(result, this.record.getNormalizers());
    }

    public String getMsgqueue2() {
        String result = this.record.get("MSGQUEUE2");
        if (result == null) {
            return this.delegate.getMsgqueue2();
        }
        return (String)((CICSAttribute)DB2ConnectionType.MSGQUEUE_2).get(result, this.record.getNormalizers());
    }

    public String getMsgqueue3() {
        String result = this.record.get("MSGQUEUE3");
        if (result == null) {
            return this.delegate.getMsgqueue3();
        }
        return (String)((CICSAttribute)DB2ConnectionType.MSGQUEUE_3).get(result, this.record.getNormalizers());
    }

    public IDB2Connection.NontermrelValue getNontermrel() {
        String result = this.record.get("NONTERMREL");
        if (result == null) {
            return this.delegate.getNontermrel();
        }
        return (IDB2Connection.NontermrelValue)((CICSAttribute)DB2ConnectionType.NONTERMREL).get(result, this.record.getNormalizers());
    }

    public String getPlan() {
        String result = this.record.get("PLAN");
        if (result == null) {
            return this.delegate.getPlan();
        }
        return (String)((CICSAttribute)DB2ConnectionType.PLAN).get(result, this.record.getNormalizers());
    }

    public String getPlanexitname() {
        String result = this.record.get("PLANEXITNAME");
        if (result == null) {
            return this.delegate.getPlanexitname();
        }
        return (String)((CICSAttribute)DB2ConnectionType.PLANEXITNAME).get(result, this.record.getNormalizers());
    }

    public IDB2Connection.PriorityValue getPriority() {
        String result = this.record.get("PRIORITY");
        if (result == null) {
            return this.delegate.getPriority();
        }
        return (IDB2Connection.PriorityValue)((CICSAttribute)DB2ConnectionType.PRIORITY).get(result, this.record.getNormalizers());
    }

    public Long getPurgecyclem() {
        String result = this.record.get("PURGECYCLEM");
        if (result == null) {
            return this.delegate.getPurgecyclem();
        }
        return (Long)((CICSAttribute)DB2ConnectionType.PURGECYCLEM).get(result, this.record.getNormalizers());
    }

    public Long getPurgecycles() {
        String result = this.record.get("PURGECYCLES");
        if (result == null) {
            return this.delegate.getPurgecycles();
        }
        return (Long)((CICSAttribute)DB2ConnectionType.PURGECYCLES).get(result, this.record.getNormalizers());
    }

    public String getSignid() {
        String result = this.record.get("SIGNID");
        if (result == null) {
            return this.delegate.getSignid();
        }
        return (String)((CICSAttribute)DB2ConnectionType.SIGNID).get(result, this.record.getNormalizers());
    }

    public String getStatsqueue() {
        String result = this.record.get("STATSQUEUE");
        if (result == null) {
            return this.delegate.getStatsqueue();
        }
        return (String)((CICSAttribute)DB2ConnectionType.STATSQUEUE).get(result, this.record.getNormalizers());
    }

    public Long getCurrentTCBs() {
        return this.delegate.getCurrentTCBs();
    }

    public Long getTCBLimit() {
        String result = this.record.get("TCBLIMIT");
        if (result == null) {
            return this.delegate.getTCBLimit();
        }
        return (Long)((CICSAttribute)DB2ConnectionType.TCB_LIMIT).get(result, this.record.getNormalizers());
    }

    public IDB2Connection.ThreaderrorValue getThreaderror() {
        return this.delegate.getThreaderror();
    }

    public IDB2Connection.ThreadwaitValue getThreadwait() {
        String result = this.record.get("THREADWAIT");
        if (result == null) {
            return this.delegate.getThreadwait();
        }
        return (IDB2Connection.ThreadwaitValue)((CICSAttribute)DB2ConnectionType.THREADWAIT).get(result, this.record.getNormalizers());
    }

    public Long getThreadlimit() {
        String result = this.record.get("THREADLIMIT");
        if (result == null) {
            return this.delegate.getThreadlimit();
        }
        return (Long)((CICSAttribute)DB2ConnectionType.THREADLIMIT).get(result, this.record.getNormalizers());
    }

    public Long getThreads() {
        return this.delegate.getThreads();
    }

    public IDB2Connection.StandbymodeValue getStandbymode() {
        String result = this.record.get("STANDBYMODE");
        if (result == null) {
            return this.delegate.getStandbymode();
        }
        return (IDB2Connection.StandbymodeValue)((CICSAttribute)DB2ConnectionType.STANDBYMODE).get(result, this.record.getNormalizers());
    }

    public String getCtimegmt() {
        return this.delegate.getCtimegmt();
    }

    public String getCtimeloc() {
        return this.delegate.getCtimeloc();
    }

    public String getDtimegmt() {
        return this.delegate.getDtimegmt();
    }

    public String getDtimeloc() {
        return this.delegate.getDtimeloc();
    }

    public Long getTlimit() {
        return this.delegate.getTlimit();
    }

    public Long getThwm() {
        return this.delegate.getThwm();
    }

    public Long getTcurr() {
        return this.delegate.getTcurr();
    }

    public Long getPcalls() {
        return this.delegate.getPcalls();
    }

    public Long getPsignons() {
        return this.delegate.getPsignons();
    }

    public Long getPcommits() {
        return this.delegate.getPcommits();
    }

    public Long getPaborts() {
        return this.delegate.getPaborts();
    }

    public Long getPsphase() {
        return this.delegate.getPsphase();
    }

    public Long getPtreuse() {
        return this.delegate.getPtreuse();
    }

    public Long getPtterm() {
        return this.delegate.getPtterm();
    }

    public Long getPtwait() {
        return this.delegate.getPtwait();
    }

    public Long getPtlimit() {
        return this.delegate.getPtlimit();
    }

    public Long getPtcurr() {
        return this.delegate.getPtcurr();
    }

    public Long getPthwm() {
        return this.delegate.getPthwm();
    }

    public Long getPxcurr() {
        return this.delegate.getPxcurr();
    }

    public Long getPxhwm() {
        return this.delegate.getPxhwm();
    }

    public Long getPxtotal() {
        return this.delegate.getPxtotal();
    }

    public Long getPrqcur() {
        return this.delegate.getPrqcur();
    }

    public Long getPrqhwm() {
        return this.delegate.getPrqhwm();
    }

    public Long getCcalls() {
        return this.delegate.getCcalls();
    }

    public Long getCsignons() {
        return this.delegate.getCsignons();
    }

    public Long getCtterm() {
        return this.delegate.getCtterm();
    }

    public Long getCtoverf() {
        return this.delegate.getCtoverf();
    }

    public Long getCtlimit() {
        return this.delegate.getCtlimit();
    }

    public Long getCtcurr() {
        return this.delegate.getCtcurr();
    }

    public Long getTcbfree() {
        return this.delegate.getTcbfree();
    }

    public Long getCthwm() {
        return this.delegate.getCthwm();
    }

    public Long getTcbrdyqcurr() {
        return this.delegate.getTcbrdyqcurr();
    }

    public Long getTcbrdyqhwm() {
        return this.delegate.getTcbrdyqhwm();
    }

    public String getDataSharingGroupID() {
        String result = this.record.get("DB2GROUPID");
        if (result == null) {
            return this.delegate.getDataSharingGroupID();
        }
        return (String)((CICSAttribute)DB2ConnectionType.DATA_SHARING_GROUP_ID).get(result, this.record.getNormalizers());
    }

    public IDB2Connection.ResyncmemberValue getResyncmember() {
        String result = this.record.get("RESYNCMEMBER");
        if (result == null) {
            return this.delegate.getResyncmember();
        }
        return (IDB2Connection.ResyncmemberValue)((CICSAttribute)DB2ConnectionType.RESYNCMEMBER).get(result, this.record.getNormalizers());
    }

    public String getChangeUserID() {
        return this.delegate.getChangeUserID();
    }

    public IDB2Connection.ChangeAgentValue getChangeAgent() {
        return this.delegate.getChangeAgent();
    }

    public String getChangeAgentRelease() {
        return this.delegate.getChangeAgentRelease();
    }

    public IDB2Connection.InstallAgentValue getInstallAgent() {
        return this.delegate.getInstallAgent();
    }

    public Date getChangeTime() {
        return this.delegate.getChangeTime();
    }

    public String getDefineSource() {
        return this.delegate.getDefineSource();
    }

    public Date getDefineTime() {
        return this.delegate.getDefineTime();
    }

    public String getInstallUserID() {
        return this.delegate.getInstallUserID();
    }

    public Date getInstallTime() {
        return this.delegate.getInstallTime();
    }

    public Long getBasdefinever() {
        return this.delegate.getBasdefinever();
    }

    public Long getReuselimit() {
        String result = this.record.get("REUSELIMIT");
        if (result == null) {
            return this.delegate.getReuselimit();
        }
        return (Long)((CICSAttribute)DB2ConnectionType.REUSELIMIT).get(result, this.record.getNormalizers());
    }

    public Long getPreuselimct() {
        return this.delegate.getPreuselimct();
    }

    public void setAccountrec(IDB2Connection.AccountrecValue _accountrec) {
        if (_accountrec.equals((Object)this.delegate.getAccountrec())) {
            this.record.set("ACCOUNTREC", null);
        } else {
            DB2ConnectionType.ACCOUNTREC.validate((Object)_accountrec);
            String connectionSpecificExternalValue = ((CICSAttribute)DB2ConnectionType.ACCOUNTREC).set(_accountrec, this.record.getNormalizers());
            this.record.set("ACCOUNTREC", connectionSpecificExternalValue);
        }
    }

    public void setAuthid(String _authid) {
        if (_authid.equals(this.delegate.getAuthid())) {
            this.record.set("AUTHID", null);
        } else {
            DB2ConnectionType.AUTHID.validate((Object)_authid);
            String connectionSpecificExternalValue = ((CICSAttribute)DB2ConnectionType.AUTHID).set(_authid, this.record.getNormalizers());
            this.record.set("AUTHID", connectionSpecificExternalValue);
        }
    }

    public void setAuthtype(IDB2Connection.AuthtypeValue _authtype) {
        if (_authtype.equals((Object)this.delegate.getAuthtype())) {
            this.record.set("AUTHTYPE", null);
        } else {
            DB2ConnectionType.AUTHTYPE.validate((Object)_authtype);
            String connectionSpecificExternalValue = ((CICSAttribute)DB2ConnectionType.AUTHTYPE).set(_authtype, this.record.getNormalizers());
            this.record.set("AUTHTYPE", connectionSpecificExternalValue);
        }
    }

    public void setComthreadlim(Long _comthreadlim) {
        if (_comthreadlim.equals(this.delegate.getComthreadlim())) {
            this.record.set("COMTHREADLIM", null);
        } else {
            DB2ConnectionType.COMTHREADLIM.validate((Object)_comthreadlim);
            String connectionSpecificExternalValue = ((CICSAttribute)DB2ConnectionType.COMTHREADLIM).set(_comthreadlim, this.record.getNormalizers());
            this.record.set("COMTHREADLIM", connectionSpecificExternalValue);
        }
    }

    public void setComauthid(String _comauthid) {
        if (_comauthid.equals(this.delegate.getComauthid())) {
            this.record.set("COMAUTHID", null);
        } else {
            DB2ConnectionType.COMAUTHID.validate((Object)_comauthid);
            String connectionSpecificExternalValue = ((CICSAttribute)DB2ConnectionType.COMAUTHID).set(_comauthid, this.record.getNormalizers());
            this.record.set("COMAUTHID", connectionSpecificExternalValue);
        }
    }

    public void setComauthtype(IDB2Connection.ComauthtypeValue _comauthtype) {
        if (_comauthtype.equals((Object)this.delegate.getComauthtype())) {
            this.record.set("COMAUTHTYPE", null);
        } else {
            DB2ConnectionType.COMAUTHTYPE.validate((Object)_comauthtype);
            String connectionSpecificExternalValue = ((CICSAttribute)DB2ConnectionType.COMAUTHTYPE).set(_comauthtype, this.record.getNormalizers());
            this.record.set("COMAUTHTYPE", connectionSpecificExternalValue);
        }
    }

    public void setConnecterror(IDB2Connection.ConnecterrorValue _connecterror) {
        if (_connecterror.equals((Object)this.delegate.getConnecterror())) {
            this.record.set("CONNECTERROR", null);
        } else {
            DB2ConnectionType.CONNECTERROR.validate((Object)_connecterror);
            String connectionSpecificExternalValue = ((CICSAttribute)DB2ConnectionType.CONNECTERROR).set(_connecterror, this.record.getNormalizers());
            this.record.set("CONNECTERROR", connectionSpecificExternalValue);
        }
    }

    public void setStatus(IDB2Connection.StatusValue _status) {
        if (_status.equals((Object)this.delegate.getStatus())) {
            this.record.set("CONNECTST", null);
        } else {
            DB2ConnectionType.STATUS.validate((Object)_status);
            String connectionSpecificExternalValue = ((CICSAttribute)DB2ConnectionType.STATUS).set(_status, this.record.getNormalizers());
            this.record.set("CONNECTST", connectionSpecificExternalValue);
        }
    }

    public void setSubsystemID(String _subsystemID) {
        if (_subsystemID.equals(this.delegate.getSubsystemID())) {
            this.record.set("DB2ID", null);
        } else {
            DB2ConnectionType.SUBSYSTEM_ID.validate((Object)_subsystemID);
            String connectionSpecificExternalValue = ((CICSAttribute)DB2ConnectionType.SUBSYSTEM_ID).set(_subsystemID, this.record.getNormalizers());
            this.record.set("DB2ID", connectionSpecificExternalValue);
        }
    }

    public void setMsgqueue1(String _msgqueue1) {
        if (_msgqueue1.equals(this.delegate.getMsgqueue1())) {
            this.record.set("MSGQUEUE1", null);
        } else {
            DB2ConnectionType.MSGQUEUE_1.validate((Object)_msgqueue1);
            String connectionSpecificExternalValue = ((CICSAttribute)DB2ConnectionType.MSGQUEUE_1).set(_msgqueue1, this.record.getNormalizers());
            this.record.set("MSGQUEUE1", connectionSpecificExternalValue);
        }
    }

    public void setMsgqueue2(String _msgqueue2) {
        if (_msgqueue2.equals(this.delegate.getMsgqueue2())) {
            this.record.set("MSGQUEUE2", null);
        } else {
            DB2ConnectionType.MSGQUEUE_2.validate((Object)_msgqueue2);
            String connectionSpecificExternalValue = ((CICSAttribute)DB2ConnectionType.MSGQUEUE_2).set(_msgqueue2, this.record.getNormalizers());
            this.record.set("MSGQUEUE2", connectionSpecificExternalValue);
        }
    }

    public void setMsgqueue3(String _msgqueue3) {
        if (_msgqueue3.equals(this.delegate.getMsgqueue3())) {
            this.record.set("MSGQUEUE3", null);
        } else {
            DB2ConnectionType.MSGQUEUE_3.validate((Object)_msgqueue3);
            String connectionSpecificExternalValue = ((CICSAttribute)DB2ConnectionType.MSGQUEUE_3).set(_msgqueue3, this.record.getNormalizers());
            this.record.set("MSGQUEUE3", connectionSpecificExternalValue);
        }
    }

    public void setNontermrel(IDB2Connection.NontermrelValue _nontermrel) {
        if (_nontermrel.equals((Object)this.delegate.getNontermrel())) {
            this.record.set("NONTERMREL", null);
        } else {
            DB2ConnectionType.NONTERMREL.validate((Object)_nontermrel);
            String connectionSpecificExternalValue = ((CICSAttribute)DB2ConnectionType.NONTERMREL).set(_nontermrel, this.record.getNormalizers());
            this.record.set("NONTERMREL", connectionSpecificExternalValue);
        }
    }

    public void setPlan(String _plan) {
        if (_plan.equals(this.delegate.getPlan())) {
            this.record.set("PLAN", null);
        } else {
            DB2ConnectionType.PLAN.validate((Object)_plan);
            String connectionSpecificExternalValue = ((CICSAttribute)DB2ConnectionType.PLAN).set(_plan, this.record.getNormalizers());
            this.record.set("PLAN", connectionSpecificExternalValue);
        }
    }

    public void setPlanexitname(String _planexitname) {
        if (_planexitname.equals(this.delegate.getPlanexitname())) {
            this.record.set("PLANEXITNAME", null);
        } else {
            DB2ConnectionType.PLANEXITNAME.validate((Object)_planexitname);
            String connectionSpecificExternalValue = ((CICSAttribute)DB2ConnectionType.PLANEXITNAME).set(_planexitname, this.record.getNormalizers());
            this.record.set("PLANEXITNAME", connectionSpecificExternalValue);
        }
    }

    public void setPriority(IDB2Connection.PriorityValue _priority) {
        if (_priority.equals((Object)this.delegate.getPriority())) {
            this.record.set("PRIORITY", null);
        } else {
            DB2ConnectionType.PRIORITY.validate((Object)_priority);
            String connectionSpecificExternalValue = ((CICSAttribute)DB2ConnectionType.PRIORITY).set(_priority, this.record.getNormalizers());
            this.record.set("PRIORITY", connectionSpecificExternalValue);
        }
    }

    public void setPurgecyclem(Long _purgecyclem) {
        if (_purgecyclem.equals(this.delegate.getPurgecyclem())) {
            this.record.set("PURGECYCLEM", null);
        } else {
            DB2ConnectionType.PURGECYCLEM.validate((Object)_purgecyclem);
            String connectionSpecificExternalValue = ((CICSAttribute)DB2ConnectionType.PURGECYCLEM).set(_purgecyclem, this.record.getNormalizers());
            this.record.set("PURGECYCLEM", connectionSpecificExternalValue);
        }
    }

    public void setPurgecycles(Long _purgecycles) {
        if (_purgecycles.equals(this.delegate.getPurgecycles())) {
            this.record.set("PURGECYCLES", null);
        } else {
            DB2ConnectionType.PURGECYCLES.validate((Object)_purgecycles);
            String connectionSpecificExternalValue = ((CICSAttribute)DB2ConnectionType.PURGECYCLES).set(_purgecycles, this.record.getNormalizers());
            this.record.set("PURGECYCLES", connectionSpecificExternalValue);
        }
    }

    public void setSignid(String _signid) {
        if (_signid.equals(this.delegate.getSignid())) {
            this.record.set("SIGNID", null);
        } else {
            DB2ConnectionType.SIGNID.validate((Object)_signid);
            String connectionSpecificExternalValue = ((CICSAttribute)DB2ConnectionType.SIGNID).set(_signid, this.record.getNormalizers());
            this.record.set("SIGNID", connectionSpecificExternalValue);
        }
    }

    public void setStatsqueue(String _statsqueue) {
        if (_statsqueue.equals(this.delegate.getStatsqueue())) {
            this.record.set("STATSQUEUE", null);
        } else {
            DB2ConnectionType.STATSQUEUE.validate((Object)_statsqueue);
            String connectionSpecificExternalValue = ((CICSAttribute)DB2ConnectionType.STATSQUEUE).set(_statsqueue, this.record.getNormalizers());
            this.record.set("STATSQUEUE", connectionSpecificExternalValue);
        }
    }

    public void setTCBLimit(Long _TCBLimit) {
        if (_TCBLimit.equals(this.delegate.getTCBLimit())) {
            this.record.set("TCBLIMIT", null);
        } else {
            DB2ConnectionType.TCB_LIMIT.validate((Object)_TCBLimit);
            String connectionSpecificExternalValue = ((CICSAttribute)DB2ConnectionType.TCB_LIMIT).set(_TCBLimit, this.record.getNormalizers());
            this.record.set("TCBLIMIT", connectionSpecificExternalValue);
        }
    }

    public void setThreadwait(IDB2Connection.ThreadwaitValue _threadwait) {
        if (_threadwait.equals((Object)this.delegate.getThreadwait())) {
            this.record.set("THREADWAIT", null);
        } else {
            DB2ConnectionType.THREADWAIT.validate((Object)_threadwait);
            String connectionSpecificExternalValue = ((CICSAttribute)DB2ConnectionType.THREADWAIT).set(_threadwait, this.record.getNormalizers());
            this.record.set("THREADWAIT", connectionSpecificExternalValue);
        }
    }

    public void setThreadlimit(Long _threadlimit) {
        if (_threadlimit.equals(this.delegate.getThreadlimit())) {
            this.record.set("THREADLIMIT", null);
        } else {
            DB2ConnectionType.THREADLIMIT.validate((Object)_threadlimit);
            String connectionSpecificExternalValue = ((CICSAttribute)DB2ConnectionType.THREADLIMIT).set(_threadlimit, this.record.getNormalizers());
            this.record.set("THREADLIMIT", connectionSpecificExternalValue);
        }
    }

    public void setStandbymode(IDB2Connection.StandbymodeValue _standbymode) {
        if (_standbymode.equals((Object)this.delegate.getStandbymode())) {
            this.record.set("STANDBYMODE", null);
        } else {
            DB2ConnectionType.STANDBYMODE.validate((Object)_standbymode);
            String connectionSpecificExternalValue = ((CICSAttribute)DB2ConnectionType.STANDBYMODE).set(_standbymode, this.record.getNormalizers());
            this.record.set("STANDBYMODE", connectionSpecificExternalValue);
        }
    }

    public void setDataSharingGroupID(String _dataSharingGroupID) {
        if (_dataSharingGroupID.equals(this.delegate.getDataSharingGroupID())) {
            this.record.set("DB2GROUPID", null);
        } else {
            DB2ConnectionType.DATA_SHARING_GROUP_ID.validate((Object)_dataSharingGroupID);
            String connectionSpecificExternalValue = ((CICSAttribute)DB2ConnectionType.DATA_SHARING_GROUP_ID).set(_dataSharingGroupID, this.record.getNormalizers());
            this.record.set("DB2GROUPID", connectionSpecificExternalValue);
        }
    }

    public void setResyncmember(IDB2Connection.ResyncmemberValue _resyncmember) {
        if (_resyncmember.equals((Object)this.delegate.getResyncmember())) {
            this.record.set("RESYNCMEMBER", null);
        } else {
            DB2ConnectionType.RESYNCMEMBER.validate((Object)_resyncmember);
            String connectionSpecificExternalValue = ((CICSAttribute)DB2ConnectionType.RESYNCMEMBER).set(_resyncmember, this.record.getNormalizers());
            this.record.set("RESYNCMEMBER", connectionSpecificExternalValue);
        }
    }

    public void setReuselimit(Long _reuselimit) {
        if (_reuselimit.equals(this.delegate.getReuselimit())) {
            this.record.set("REUSELIMIT", null);
        } else {
            DB2ConnectionType.REUSELIMIT.validate((Object)_reuselimit);
            String connectionSpecificExternalValue = ((CICSAttribute)DB2ConnectionType.REUSELIMIT).set(_reuselimit, this.record.getNormalizers());
            this.record.set("REUSELIMIT", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == DB2ConnectionType.NAME) {
            return (V)this.getName();
        }
        if (attribute == DB2ConnectionType.ACCOUNTREC) {
            return (V)this.getAccountrec();
        }
        if (attribute == DB2ConnectionType.AUTHID) {
            return (V)this.getAuthid();
        }
        if (attribute == DB2ConnectionType.AUTHTYPE) {
            return (V)this.getAuthtype();
        }
        if (attribute == DB2ConnectionType.COMTHREADS) {
            return (V)this.getComthreads();
        }
        if (attribute == DB2ConnectionType.COMTHREADLIM) {
            return (V)this.getComthreadlim();
        }
        if (attribute == DB2ConnectionType.COMAUTHID) {
            return (V)this.getComauthid();
        }
        if (attribute == DB2ConnectionType.COMAUTHTYPE) {
            return (V)this.getComauthtype();
        }
        if (attribute == DB2ConnectionType.CONNECTERROR) {
            return (V)this.getConnecterror();
        }
        if (attribute == DB2ConnectionType.STATUS) {
            return (V)this.getStatus();
        }
        if (attribute == DB2ConnectionType.SUBSYSTEM_ID) {
            return (V)this.getSubsystemID();
        }
        if (attribute == DB2ConnectionType.RELEASE) {
            return (V)this.getRelease();
        }
        if (attribute == DB2ConnectionType.DROLLBACK) {
            return (V)this.getDrollback();
        }
        if (attribute == DB2ConnectionType.MSGQUEUE_1) {
            return (V)this.getMsgqueue1();
        }
        if (attribute == DB2ConnectionType.MSGQUEUE_2) {
            return (V)this.getMsgqueue2();
        }
        if (attribute == DB2ConnectionType.MSGQUEUE_3) {
            return (V)this.getMsgqueue3();
        }
        if (attribute == DB2ConnectionType.NONTERMREL) {
            return (V)this.getNontermrel();
        }
        if (attribute == DB2ConnectionType.PLAN) {
            return (V)this.getPlan();
        }
        if (attribute == DB2ConnectionType.PLANEXITNAME) {
            return (V)this.getPlanexitname();
        }
        if (attribute == DB2ConnectionType.PRIORITY) {
            return (V)this.getPriority();
        }
        if (attribute == DB2ConnectionType.PURGECYCLEM) {
            return (V)this.getPurgecyclem();
        }
        if (attribute == DB2ConnectionType.PURGECYCLES) {
            return (V)this.getPurgecycles();
        }
        if (attribute == DB2ConnectionType.SIGNID) {
            return (V)this.getSignid();
        }
        if (attribute == DB2ConnectionType.STATSQUEUE) {
            return (V)this.getStatsqueue();
        }
        if (attribute == DB2ConnectionType.CURRENT_TC_BS) {
            return (V)this.getCurrentTCBs();
        }
        if (attribute == DB2ConnectionType.TCB_LIMIT) {
            return (V)this.getTCBLimit();
        }
        if (attribute == DB2ConnectionType.THREADERROR) {
            return (V)this.getThreaderror();
        }
        if (attribute == DB2ConnectionType.THREADWAIT) {
            return (V)this.getThreadwait();
        }
        if (attribute == DB2ConnectionType.THREADLIMIT) {
            return (V)this.getThreadlimit();
        }
        if (attribute == DB2ConnectionType.THREADS) {
            return (V)this.getThreads();
        }
        if (attribute == DB2ConnectionType.STANDBYMODE) {
            return (V)this.getStandbymode();
        }
        if (attribute == DB2ConnectionType.CTIMEGMT) {
            return (V)this.getCtimegmt();
        }
        if (attribute == DB2ConnectionType.CTIMELOC) {
            return (V)this.getCtimeloc();
        }
        if (attribute == DB2ConnectionType.DTIMEGMT) {
            return (V)this.getDtimegmt();
        }
        if (attribute == DB2ConnectionType.DTIMELOC) {
            return (V)this.getDtimeloc();
        }
        if (attribute == DB2ConnectionType.TLIMIT) {
            return (V)this.getTlimit();
        }
        if (attribute == DB2ConnectionType.THWM) {
            return (V)this.getThwm();
        }
        if (attribute == DB2ConnectionType.TCURR) {
            return (V)this.getTcurr();
        }
        if (attribute == DB2ConnectionType.PCALLS) {
            return (V)this.getPcalls();
        }
        if (attribute == DB2ConnectionType.PSIGNONS) {
            return (V)this.getPsignons();
        }
        if (attribute == DB2ConnectionType.PCOMMITS) {
            return (V)this.getPcommits();
        }
        if (attribute == DB2ConnectionType.PABORTS) {
            return (V)this.getPaborts();
        }
        if (attribute == DB2ConnectionType.PSPHASE) {
            return (V)this.getPsphase();
        }
        if (attribute == DB2ConnectionType.PTREUSE) {
            return (V)this.getPtreuse();
        }
        if (attribute == DB2ConnectionType.PTTERM) {
            return (V)this.getPtterm();
        }
        if (attribute == DB2ConnectionType.PTWAIT) {
            return (V)this.getPtwait();
        }
        if (attribute == DB2ConnectionType.PTLIMIT) {
            return (V)this.getPtlimit();
        }
        if (attribute == DB2ConnectionType.PTCURR) {
            return (V)this.getPtcurr();
        }
        if (attribute == DB2ConnectionType.PTHWM) {
            return (V)this.getPthwm();
        }
        if (attribute == DB2ConnectionType.PXCURR) {
            return (V)this.getPxcurr();
        }
        if (attribute == DB2ConnectionType.PXHWM) {
            return (V)this.getPxhwm();
        }
        if (attribute == DB2ConnectionType.PXTOTAL) {
            return (V)this.getPxtotal();
        }
        if (attribute == DB2ConnectionType.PRQCUR) {
            return (V)this.getPrqcur();
        }
        if (attribute == DB2ConnectionType.PRQHWM) {
            return (V)this.getPrqhwm();
        }
        if (attribute == DB2ConnectionType.CCALLS) {
            return (V)this.getCcalls();
        }
        if (attribute == DB2ConnectionType.CSIGNONS) {
            return (V)this.getCsignons();
        }
        if (attribute == DB2ConnectionType.CTTERM) {
            return (V)this.getCtterm();
        }
        if (attribute == DB2ConnectionType.CTOVERF) {
            return (V)this.getCtoverf();
        }
        if (attribute == DB2ConnectionType.CTLIMIT) {
            return (V)this.getCtlimit();
        }
        if (attribute == DB2ConnectionType.CTCURR) {
            return (V)this.getCtcurr();
        }
        if (attribute == DB2ConnectionType.TCBFREE) {
            return (V)this.getTcbfree();
        }
        if (attribute == DB2ConnectionType.CTHWM) {
            return (V)this.getCthwm();
        }
        if (attribute == DB2ConnectionType.TCBRDYQCURR) {
            return (V)this.getTcbrdyqcurr();
        }
        if (attribute == DB2ConnectionType.TCBRDYQHWM) {
            return (V)this.getTcbrdyqhwm();
        }
        if (attribute == DB2ConnectionType.DATA_SHARING_GROUP_ID) {
            return (V)this.getDataSharingGroupID();
        }
        if (attribute == DB2ConnectionType.RESYNCMEMBER) {
            return (V)this.getResyncmember();
        }
        if (attribute == DB2ConnectionType.CHANGE_USER_ID) {
            return (V)this.getChangeUserID();
        }
        if (attribute == DB2ConnectionType.CHANGE_AGENT) {
            return (V)this.getChangeAgent();
        }
        if (attribute == DB2ConnectionType.CHANGE_AGENT_RELEASE) {
            return (V)this.getChangeAgentRelease();
        }
        if (attribute == DB2ConnectionType.INSTALL_AGENT) {
            return (V)this.getInstallAgent();
        }
        if (attribute == DB2ConnectionType.CHANGE_TIME) {
            return (V)this.getChangeTime();
        }
        if (attribute == DB2ConnectionType.DEFINE_SOURCE) {
            return (V)this.getDefineSource();
        }
        if (attribute == DB2ConnectionType.DEFINE_TIME) {
            return (V)this.getDefineTime();
        }
        if (attribute == DB2ConnectionType.INSTALL_USER_ID) {
            return (V)this.getInstallUserID();
        }
        if (attribute == DB2ConnectionType.INSTALL_TIME) {
            return (V)this.getInstallTime();
        }
        if (attribute == DB2ConnectionType.BASDEFINEVER) {
            return (V)this.getBasdefinever();
        }
        if (attribute == DB2ConnectionType.REUSELIMIT) {
            return (V)this.getReuselimit();
        }
        if (attribute == DB2ConnectionType.PREUSELIMCT) {
            return (V)this.getPreuselimct();
        }
        return super.getAttributeValue(attribute);
    }

    public DB2ConnectionType getObjectType() {
        return DB2ConnectionType.getInstance();
    }

    @Override
    public DB2ConnectionReference getCICSObjectReference() {
        return new DB2ConnectionReference(this.getCICSContainer(), this.getName());
    }
}

