/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.JVMClassCacheReference;
import com.ibm.cics.core.model.JVMClassCacheType;
import com.ibm.cics.core.model.internal.MutableCICSResource;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSEnums;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.IJVMClassCache;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableJVMClassCache;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Date;

public class MutableJVMClassCache
extends MutableCICSResource
implements IMutableJVMClassCache {
    private IJVMClassCache delegate;
    private MutableSMRecord record;

    public MutableJVMClassCache(ICPSM cpsm, IContext context, IJVMClassCache cicsObject) {
        super(cpsm, context, (ICICSResource)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("CLCACHE");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    public Long getPhasingOut() {
        return this.delegate.getPhasingOut();
    }

    public ICICSEnums.EnablementValue getAutostartst() {
        String result = this.record.get("AUTOSTARTST");
        if (result == null) {
            return this.delegate.getAutostartst();
        }
        return (ICICSEnums.EnablementValue)((CICSAttribute)JVMClassCacheType.AUTOSTARTST).get(result, this.record.getNormalizers());
    }

    public Long getOldcaches() {
        return this.delegate.getOldcaches();
    }

    public String getProfile() {
        return this.delegate.getProfile();
    }

    public Long getCachesize() {
        return this.delegate.getCachesize();
    }

    public Long getCachefree() {
        return this.delegate.getCachefree();
    }

    public IJVMClassCache.StatusValue getStatus() {
        return this.delegate.getStatus();
    }

    public Date getStarttime() {
        return this.delegate.getStarttime();
    }

    public Long getTotaljvms() {
        return this.delegate.getTotaljvms();
    }

    public IJVMClassCache.ReusestValue getReusest() {
        return this.delegate.getReusest();
    }

    public Long getPeakcachejvm() {
        return this.delegate.getPeakcachejvm();
    }

    public Long getJvmreqscache() {
        return this.delegate.getJvmreqscache();
    }

    public void setAutostartst(ICICSEnums.EnablementValue _autostartst) {
        if (_autostartst.equals((Object)this.delegate.getAutostartst())) {
            this.record.set("AUTOSTARTST", null);
        } else {
            JVMClassCacheType.AUTOSTARTST.validate((Object)_autostartst);
            String connectionSpecificExternalValue = ((CICSAttribute)JVMClassCacheType.AUTOSTARTST).set(_autostartst, this.record.getNormalizers());
            this.record.set("AUTOSTARTST", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == JVMClassCacheType.PHASING_OUT) {
            return (V)this.getPhasingOut();
        }
        if (attribute == JVMClassCacheType.AUTOSTARTST) {
            return (V)this.getAutostartst();
        }
        if (attribute == JVMClassCacheType.OLDCACHES) {
            return (V)this.getOldcaches();
        }
        if (attribute == JVMClassCacheType.PROFILE) {
            return (V)this.getProfile();
        }
        if (attribute == JVMClassCacheType.CACHESIZE) {
            return (V)this.getCachesize();
        }
        if (attribute == JVMClassCacheType.CACHEFREE) {
            return (V)this.getCachefree();
        }
        if (attribute == JVMClassCacheType.STATUS) {
            return (V)this.getStatus();
        }
        if (attribute == JVMClassCacheType.STARTTIME) {
            return (V)this.getStarttime();
        }
        if (attribute == JVMClassCacheType.TOTALJVMS) {
            return (V)this.getTotaljvms();
        }
        if (attribute == JVMClassCacheType.REUSEST) {
            return (V)this.getReusest();
        }
        if (attribute == JVMClassCacheType.PEAKCACHEJVM) {
            return (V)this.getPeakcachejvm();
        }
        if (attribute == JVMClassCacheType.JVMREQSCACHE) {
            return (V)this.getJvmreqscache();
        }
        return super.getAttributeValue(attribute);
    }

    public JVMClassCacheType getObjectType() {
        return JVMClassCacheType.getInstance();
    }

    @Override
    public JVMClassCacheReference getCICSObjectReference() {
        return new JVMClassCacheReference(this.getCICSContainer());
    }
}

